/* Patrick A. Worfolk
   January 20, 1990
   Fractal dimension algorithm functions
*/

#define MAX_LONG_VALUE 2147483648.0  /* maximum positive integer 2^31 */
#define TRUE 1
#define FALSE 0


/* CHECK_MAX_SCALES computes scale^n.
   Error checking:  If scale^n is greater than the machine integer
   limits then n is set to the maximum possible value.  If scale is
   greater than MAX_LONG_VALUE then scale is reset to 2.
   */
dims_check_max_scales(pscale,pn)
double *pscale;
int *pn;
{
	int i;
	double max;

	max=*pscale;
	if (*pscale>MAX_LONG_VALUE) {
		*pscale = 2.0;
		system_mess_proc(1,
		  "Scaling factor is too large.  Defaulted to 2.");
		}
	for (i=1; ((i<*pn) && (max <= MAX_LONG_VALUE)); i++) {
		max *= *pscale;
		}
	if (max > MAX_LONG_VALUE) {
		*pn = i-1;
		system_mess_proc(1,
		  "Cannot compute full number of scales accurately.");
		}
}


/* RESCALE multiplies each element in the data array by factor.
   */
dims_rescale(data,xsize,ysize,factor)
int xsize,ysize;
double **data,factor;
{
	int i,j;

	for (i=0; i<xsize; ++i) {
		for (j=0; j<ysize; ++j) {
			data[i][j] *= factor;
			}
		}
}


/* NORMALIZE converts a double float array into one where every
   point has a value between zero and one.
   Note: the subscripts of the arrays are reversed.
   */
dims_normalize(data,norm_data,length,dimens,max,min)
double **data,**norm_data,*max,*min;
int length,dimens;
{
	int i,j;
	double scale_factor;

        for (j=0; j<dimens; j++) {
		if (max[j]==min[j]) scale_factor=0;
                else scale_factor =  0.999999999999 / (max[j]-min[j]);
                for (i=0; i<length; i++) {
                       norm_data[i][j] = (data[j][i]-min[j]) * scale_factor;
                        }
                }
}



/* COUNT counts the number of unique elements in a sorted list.
   Uniqueness is determined only by integral part.
   data[x][y] is considered as a list where x indexes the different
   elements and y indexes the different components of one element.
   Also computes the entropy of the system.
   */
dims_count(data,xsize,ysize,ptotal,pentropy)
double **data,*pentropy;
int xsize,ysize,*ptotal;
{
	int i,j,total,equal,counter;
	double entropy,log2();

       	total = 1; /* first element is always unique */
	counter = 1;
	entropy=0;
       	for (i=0; i<xsize-1; i++) { /* do comparisons */
               	equal = TRUE;
               	for (j=0; equal && (j<ysize); j++) {
                       	if (((int) data[i][j]) != ((int) data[i+1][j])) 
				equal = FALSE;
                       	}
                if (!equal) {
			++total;
			if (counter>1) {
				entropy += (counter*log2((double) counter));
				counter=1;
				}
			}
		else counter++;
               	}
	entropy += (counter*log2((double) counter));
	*ptotal = total;
	*pentropy=entropy;
}


