/*
### Symplectic reversible Ruth (Explicit 2nd order) ###
*/

symp_rruth_int_one(vy,vx,ptime,time_step,dim)
double vy[],vx[],*ptime,time_step;
int dim;
{
	int i;
	double time_step2;
	extern int model;
	extern double *t_v,*t_vf,*param;
	extern int (*f_p)();

	time_step2 = time_step/2;
	
	/* phi (t/2) */
	(int) f_p(vy,1,vx,param,*ptime,dim);
	for(i=0;i<dim;i += 2) vy[i] = vx[i] + time_step2 * vy[i];
	(int) f_p(t_vf,2,vy,param,*ptime,dim);
	for(i=1;i<dim;i += 2) vy[i] = vx[i] + time_step2 * t_vf[i];
	/* R phi (t/2) */
	for(i=0;i<dim;i += 2) t_v[i] = vy[i]; 
	for(i=1;i<dim;i += 2) t_v[i] = -vy[i]; 

	/* phi-1 (t/2) R phi (t/2) */
	(int) f_p(vy,2,t_v,param,*ptime,dim);
	for(i=1;i<dim;i += 2) vy[i] = t_v[i] - time_step2 * vy[i];
	(int) f_p(t_vf,1,vy,param,*ptime,dim);
	for(i=0;i<dim;i += 2) vy[i] = t_v[i] - time_step2 * t_vf[i];
	/* R phi-1 (t/2) R phi (t/2) */
	for(i=1;i<dim;i += 2) vy[i] = -vy[i]; 

	*ptime += time_step;
}
