/* 
This is a modified version of sgraphlib for kaos
=================================================
Bug:
	circle: draw filled circle
	arc: draw filled arc + strange object
	title label: not located properly
*/
#include <math.h>
#include <suntool/sunview.h>
#include <suntool/canvas.h>
#include <sunwindow/cms_rainbow.h>

#define CMAP_SIZE 128
static unsigned char red[CMAP_SIZE],green[CMAP_SIZE],blue[CMAP_SIZE];
static int my_colormap_size=CMAP_SIZE;
static double twopi=6.2831853071795864; 

Frame graph_frame;
Canvas graph_canvas;
Pixwin *graph_pw;
Pixfont *graph_font;

static int graph_xwindow=400,graph_ywindow=400;
static int graph_xcanvas,graph_ycanvas;
static int graph_xwidth,graph_ywidth;
static int graph_lmargin=10,graph_bmargin=10;

static int color=1;	/* current color */
static int graph_xc=0,graph_yc=0;	/* current point */
static int graph_xmin,graph_xmax,graph_ymin,graph_ymax;	/* bounds in graph coordinates */
static int graph_npts[1] = {100};
static struct pr_pos graph_vlist[100];

openpl()
{
	void window_init();

	window_init();
	create_graph_frame();
	create_graph_canvas();
	graph_pw = (Pixwin *) canvas_pixwin(graph_canvas);
	graph_font = (Pixfont *) pf_open("/usr/lib/fonts/fixedwidthfonts/screen.b.12");
	cms_rainbowsetup(red,green,blue);
	pw_setcmsname(graph_pw,"graph colormap");
	pw_putcolormap(graph_pw,0,my_colormap_size,red,green,blue);
}

space(x1,y1,x2,y2)
int x1,y1,x2,y2;
{
	graph_xmin = x1;
	graph_ymin = y1;
	graph_xmax = x2;
	graph_ymax = y2;
	if(graph_xmin>graph_xmax) {
		printf("Error: graph_xmin > graph_xmax.\n");
		exit(0);
	}
	if(graph_ymin>graph_ymax) {
		printf("Error: graph_ymin > graph_ymax.\n");
		exit(0);
	}
	graph_xc = 0;
	graph_yc = 0;
}	

erase()
{
	 pw_writebackground(graph_pw,0,0,window_get(graph_canvas,CANVAS_WIDTH),
	 	window_get(graph_canvas,CANVAS_HEIGHT),PIX_CLR);
}

label(s)
char *s;
{
	int xt,yt;
	xt = graph_xc;
	yt = graph_yc;
	to_sun_coords(&xt,&yt);
	pw_text(graph_pw,xt,yt,(PIX_SRC|PIX_DST)|PIX_COLOR(color),graph_font,s);
}

line(x1,y1,x2,y2)
int x1,y1,x2,y2;
{
	graph_xc = x2;
	graph_yc = y2;
	to_sun_coords(&x1,&y1);
	to_sun_coords(&x2,&y2);
	pw_vector(graph_pw,x1,y1,x2,y2,PIX_SRC|PIX_COLOR(color),1);
}

circle(x,y,r)
int x,y,r;
{
	int i,ii,imax,dum;
	double thetai;

	graph_xc = x;
	graph_yc = y;
	to_sun_coords(&x,&y);
	to_sun_coords(&r,&dum);
	imax = (int) twopi * r;
	if(imax>100)
		imax = 100;
	for(i=0;i<imax;i++){
		thetai = twopi * i / imax;
		graph_vlist[i].x = r * cos(thetai);
		graph_vlist[i].y = r * sin(thetai);
	}
	pw_polygon_2(graph_pw,x,y,1,graph_npts,graph_vlist,PIX_SRC|PIX_COLOR(color),(Pixrect *)0,0,0);
}

arc(x,y,x0,y0,x1,y1)
int x,y,x0,y0,x1,y1;
{
	int i,ii,imax;
	double r,r2,theta,thetai;

	graph_xc = x;
	graph_yc = y;
	to_sun_coords(&x,&y);
	to_sun_coords(&x0,&y0);
	to_sun_coords(&x1,&y1);

	r2 = (x0-x)*(x0-x)+(y0-y)*(y0-y);
	r = sqrt(r2);
	theta = acos(((x1-x)*(x0-x)+(y1-y)*(y0-y))/r2);
	theta = ((x0-x)*(y1-y)-(x1-x)*(y0-y)) > 0 ? theta : twopi - theta;
	imax = (int) theta/twopi*r;
	if(imax>100)
		imax = 100;
	for(i=0;i<imax;i++){
		thetai = theta * i / imax;
		graph_vlist[i].x = r * cos(thetai);
		graph_vlist[i].y = r * sin(thetai);
	}
	pw_polygon_2(graph_pw,x,y,1,graph_npts,graph_vlist,PIX_SRC|PIX_COLOR(color),0,0,0);
}

move(x,y)
int x,y;
{
	graph_xc = x;
	graph_yc = y;
}

cont(x,y)
int x,y;
{
	int xt,yt;
	xt = graph_xc;
	yt = graph_yc;
	graph_xc = x;
	graph_yc = y;
	to_sun_coords(&xt,&yt);
	to_sun_coords(&x,&y);
	pw_vector(graph_pw,xt,yt,x,y,PIX_SRC|PIX_COLOR(color),1);
}

point(x,y)
int x,y;
{
	graph_xc = x;
	graph_yc = y;
	to_sun_coords(&x,&y);
	/*
	pw_put(graph_pw,x,y,1);
	*/
	pw_rop(graph_pw,x,y,1,1,PIX_SRC|PIX_COLOR(color),0,0,0);
}

linemod(s)
char *s;
{
	extern int color;

	if(strcmp(s,"disconnected")==0){
		color = 93;
	}
	else if(strcmp(s,"solid")==0){
		color = 59; /* for kaos */
	}	
	else if(strcmp(s,"dotted")==0){
		color = 3;
	}	
	else if(strcmp(s,"dotdashed")==0){
		color = 4;
	}	
	else if(strcmp(s,"shortdashed")==0){
		color = 5;
	}	
	else if(strcmp(s,"longdashed")==0){
		color = 6;
	}	
}

closepl()
{
	window_main_loop(graph_frame);
}

closevt()
{
	window_main_loop(graph_frame);
}

create_graph_frame()
{
	graph_frame = window_create(NULL,FRAME,
		FRAME_NO_CONFIRM,FALSE,
		FRAME_SHOW_LABEL,TRUE,
		FRAME_LABEL,"sgraph",
		WIN_X,300,
		WIN_Y,300,
		WIN_WIDTH,graph_xwindow,
		WIN_HEIGHT,graph_ywindow,
		0);
	if(graph_frame == NULL) {
		printf("No more windows. Clean up some windows to make room.\n");	
		exit(0);
	}
}

create_graph_canvas()
{
	void handle_event(),canvas_resize_proc(),canvas_repaint_proc();

	graph_canvas = window_create(graph_frame, CANVAS,
		CANVAS_RETAINED,	TRUE,
	        CANVAS_AUTO_SHRINK,     TRUE,
	        CANVAS_AUTO_EXPAND,     TRUE,
	        CANVAS_WIDTH,           graph_xcanvas,
	        CANVAS_HEIGHT,          graph_ycanvas,
		WIN_CONSUME_PICK_EVENTS,     WIN_MOUSE_BUTTONS,	LOC_DRAG,0,
		WIN_EVENT_PROC,             handle_event,
		CANVAS_RESIZE_PROC,	canvas_resize_proc,
		CANVAS_REPAINT_PROC,	canvas_repaint_proc,
		0);
	if(graph_canvas == NULL) {
		printf("No more windows. Clean up some windows to make room.\n");	
		exit(0);
	}
}

to_sun_coords(xp,yp)
int *xp,*yp;
{
	*xp = (int) (graph_lmargin + graph_xwidth * (*xp-graph_xmin)/(graph_xmax-graph_xmin));
	*yp = (int) (graph_ycanvas - graph_ywidth * (*yp-graph_ymin)/(graph_ymax-graph_ymin) - graph_bmargin);
}

void window_init()
{
	graph_xcanvas = graph_xwindow -10;
	graph_ycanvas = graph_ywindow -15;
	graph_xwidth = graph_xcanvas-graph_lmargin*2;
	graph_ywidth = graph_ycanvas-graph_bmargin*2;
}

void handle_event()
{
}

void canvas_resize_proc()
{
	void window_init();
	extern Frame graph_frame;
	extern int graph_xwindow,graph_ywindow;

	graph_xwindow = (int) window_get(graph_frame,WIN_WIDTH);
	graph_ywindow = (int) window_get(graph_frame,WIN_HEIGHT);
	(void) window_init();
}

void canvas_repaint_proc()
{
	draw_all();
}
