/*
### create an auto window ###
*/

#include "../include/auto_kaos_def.h"
#include <suntool/sunview.h>
#include <suntool/panel.h>
#include <suntool/textsw.h>


void create_auto_windows()
{

	int i,ipanel_row;
	extern short auto_panel_show;
	extern int ycanvas,ywidth,b_margin;
	extern Frame frame,auto_frame;
	extern Panel auto_panel;
	extern Panel_item auto_panel_quit_item,auto_panel_go_item, auto_panel_load_item, auto_panel_write_init_item,
		auto_dir_name_item, auto_file_name_item, auto_input_name_item;
	extern Pixfont *boldfont;
	extern Textsw auto_textsw;
	extern Textsw_status auto_status; 
	extern char string[],string2[],auto_dir_name[],auto_file_name[],auto_input_name[];
        void auto_panel_quit_proc(),auto_panel_go_proc(),auto_panel_load_proc(),auto_panel_write_init_proc();
	/* AUTO86 declerations */
	extern int panel_colormap_on;
	extern int auto_ndim,auto_ips,auto_irs,auto_ilp;
	extern int auto_ntst,auto_ncol,auto_iad,auto_isp,auto_isw,auto_iplt;
	extern int auto_nbc,auto_nint,auto_nmx,auto_npr,auto_mxbf,auto_iid;
	extern int auto_itmx,auto_itnw,auto_nwtn,auto_jac,auto_nuzr;
	extern int auto_n1,auto_n2,auto_nfpar,auto_icp[];
	extern double auto_rl0,auto_rl1,auto_a0,auto_a1,auto_par[];
	extern double auto_epsu,auto_epss,auto_epsl[],auto_ds,auto_dsmin,auto_dsmax;
	extern double auto_thetau,auto_thetal[];

	extern Panel_item auto_ndim_item,auto_ips_item,auto_irs_item,auto_ilp_item;
	extern Panel_item auto_ntst_item,auto_ncol_item,auto_iad_item,auto_isp_item,auto_isw_item,auto_iplt_item;
	extern Panel_item auto_nbc_item,auto_nint_item,auto_nmx_item,auto_npr_item,auto_mxbf_item,auto_iid_item;
	extern Panel_item auto_itmx_item,auto_itnw_item,auto_nwtn_item,auto_jac_item,auto_nuzr_item;
	extern Panel_item auto_nfpar_item,auto_icp_item[];
	extern Panel_item auto_rl0_item,auto_rl1_item,auto_a0_item,auto_a1_item,auto_par_item[];
	extern Panel_item auto_epsu_item,auto_epss_item,auto_epsl_item[],auto_ds_item,auto_dsmin_item,auto_dsmax_item;
	extern Panel_item auto_thetau_item,auto_thetal_item[];

	if(auto_panel_show){
        	window_set(auto_frame, WIN_SHOW, TRUE,0);
		return;
	}
	else
		auto_panel_show = 1;

	ipanel_row=0;
        auto_frame = window_create(frame,FRAME,FRAME_LABEL,"auto",
                FRAME_SHOW_LABEL,       TRUE,
		FRAME_NO_CONFIRM,	TRUE,
                WIN_SHOW,       TRUE,
                WIN_X, 0,
		WIN_Y, ycanvas-b_margin-ywidth,
		WIN_WIDTH,	800,
		WIN_HEIGHT,	600,
		WIN_FONT, boldfont,
                0);
	if(auto_frame == NULL) {
		system_mess_proc(1,"No more windows. Clean up some windows to make room.");
		(void) destroy_auto_windows();
		return;
	}

	ipanel_row=0;
        auto_panel = window_create(auto_frame, PANEL,
		WIN_X,	0,
		WIN_Y,	0,
		WIN_FONT, boldfont,
		0);
	if(auto_panel == NULL) {
		system_mess_proc(1,"No more windows. Clean up some windows to make room.");
		(void) destroy_auto_windows();
		return;
	}
        auto_panel_quit_item= panel_create_item(auto_panel,PANEL_BUTTON,
                PANEL_LABEL_Y,  ATTR_ROW(ipanel_row++),
                PANEL_LABEL_X,  ATTR_COL(0),
                PANEL_LABEL_IMAGE,panel_button_image(auto_panel,"Quit",8,boldfont),
                PANEL_NOTIFY_PROC,auto_panel_quit_proc,
                0);
        auto_panel_go_item= panel_create_item(auto_panel,PANEL_BUTTON,
                PANEL_LABEL_X,  ATTR_COL(10),
                PANEL_LABEL_IMAGE,panel_button_image(auto_panel,"Go",8,boldfont),
                PANEL_NOTIFY_PROC,auto_panel_go_proc,
                0);
        auto_panel_load_item= panel_create_item(auto_panel,PANEL_BUTTON,
                PANEL_LABEL_X,  ATTR_COL(20),
                PANEL_LABEL_IMAGE,panel_button_image(auto_panel,"Load",8,boldfont),
                PANEL_NOTIFY_PROC,auto_panel_load_proc,
                0);
        auto_panel_write_init_item= panel_create_item(auto_panel,PANEL_BUTTON,
                PANEL_LABEL_X,  ATTR_COL(30),
                PANEL_LABEL_IMAGE,panel_button_image(auto_panel,"Write Init",9,boldfont),
                PANEL_NOTIFY_PROC,auto_panel_write_init_proc,
                0);
        auto_dir_name_item = panel_create_item(auto_panel,PANEL_TEXT,
                PANEL_LABEL_Y,  ATTR_ROW(ipanel_row++),
                PANEL_LABEL_X,  ATTR_COL(0),
                PANEL_VALUE,    auto_dir_name,
                PANEL_VALUE_DISPLAY_LENGTH, 40,
                PANEL_LABEL_STRING, "Dir:",
                0);
        auto_file_name_item = panel_create_item(auto_panel,PANEL_TEXT,
                PANEL_LABEL_Y,  ATTR_ROW(ipanel_row++),
                PANEL_LABEL_X,  ATTR_COL(0),
                PANEL_VALUE,    auto_file_name,
                PANEL_VALUE_DISPLAY_LENGTH, 30,
                PANEL_LABEL_STRING, "Command:",
                0);
        auto_input_name_item = panel_create_item(auto_panel,PANEL_TEXT,
                PANEL_LABEL_X,  ATTR_COL(40),
                PANEL_VALUE,    auto_input_name,
                PANEL_VALUE_DISPLAY_LENGTH, 30,
                PANEL_LABEL_STRING, "Input File:",
                0);

	sprintf(string,"%lg",auto_rl0);
        auto_rl0_item = panel_create_item(auto_panel,PANEL_TEXT,
                PANEL_LABEL_Y,  ATTR_ROW(ipanel_row++),
                PANEL_LABEL_X,  ATTR_COL(0),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 16,
                PANEL_LABEL_STRING, "rl0:",
                0);
	sprintf(string,"%lg",auto_rl1);
        auto_rl1_item = panel_create_item(auto_panel,PANEL_TEXT,
                PANEL_LABEL_X,  ATTR_COL(25),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 16,
                PANEL_LABEL_STRING, "rl1:",
                0);
	sprintf(string,"%lg",auto_a0);
        auto_a0_item = panel_create_item(auto_panel,PANEL_TEXT,
                PANEL_LABEL_X,  ATTR_COL(50),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 16,
                PANEL_LABEL_STRING, "a0:",
                0);
	sprintf(string,"%lg",auto_a1);
        auto_a1_item = panel_create_item(auto_panel,PANEL_TEXT,
                PANEL_LABEL_X,  ATTR_COL(75),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 16,
                PANEL_LABEL_STRING, "a1:",
                0);

	sprintf(string,"%lg",auto_epsu);
        auto_epsu_item = panel_create_item(auto_panel,PANEL_TEXT,
                PANEL_LABEL_Y,  ATTR_ROW(ipanel_row++),
                PANEL_LABEL_X,  ATTR_COL(0),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 16,
                PANEL_LABEL_STRING, "epsu:",
                0);
	sprintf(string,"%lg",auto_epss);
        auto_epss_item = panel_create_item(auto_panel,PANEL_TEXT,
                PANEL_LABEL_X,  ATTR_COL(25),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 16,
                PANEL_LABEL_STRING, "epss:",
                0);
	sprintf(string,"%lg",auto_epsl[0]);
        auto_epsl_item[0] = panel_create_item(auto_panel,PANEL_TEXT,
                PANEL_LABEL_X,  ATTR_COL(50),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 16,
                PANEL_LABEL_STRING, "epsl0:",
                0);
	sprintf(string,"%lg",auto_epsl[1]);
        auto_epsl_item[1] = panel_create_item(auto_panel,PANEL_TEXT,
                PANEL_LABEL_X,  ATTR_COL(75),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 16,
                PANEL_LABEL_STRING, "epsl1:",
                0);

	sprintf(string,"%lg",auto_ds);
        auto_ds_item = panel_create_item(auto_panel,PANEL_TEXT,
                PANEL_LABEL_Y,  ATTR_ROW(ipanel_row++),
                PANEL_LABEL_X,  ATTR_COL(0),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 16,
                PANEL_LABEL_STRING, "ds:",
                0);
	sprintf(string,"%lg",auto_dsmin);
        auto_dsmin_item = panel_create_item(auto_panel,PANEL_TEXT,
                PANEL_LABEL_X,  ATTR_COL(25),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 16,
                PANEL_LABEL_STRING, "dsmin:",
                0);
	sprintf(string,"%lg",auto_dsmax);
        auto_dsmax_item = panel_create_item(auto_panel,PANEL_TEXT,
                PANEL_LABEL_X,  ATTR_COL(50),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 16,
                PANEL_LABEL_STRING, "dsmax:",
                0);
                
	sprintf(string,"%lg",auto_thetau);
        auto_thetau_item = panel_create_item(auto_panel,PANEL_TEXT,
                PANEL_LABEL_Y,  ATTR_ROW(ipanel_row++),
                PANEL_LABEL_X,  ATTR_COL(0),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 16,
                PANEL_LABEL_STRING, "thetau:",
                0);
	sprintf(string,"%lg",auto_thetal[0]);
        auto_thetal_item[0] = panel_create_item(auto_panel,PANEL_TEXT,
                PANEL_LABEL_X,  ATTR_COL(25),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 16,
                PANEL_LABEL_STRING, "thetal0:",
                0);
	sprintf(string,"%lg",auto_thetal[1]);
        auto_thetal_item[1] = panel_create_item(auto_panel,PANEL_TEXT,
                PANEL_LABEL_X,  ATTR_COL(50),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 16,
                PANEL_LABEL_STRING, "thetal1:",
                0);

	sprintf(string,"%d",auto_ndim);
        auto_ndim_item = panel_create_item(auto_panel,PANEL_TEXT,
                PANEL_LABEL_Y,  ATTR_ROW(ipanel_row++),
                PANEL_LABEL_X,  ATTR_COL(0),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 6,
                PANEL_LABEL_STRING, "ndim:",
                0);
	sprintf(string,"%d",auto_ips);
        auto_ips_item = panel_create_item(auto_panel,PANEL_TEXT,
                PANEL_LABEL_X,  ATTR_COL(15),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 6,
                PANEL_LABEL_STRING, "ips:",
                0);
	sprintf(string,"%d",auto_irs);
        auto_irs_item = panel_create_item(auto_panel,PANEL_TEXT,
                PANEL_LABEL_X,  ATTR_COL(30),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 6,
                PANEL_LABEL_STRING, "irs:",
                0);
	sprintf(string,"%d",auto_ilp);
        auto_ilp_item = panel_create_item(auto_panel,PANEL_TEXT,
                PANEL_LABEL_X,  ATTR_COL(45),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 6,
                PANEL_LABEL_STRING, "ilp:",
                0);

	sprintf(string,"%d",auto_ntst);
        auto_ntst_item = panel_create_item(auto_panel,PANEL_TEXT,
                PANEL_LABEL_Y,  ATTR_ROW(ipanel_row++),
                PANEL_LABEL_X,  ATTR_COL(0),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 6,
                PANEL_LABEL_STRING, "ntst:",
                0);
	sprintf(string,"%d",auto_ncol);
        auto_ncol_item = panel_create_item(auto_panel,PANEL_TEXT,
                PANEL_LABEL_X,  ATTR_COL(15),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 6,
                PANEL_LABEL_STRING, "ncol:",
                0);
	sprintf(string,"%d",auto_iad);
        auto_iad_item = panel_create_item(auto_panel,PANEL_TEXT,
                PANEL_LABEL_X,  ATTR_COL(30),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 6,
                PANEL_LABEL_STRING, "iad:",
                0);
	sprintf(string,"%d",auto_isp);
        auto_isp_item = panel_create_item(auto_panel,PANEL_TEXT,
                PANEL_LABEL_X,  ATTR_COL(45),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 6,
                PANEL_LABEL_STRING, "isp:",
                0);
	sprintf(string,"%d",auto_isw);
        auto_isw_item = panel_create_item(auto_panel,PANEL_TEXT,
                PANEL_LABEL_X,  ATTR_COL(60),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 6,
                PANEL_LABEL_STRING, "isw:",
                0);
	sprintf(string,"%d",auto_iplt);
        auto_iplt_item = panel_create_item(auto_panel,PANEL_TEXT,
                PANEL_LABEL_X,  ATTR_COL(75),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 6,
                PANEL_LABEL_STRING, "iplt:",
                0);

	sprintf(string,"%d",auto_nbc);
        auto_nbc_item = panel_create_item(auto_panel,PANEL_TEXT,
                PANEL_LABEL_Y,  ATTR_ROW(ipanel_row++),
                PANEL_LABEL_X,  ATTR_COL(0),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 6,
                PANEL_LABEL_STRING, "nbc:",
                0);
	sprintf(string,"%d",auto_nint);
        auto_nint_item = panel_create_item(auto_panel,PANEL_TEXT,
                PANEL_LABEL_X,  ATTR_COL(15),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 6,
                PANEL_LABEL_STRING, "nint:",
                0);
	sprintf(string,"%d",auto_nmx);
        auto_nmx_item = panel_create_item(auto_panel,PANEL_TEXT,
                PANEL_LABEL_X,  ATTR_COL(30),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 6,
                PANEL_LABEL_STRING, "nmx:",
                0);
	sprintf(string,"%d",auto_npr);
        auto_npr_item = panel_create_item(auto_panel,PANEL_TEXT,
                PANEL_LABEL_X,  ATTR_COL(45),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 6,
                PANEL_LABEL_STRING, "npr:",
                0);
	sprintf(string,"%d",auto_mxbf);
        auto_mxbf_item = panel_create_item(auto_panel,PANEL_TEXT,
                PANEL_LABEL_X,  ATTR_COL(60),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 6,
                PANEL_LABEL_STRING, "mxbf:",
                0);
	sprintf(string,"%d",auto_iid);
        auto_iid_item = panel_create_item(auto_panel,PANEL_TEXT,
                PANEL_LABEL_X,  ATTR_COL(75),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 6,
                PANEL_LABEL_STRING, "iid:",
                0);
                
	sprintf(string,"%d",auto_itmx);
        auto_itmx_item = panel_create_item(auto_panel,PANEL_TEXT,
                PANEL_LABEL_Y,  ATTR_ROW(ipanel_row++),
                PANEL_LABEL_X,  ATTR_COL(0),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 6,
                PANEL_LABEL_STRING, "itmx:",
                0);
	sprintf(string,"%d",auto_itnw);
        auto_itnw_item = panel_create_item(auto_panel,PANEL_TEXT,
                PANEL_LABEL_X,  ATTR_COL(15),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 6,
                PANEL_LABEL_STRING, "itnw:",
                0);
	sprintf(string,"%d",auto_nwtn);
        auto_nwtn_item = panel_create_item(auto_panel,PANEL_TEXT,
                PANEL_LABEL_X,  ATTR_COL(30),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 6,
                PANEL_LABEL_STRING, "nwtn:",
                0);
	sprintf(string,"%d",auto_jac);
        auto_jac_item = panel_create_item(auto_panel,PANEL_TEXT,
                PANEL_LABEL_X,  ATTR_COL(45),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 6,
                PANEL_LABEL_STRING, "jac:",
                0);
	sprintf(string,"%d",auto_nuzr);
        auto_nuzr_item = panel_create_item(auto_panel,PANEL_TEXT,
                PANEL_LABEL_X,  ATTR_COL(60),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 6,
                PANEL_LABEL_STRING, "nuzr:",
                0);
                
	sprintf(string,"%d",auto_nfpar);
        auto_nfpar_item = panel_create_item(auto_panel,PANEL_TEXT,
                PANEL_LABEL_Y,  ATTR_ROW(ipanel_row++),
                PANEL_LABEL_X,  ATTR_COL(0),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 6,
                PANEL_LABEL_STRING, "nfpar:",
                0);
	
	for(i=0;i<AUTO_NFPAR_MAX;i++){
		sprintf(string,"%d",auto_icp[i]);
		sprintf(string2,"icp%d",i);
        	auto_icp_item[i] = panel_create_item(auto_panel,PANEL_TEXT,
                	PANEL_LABEL_X,  ATTR_COL((i+1) * 15),
                	PANEL_VALUE,    string,
                	PANEL_VALUE_DISPLAY_LENGTH, 6,
                	PANEL_LABEL_STRING, string2,
                	0);
	}

	for(i=0;i<AUTO_ALL_PARAM_DIM;i++){
		sprintf(string,"%lg",auto_par[i]);
		sprintf(string2,"P%d:",i);
        	auto_par_item[i] = panel_create_item(auto_panel,PANEL_TEXT,
                	PANEL_LABEL_Y,  ATTR_ROW(ipanel_row),
                	PANEL_LABEL_X,  ATTR_COL((i % 4) * 20),
                	PANEL_VALUE,    string,
                	PANEL_VALUE_DISPLAY_LENGTH, 16,
                	PANEL_LABEL_STRING, string2,
                	0);
		if(i % 4 == 3)
			ipanel_row++;
	}

	window_fit_height(auto_panel);
	if(panel_colormap_on)
		init_panel_colormap((Pixwin *) window_get(auto_panel,WIN_PIXWIN),"auto_panel_cms");


        sprintf(string,"%s/%s",auto_dir_name,auto_input_name);
        auto_textsw = window_create(auto_frame, TEXTSW,
		0);
	if(auto_textsw == NULL){
		system_mess_proc(1,"No more windows. Clean up some windows to make room.");
		(void) destroy_auto_windows();
		return;
	}
        window_set(auto_textsw,
                TEXTSW_STATUS, &auto_status,
                TEXTSW_FILE,string,
                TEXTSW_FIRST,0,
                0);
        if(auto_status == TEXTSW_STATUS_CANNOT_OPEN_INPUT){
                sprintf(string2,"File (%s) does not exist!\n",string);
		system_mess_proc(1,string2);
        }       
	if(panel_colormap_on)
		init_panel_colormap((Pixwin *) window_get(auto_textsw,WIN_PIXWIN),"auto_textsw_cms");
}
