/*					    */
/***** irisio.c - Nina Amenta, Aug. 1989 ****/
/*					    */
#include <stdio.h>
#include <ctype.h>
#include <gl.h>
#include <device.h>
#include "symmetry.h"

typedef long EVENT;

DrawDot(p)
POINT *p;
{
    pnt2(p->x,p->y);
}

void PickLine(l)
LINE *l;
{
    popname();
    pushname(l->id);
    move2(l->m[SX],l->m[SY]);
    draw2(l->m[EX],l->m[EY]);
}

void DrawLine(l)
LINE *l;
{
    move2(l->m[SX],l->m[SY]);
    draw2(l->m[EX],l->m[EY]);
}

Flush()
{
}

LogTranslation(i)
int i;
{
  short s;
    s = i;
    popname();
    loadname(s);
    pushname(-1);
}

TranslateCoordinates(x,y,z)
float x,y,z;
{
    pushmatrix();
    translate(x,y,z);
}

TranslateBack()
{
    popmatrix();
}

char *KeyboardIO(numchars,x,y,str,scale)
int numchars;
float x,y;
char *str;
float scale;
{
    static char buffer[21];
    char* ptr;
    short newchar;
    EVENT ev;

    singlebuffer();
    gconfig();
    if (numchars>20) numchars=20;
    color(GREEN);
    rectf(scale*(x-3.0),scale*(y-3.0),scale*(x+228.0),scale*(y+12.0));
    color(BLACK);
    cmov2(scale*x,scale*y);
    charstr(str);
    ptr = buffer;
    if (numchars>0)
    {
	qreset();
        qdevice(KEYBD);
	while ((ev = qread(&newchar)) == KEYBD)
	{
	   if (ptr+1>=buffer+numchars) break;
	   if (!(isalnum(newchar) || (newchar == '.') || (newchar == '/'))) 
	       break;
	   *ptr++ = newchar;
	   *ptr = 0;
	   charstr(ptr-1);
	}
        unqdevice(KEYBD);
    }
   *ptr = 0;
    doublebuffer();
    gconfig();
    return(buffer);
}

DrawObject(obj,drawing_routine)
LINE *obj;
void (*drawing_routine) ();
{
LINE *l;
    for(l=obj; l!=NULL; l=l->next)
	drawing_routine(l);
}

