static char GWHAT[]="@(#)vidjdyx.h	2.15 (rl) 92/07/04";
/**********************************************************
* kaleido
*
*	Kaleidoscopic construction of uniform polyhedra
*
*	Author:
*		Dr. Zvi Har'El,
*		Deptartment of Mathematics,
*		Technion, Israel Institue of Technology,
*		Haifa 32000, Israel.
*		E-Mail: rl@gauss.technion.ac.il
**********************************************************/
#include <site.h>
#define BIGFONT "ncenI24.snf"
#define SMALLFONT "ncenI12.snf"
#define INTENSITY_DELTA 3
#define VIDEOSPLIT 0

static struct {
	FontPtr bigfont, smallfont;
	int color;
	double width, height;
	short x, y;
} video;

#define videoclose() vt_Close()
#define videoclear() (*vt_Clrscr)()
#define videoreadkey() vt_ReadKey()
#define videokeypressed() vt_KeyPressed()
#define videobeep() vt_Sound(1200,200)
#define videotitle(x,c) Font_Display(video.bigfont,x,0,25,c)
#define videosubtitle(x,c) Font_Display(video.smallfont,x,0,50,c)
#define videosubsub(x,c) Font_Display(video.smallfont,x,0,75,c)
#define videoredraw() 0 /*always fail*/
#define videomoveto(a,b) (video.x=a,video.y=b)
#define videosetcolor(c) (video.color=c)
#define videolineto(a,b) \
	((*vt_Line)(video.color,video.x,video.y,(short)(a),(short)(b)),\
	video.x=a,video.y=b)


static
videoinit(x,red,green,blue,light)
{
	int i;
	unsigned j;
	if (x<0) x = VGA_640;
	if (vt_Init (x)) return 0;
	if (vt_Colors < 16) return 0;
	video.width=vt_Width;
	video.height=vt_Height;
	for (i = 16, j=0; --i; j+=INTENSITY_DELTA) {
		vt_SetColorMapValue (i, !red?0:light?j:63-j, 
			!green?0:light?j:63-j, !blue?0:light?j:63-j);
	}
	vt_SetColorMapValue (0, !red||!light?0:63,
		!green||!light?0:63, !blue||!light?0:63);
	if (!(video.bigfont = Font_Load (BIGFONT))) return 0;
	if (!(video.smallfont = Font_Load (SMALLFONT))) return 0;
	return 1;
}
