static char WHAT[]="@(#)scope.c	2.38 (rl) 92/07/17";
/**********************************************************
* kaleido
*
*	Kaleidoscopic construction of uniform polyhedra
*
*	Author:
*		Dr. Zvi Har'El,
*		Deptartment of Mathematics,
*		Technion, Israel Institue of Technology,
*		Haifa 32000, Israel.
*		E-Mail: rl@gauss.technion.ac.il
**********************************************************/
#include "kaleido.h"
#ifdef MSDOS
#include "vidmsdos.h"
#else
#ifdef JDYX
#include "vidjdyx.h"
#else
#include "vidx11.h"
#endif
#endif
int gcont = VIDEOSPLIT;
vector center;
double radius;
/****************************************************************************
* Draw a polyhedron, given its vertices v[V] and edge list e[2][E].
*
* To enable drawing the duals of hemi-polyhedra, which have ideal vertices as
* the polar reciprocals of hemispherical faces, anti[V] may be
* given.
*
* anti[i] is set if the ray from the v[e[0][i]] to the ideal vertex v[e[1][i]]
* is anti-parallel to the (unit) vector representing that vertex.
*In a finite polyhedron, anti should be null.
*****************************************************************************/
scope (v, V, e, E, anti, title, subtitle, subsub, N, M, prefix)
vector *v;
short **e;
int V, E, N, M;
char *anti, *title, *subtitle, *subsub, *prefix;
{
	vector **vec, *old, *new, *p;
	short *s, *t;
	char c, *u;
	int toggle = 0, freeze = 0, notfirst = 0, step, i;
	static char freezing[] = "freezing...";

/*
* Allocate dynamic array.
* vec[2][V] holds vertex coordinates, before and after each rotation step.
*/
	if (!(vec = (vector**) matalloc (2, V * sizeof (vector))) ) {
		no_space();
		return 0;
	}

	videoclear();
	for (step = 0; ; step = (step + 1) % N) {
		if (!notfirst || videoredraw()) {
/*
* Display titles.
* Compute picture center and radius.
*/
			videotitle (title, 15);
			videosubtitle (subtitle, 15);
			videosubsub (subsub, 15);
			radius = min (video.width, video.height/1.2) / 2 ;
			center.x = video.width - radius;
			center.y = video.height - radius;
		}
/*
* Get original vertex coordinates or rotate old ones.
*/
		new = vec[toggle];
		old = vec[!toggle];
		toggle = !toggle;
		if (!step) memcpy((char*) new, (char*) v, V * sizeof(vector));
		else rotarray (new, old, V);
/*
* Draw new edges while erasing old ones.
* Edges are colored according to the z-coordinate of their midpoint:
* the higher - the dimmer (this is done because the vertices are generated
* by BFS from (0,0,1), which implies that points with lower z-coordinates
* are drawn later).
*/
		s = e[0];
		t = e[1];
		u = anti;
		for (i = E; i--; ) {
			vector temp;
			int j = *s++, k = *t++;
			if (!anti) {
				if(notfirst)
					draw (old[j], old[k], 0);
				draw (new[j], new[k], 1);
			} else if (*u++) {
				if(notfirst) {
					temp = scale (.5, old[j]);
					draw (temp, diff (temp, old[k]), 0);
				}
				temp = scale (.5, new[j]);
				draw (temp, diff (temp, new[k]), 1);
			} else {
				if(notfirst) {
					temp = scale (.5, old[j]);
					draw (temp, sum (temp, old[k]), 0);
				}
				temp = scale (.5, new[j]);
				draw (temp, sum (temp, new[k]), 1);
			}
		}
		notfirst = 1;

/*
* Check for user kyboard entry.
* If none, and no pending request to freeze, continue drawing.
*/
		if (!(c = videokeypressed ()) && !(freeze && step == M))
			continue;

		if (freeze) {
			videosubtitle (freezing, 0);
			videosubtitle (subtitle, 15);
			freeze = 0;
		}

/*
* If hit Enter, Backspace, Tab or Esc, free dynamic buffers and return.
*/
		if (c == '\n' || c == '\r' || c == '\b' || c == '\033' || c == '\t') {
			matfree (vec, 2);
			return c ;
		} 
/*
* If hit F, register request to freeze, and continue drawing.
*/
		if (c == 'F' || c == 'f') {
			videosubtitle (subtitle, 0);
			videosubtitle (freezing, 15);
			freeze = 1;
			continue;
		}
/*
* Wait for another key hit.
* If hit S, generate a pic snapshot and display file name.
*/
		if ((c = videoreadkey ()) == 'S' || c == 's') {
			char *fn;
			videosubtitle (subtitle, 0);
			fn = picfile (new, V, e, E, anti, title,
				subtitle, subsub, prefix);
			if (!fn) {
				static char failed[] = "write error";
				videobeep ();
				videosubtitle (failed, 15);
				videoreadkey ();
				videosubtitle (failed, 0);
			} else {
				videosubtitle (fn, 15);
				videoreadkey ();
				videosubtitle (fn, 0);
				free (fn);
			}
			videosubtitle (subtitle, 15);
		}
	}
}

int
ginit (mode, red, green, blue, light)
int mode,red,green,blue,light;
/* Initialize graphics */
{
	return videoinit (mode, red, green, blue, light);
}

gend ()
/* end graphics */
{
	videoclose ();
}


draw (a, b, pen)
vector a, b;
int pen;
/* draw a segment using variable brightness */
/* when erasing a segment (pen is zero), although variable brightness is
not needed, we still use the same partition to ensure correct erasure*/
{
	int i, i1, i2;
	double aa, bb;
	if (a.z < b.z) {/*swap endpoints to get increasing point size*/
		vector temp;
		temp = a;
		a = b;
		b = temp;
	}
	aa = 8 * (1 - a.z);
	bb = 8 * (1 - b.z);
	i1 = aa + 1;
	i2 = bb + 1;
	if (i1 < 1) i1 = 1;
	if (i2 > 15) i2 = 15;
	a = sum (center, scale (radius, a));
	b = sum (center, scale (radius, b));
	videomoveto (a.x, a.y);
	for (i = i1; i < i2; i++) {
		double f;
		f = ((double) i - aa) / (bb - aa);
		videosetcolor (pen ? i : 0);
		videolineto(a.x + (b.x - a.x) * f, a.y + (b.y - a.y) * f);
	}
	videosetcolor (pen ? i2 : 0);
	videolineto (b.x, b.y);
}
