/*@(#)kaleido.h	2.28 (rl) 92/07/20*/
/**********************************************************
* kaleido
*
*	Kaleidoscopic construction of uniform polyhedra
*
*	Author:
*		Dr. Zvi Har'El,
*		Technion, Israel Institue of Technology,
*		Haifa 32000, Israel.
*		E-Mail: rl@gauss.technion.ac.il
**********************************************************/
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <math.h>

#ifndef MAXLONG
#define MAXLONG 0x7FFFFFFF
#endif
#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif
#ifndef DBL_EPSILON
#define DBL_EPSILON 2.2204460492503131e-16
#endif
#define BIG_EPSILON 3e-2
#define DEG (180/M_PI)
#define AZ M_PI/7 /* axis azimuth */
#define EL M_PI/17 /* axis elevation */

#define VAL (argp=s[1]?s+1:(argc--,*++argv),s="-",!argp?(char*)usage():argp)
#define no_space() fprintf(stderr,"%s:%d: Not enough memory\n",\
__FILE__,__LINE__);
#define abs(x) (x<0?-(x):x)
#define min(x,y) (x<y?x:y)
#define numerator(x) (frac(x),frax.n)
#define denominator(x) (frac(x),frax.d)
#define compl(x) (frac (x),(double)frax.n/(frax.n - frax.d))

typedef struct {double x,y,z;} vector;
typedef struct {long n,d;} rational;

extern vector rotate(), sum3(), scale(), sum(), diff(), pole();
extern double dot();
extern char *picfile(), *sprintfrac(), **matalloc();
extern int gcont;

extern char *malloc(), *realloc(), *getenv();
extern int errno;
