#include	"pdefs.h"
#include	"stdio.h"
#include	"math.h"
#include	<X11/Xlib.h>
#include	<X11/Xutil.h>
#include	<X11/cursorfont.h>
#include	<X11/Intrinsic.h>

Display		*dpy;				/* display device */
Window		domainwin, rangewin, drawwin;	/* windows invoked */
GC		gc;				/* graphics context */
int		width, height;			/* dimensions of the circleinfo and plotinfo arrays */
int		numcircles;			/* the number of circles in the circle domain */
int		fixradi, fixradj;		/* circleinfo indices of a circle of fixed radius */
int		nulli, nullj;			/* circleinfo indices of the nullcircle */
double		fillrad;			/* filling radius */
circleinfo	*DCirc, *RCirc;			/* info of domain and range packings */
int		*mycolor;			/* array of color pixel indices assigned to circles */
double		umin, umax, vmin, vmax;		/* bounding rectangle of range */
double		maxkappa;			/* Maximum |curvature| */
int		hw;				/* (width-1)*(height-1)+1 */

Bool		nullok();		/* Checks whether nullpoint is acceptable */
Bool		inside();		/* Checks whether a certain point is interior in the packing */
int		packingmode;		/* 1 for tangent packings, 2 for prescribed angle intersections */
	
double		*curvature;		/* vector of curvature values */
int		N;			/* number of circles with variable radii */
int		*circindex;		/* record indices of nonzero entries */
int		*innerindex;		/* record indices of interior entries */
XPoint		mypoint[500];		/* points on mouse-drawn radius assignment curve */
int		normpoints;		/* the number of points in mypoint[] */
int		xmin, xmax, ymin, ymax;		/* the bounding rectangle of mypoint[] */
int		LRATIO;			/* sizeof(real)/sizeof(int); used in ndrv() */

typedef	struct	prowcol	{
	int	i, j;			/* index of nonzero entries in circle matrix */
	} prowcol;

typedef	struct	rowpartial	{
	int	i, j;			/* index of nonzero entries in the partial matrix */
	double	dr;			/* nonzero partial */
	} rowpartial;

/* the following variables are used in the smpak subroutine NDRV */
int		*R, *C, *IC;	/* orderings on the Partial matrix; default to : i'th entry = i */
int		*IA;		/* delimit rows in JA and A; size = N+1 */
int		*JA;		/* column indices of nonzero entries in Partial */
double		*A;		/* nonzero entries in Partial */
int		*ISP;		/* integer working storage; dimension = LRATIO*NSP */
double		*RSP;		/* work storage; ISP and RSP should be equivalenced (?) */
int		IAindex, IAsum, JAindex;

edgeinfo	*myedge;			/* angle information on edges for prescribed angle intersections */
double		getxangle();		/* return angle assigned to a certain edge */
int		normbdry;		/* Maximum number of edges at border vertices */
