/* $Id$
 *
 *  hdraw.c
 *  
 *  Routines for drawing in the graphics canvas.
 *
 */

/**************************************************************************
 *     Copyright (C) 1990 by Mark B. Phillips and Robert R. Miner	  *
 * 									  *
 * Permission to use, copy, modify, and distribute this software, its	  *
 * documentation, and any images it generates for any purpose and without *
 * fee is hereby granted, provided that					  *
 * 									  *
 * (1) the above copyright notice appear in all copies and that both that *
 *     copyright notice and this permission notice appear in supporting	  *
 *     documentation, and that the names of Mark B.  Phillips, Robert R.  *
 *     Miner, or the University of Maryland not be used in advertising or *
 *     publicity pertaining to distribution of the software without	  *
 *     specific, written prior permission.				  *
 *									  *
 * (2) Explicit written credit be given to the authors Mark B.  Phillips  *
 *     and Robert R. Miner in any publication which uses part or all of	  *
 *     any image produced by this software.				  *
 *									  *
 * This software is provided "as is" without express or implied warranty. *
 **************************************************************************/

#include "hcore.h"
#include "hglobals.h"

gdb_Entity LastDrawn=NULL;


/*-----------------------------------------------------------------------
 * Function:	DrawPoint
 * Description:	draws a point in the current model
 * Args  IN:	p: a kPoint
 * Returns:	nothing
 * Author:	mbp
 * Date:	Thu Apr 12 20:04:22 1990
 * Notes:	Uses procedures in window module to do actual drawing.
 */

/*-----------------------------------------------------------------------
 * Function:	DrawSegment
 * Description:	draws a geodesic segment in the current model
 * Args  IN:	*s: a kSegment in Klein coordinates
 * Returns:	nothing
 * Author:	lena
 * Date:	Thu Apr 12 14:34:16 1990
 * Notes:	Uses procedures in window module to do actual drawing.
 */

/*-----------------------------------------------------------------------
 * Function:	DrawEntity
 * Description:	draw an entity
 * Args  IN:	entity: the entity to be drawn
 * Returns:	success status
 * Author:	mbp
 * Date:	Thu Apr 12 17:09:37 1990
 * Notes:	Uses procedures in window module to do actual drawing.
 */

#define CLASS		extern		/* extern because hgdb draws */
#define DRAWPOINT	DrawPoint
#define DRAWSEGMENT	DrawSegment
#define DRAWENTITY	DrawEntity
#define DEVPOINT	wPoint
#define DEVSEGMENT	wSegment
#define DEVARC		wArc

#include "drawprocs.c"

#undef CLASS
#undef DRAWPOINT
#undef DRAWSEGMENT
#undef DRAWENTITY
#undef DEVPOINT
#undef DEVSEGMENT
#undef DEVARC

/*-----------------------------------------------------------------------
 * Function:    DrawPicture
 * Description: Erase the canvas and draw the entire picture
 * Arguments:   (none)
 * Returns:     success status
 * Author:	mbp
 * Date:	Mon Apr 16 11:58:20 1990
 * Notes:        
 */
int
  DrawPicture()
{

  wBatch(1);
  wErase();

  /*
   * First draw the circle at infinity (which is the x axis in UHP):
   */
  switch (model) {
  default:
  case KLEIN:
  case POINCARE:
    wArc(0.0, 0.0, 1.0, 0.0, TWO_PI);
    break;
  case UHP:
    wSegment(vpx, 0.0, vpx+vps, 0.0);
    break;
  }

  /*
   * Then draw the picture.  (UpdatePicture calls wBatch(0).)
   */
  UpdatePicture((gdb_Entity)NULL);

  return(0);
}

/*-----------------------------------------------------------------------
 * Function:	UpdatePicture
 * Description:	Draw everything in the database that has been added
 *		  after a certain entity
 * Args  IN:	lastdrawn: the last entity already drawn
 * Returns:	nothing
 * Author:	mbp
 * Date:	Mon Apr 16 11:15:40 1990
 * Notes:	This procedure draws everything after entity lastdrawn,
 *		and updates the global variable LastDrawn to be the
 *		last entity it draws.  If lastdrawn is NULL, the entire
 *		database is drawn.
 */
int
  UpdatePicture(lastdrawn)
gdb_Entity lastdrawn;
{
  gdb_Entity entity;
  gdb_Sequence_spec spec;

  /*
   * Decide where to start
   */
  if (lastdrawn == NULL)
    spec = GDB_FIRST;
  else {
    entity = lastdrawn;
    spec = GDB_NEXT;
  }

  /*
   * Loop through the database, drawing each object
   */
  wBatch(1);
  LastDrawn = lastdrawn;
  do {
    gdb_retrieve_entity( POINT|SEGMENT, GDB_SEQUENTIAL,
			 (char*)&spec, &entity );
    if (entity!=NULL) {
      DrawEntity( entity );
      LastDrawn = entity;
    }
  } while (entity!=NULL);
  wBatch(0);

  /*
   * Set batch deletion flag to indicate that picture is now current.
   */
  BatchDeletion = 0;
}
