(* $Id: Pencil.m,v 1.3 90/07/11 13:08:22 mbp Exp Locker: mbp $
 *
 * Pencil.m: Functions for computing and drawing hyperbolic pencils.
 *)

(**************************************************************************
 *     Copyright (C) 1990 by Mark B. Phillips and Robert R. Miner	  *
 * 									  *
 * Permission to use, copy, modify, and distribute this software, its	  *
 * documentation, and any images it generates for any purpose and without *
 * fee is hereby granted, provided that					  *
 * 									  *
 * (1) the above copyright notice appear in all copies and that both that *
 *     copyright notice and this permission notice appear in supporting	  *
 *     documentation, and that the names of Mark B.  Phillips, Robert R.  *
 *     Miner, or the University of Maryland not be used in advertising or *
 *     publicity pertaining to distribution of the software without	  *
 *     specific, written prior permission.				  *
 *									  *
 * (2) Explicit written credit be given to the authors Mark B.  Phillips  *
 *     and Robert R. Miner in any publication which uses part or all of	  *
 *     any image produced by this software.				  *
 *									  *
 * This software is provided "as is" without express or implied warranty. *
 **************************************************************************)

HyperbolicPencil[l_kLine, d_?NumberQ, n_Integer] :=
  Block[{c, v, p, t},

    (* Compute point of l closest to origin (kPoint[0,0]); do this by
     * taking the intersection of l with the line through the origin
     * perpindicular to l. *)
    c = hIntersection[l, hPerp[ l, kPoint[0,0] ] ];

    (* Now compute a unit vector based at c tangent to l. *)
    v = hLog[ c, l ];

    (* Let p[t] be the point of l at hyperbolic distance t*d from c *)
    p[t_] := hExp[ t d v ];

    (* Return the list *)
    Return[ Table[ hPerp[ l, p[t] ], {t, -n, n} ] ]
  ]

DrawPencil[d_?NumberQ, n_Integer] :=
  Block[ {a,b,l,pencil},

    (* Get two points to define the line for the pencil; draw the
     * points during the process, but erase them after the line is
     * drawn because we no longer need them *)
    gDraw[ a = gGetPoint["Pick first point on line for pencil"] ];
    gDraw[ b = gGetPoint["Pick second point on line for pencil"] ];
    gDraw[ l = kLine[a,b] ];
    gErase[ a, b ];

    (* Compute and draw the pencil *)
    gDraw[ pencil = HyperbolicPencil[ l, d, n ] ];
  ]
