#! /bin/csh -f

# $Id: startheis.tpl,v 1.2 90/07/11 13:09:58 mbp Exp Locker: mbp $
#TPL
#TPL	DO NOT CHANGE ANY LINE IN THIS FILE THAT BEGINS WITH '#TPL'
#TPL	
#TPL	This file is a template to be used in creating the actual
#TPL	shell script.  The makefile creates the file 'startheis' from
#TPL	this one by replacing the following strings in this file with
#TPL	actual values:
#TPL
#TPL		HEISENBERGPATH
#TPL		ELBOWDPATH
#
#TPLWARNING

# Shell script to start Heisenberg graphics daemon.
# 
# Syntax: startheis [-port n] [-immortal]

# Normal usage is just 'startheis', with no args.  This starts an
# instance of the graphics daemon, which waits in the background for a
# connection request from the Mathematica host.
# 
# The '-immortal' option causes the graphics daemon to be immortal ---
# it does not die when the connection is terminated.  This allows you to
# run multiple executions of Heisenberg on the Mathematica host without
# having to type 'startheis' on the graphics host each time.  The
# immortal graphics daemon will continue to run in the background until
# you kill it or until the system goes down.  In particular, it survives
# logouts.
# 
# If you get an error message saying
# 
# 	elbowd (bind): Address already in use
# 	Is an elbowd already running?
# 
# it means that the default port number which Heisenberg uses for
# intermachine communication is already in use.  This means that either
# (1) you have already started a Heisenberg graphics daemon and do not
# need to re-run this shell script, or (2) the port is in use by another
# program.  If you determine that you are in case (2), you can use
# another port with the -port option.  The default port is 1115.  If you
# need to use an alternate port, try 1116, 1117, etc.  If you use an
# alternate port, you will have to let the Mathematica host know which
# port you are using by giving the command
# 
# 	setenv ELBOWPORT n
# 
# where n is the port number you are using.   Give this 'setenv' command
# from the shell before starting Mathematica.

set heisenbergpath = HEISENBERGPATH
set elbowdpath = ELBOWDPATH

set portargs = ""
set contargs = ""

if ("$1" == "-port") then
  if ($#argv < 2) goto usage
  set portargs = "-port $2"
  shift ; shift
endif

if ($#argv > 0) then
  if ("$1" == "-immortal") then
    set contargs = "-cont"
    shift
  else
    goto usage
  endif
endif

if ($#argv != 0) goto usage

$elbowdpath $portargs $contargs $heisenbergpath -p &

exit 0

usage:
  echo 'usage: startheis [-port <n>] [-immortal]'
  exit -1
