/*
 * gr.h: common header file for IRIS driver
 */

/***************************************************************************
 *                Copyright (C) 1990 by Mark B. Phillips                   *
 *                                                                         *
 *  Permission to use, copy, modify, and distribute this software, its     *
 *  documentation, and any images it generates for any purpose and without *
 *  fee is hereby granted, provided that                                   *
 *                                                                         *
 *  (1) the above copyright notice appear in all copies and that both      *
 *      that copyright notice and this permission notice appear in         *
 *      supporting documentation, and that the names of Mark B.            *
 *      Phillips, or the University of Maryland not be used in             *
 *      advertising or publicity pertaining to distribution of the         *
 *      software without specific, written prior permission.               *
 *                                                                         *
 *  (2) Explicit written credit be given to the author Mark B. Phillips    *
 *      in any publication which uses part or all of any image produced    *
 *      by this software.                                                  *
 *                                                                         *
 * This software is provided "as is" without express or implied warranty.  *
 ***************************************************************************/

#include "gl.h"
#include "device.h"
#include "get.h"

/* The following can be set to null to make private procedures public
 * for debugging */
#define STATIC static

extern int iris_initialized;

extern int win_height, win_width;

/* Color Ramp indices: */
#define	GR_WHITE	0
#define	GR_GREEN	1
#define	GR_BLUE		2
#define	GR_YELLOW	3
#define	GR_MAGENTA	4
#define	GR_CYAN		5
#define	GR_RED		6

#define YES ((Boolean)1)
#define NO  ((Boolean)0)

extern long GrWindowWidth, GrWindowHeight;

/* Screen coords used in depth cueing */
#define LO_SCREEN_COORD_INT 0
#define HI_SCREEN_COORD_INT 1023
#define LO_SCREEN_COORD ((Screencoord)LO_SCREEN_COORD_INT)
#define HI_SCREEN_COORD ((Screencoord)HI_SCREEN_COORD_INT)

#define NEARZOFFSETDEFAULT 0
#define FARZOFFSETDEFAULT 0

/* Z offsets: */
extern long GrNearZOffset, GrFarZOffset;

extern Icoord GrOutTextX, GrInTextX, GrOutTextY, GrInTextY;

typedef struct GrOptPair_s {
	char	*string;
	int	(*proc)();
	} GrOptPair;
typedef struct GrMenu_s {
	char	 *title;
	int	 nopts;
	GrOptPair *list;
	} GrMenu;

/* aspect ratio: width/height of IRIS graphics window */
extern double GrAspectRatio;

extern Colorindex GrRampLen;

extern Colorindex RampLo[], RampHi[];

extern int GrPanelDraw();

extern long GrCurrentGID;
extern long GrGraphicsGID;
extern long GrPanelGID;

/* Viewing actions */
#define ROTATEVIEW		0
#define ZOOMVIEW		1
#define TRANSLATEVIEW		2
#define SCALEVIEW		3
#define FOVVIEW			4
#define TWISTVIEW		5
#define RESETVIEW		6
#define HALTVIEW		7

extern int GrNTSCMode, GrNTSCMouseX, GrNTSCMouseY;

/* Color Ramp offsets: (defaults: 0, 0)*/
extern Colorindex RampLoOffset, RampHiOffset;
