/***************************************************************************
 *                Copyright (C) 1990 by Mark B. Phillips                   *
 *                                                                         *
 *  Permission to use, copy, modify, and distribute this software, its     *
 *  documentation, and any images it generates for any purpose and without *
 *  fee is hereby granted, provided that                                   *
 *                                                                         *
 *  (1) the above copyright notice appear in all copies and that both      *
 *      that copyright notice and this permission notice appear in         *
 *      supporting documentation, and that the names of Mark B.            *
 *      Phillips, or the University of Maryland not be used in             *
 *      advertising or publicity pertaining to distribution of the         *
 *      software without specific, written prior permission.               *
 *                                                                         *
 *  (2) Explicit written credit be given to the author Mark B. Phillips    *
 *      in any publication which uses part or all of any image produced    *
 *      by this software.                                                  *
 *                                                                         *
 * This software is provided "as is" without express or implied warranty.  *
 ***************************************************************************/

#include <stdio.h>
#include <math.h>
#include <string.h>
#include "../lgd.h"
#include "gr.h"

STATIC char *mexname = NULL;
STATIC int mexfg = YES;

/****************************************************************/
/*		EXTERNAL PROCEDURES:				*/

/*--------------------------------------------------------------*/
lgd_set_mex_name(name)
     char *name;
{
  mexname = name;
}

lgd_set_mex_foreground(fg)
int fg;
{
  mexfg = fg;
}

/*--------------------------------------------------------------*/
dev_initialize()
{
  if (mexname != NULL)
    GrInit(mexname,mexfg);
  else
    GrInit("lgd",mexfg);
}

/*--------------------------------------------------------------*/
dev_set_menu( menu )
lgd_Menu *menu;
{
  GrSetMenu((GrMenu*)menu);
}
  
/*--------------------------------------------------------------*/
dev_inquire_menu( menu )
lgd_Menu **menu;
{
  GrInquireMenu((GrMenu**)menu);
}

/*--------------------------------------------------------------*/
dev_main_loop()			/* menu mode */
{
  GrMainLoop();
}

/*--------------------------------------------------------------*/
dev_end_loop()
{
  GrDone();
}

/*--------------------------------------------------------------*/
dev_get_string(s)
char *s;
{
  GrGetString(s);
}

/*--------------------------------------------------------------*/
dev_put_string(s)
char *s;
{
  GrPutString(s);
}

/*--------------------------------------------------------------*/
dev_confirm(s)
char *s;
{
  int answer;
  char buf[120], *c;

  sprintf(buf,"%s (y/n):",s);
  GrPutString(buf);
  GrGetString(buf);
  c = strtok(buf," \t");
  answer = (c==NULL ? NO : ((*c=='y') || (*c=='Y')));
  return(answer);
}

/*--------------------------------------------------------------*/
dev_get_point(v)
double v[];
{
  char buf[120], *c;
  
  GrGetString(buf);
  c = strtok(buf," (),\t");
  v[0] = ( c==NULL ? 0 : atof(c) );
  c = strtok((char*)NULL," (),\t");
  v[1] = ( c==NULL ? 0 : atof(c) );
  c = strtok((char*)NULL," (),\t");
  v[2] = ( c==NULL ? 0 : atof(c) );
}

dev_signal(sig, func)
int sig, (*func)();
{
  signal(sig, func);
}

dev_set_input_func(func, fd)
int (*func)(), fd;
{
  GrSetInputFunc(func, fd);
}

dev_color(color)
     int color;
{
  switch (color) {
  case LGD_BLACK:	GrColor(BLACK);			break;
  case LGD_WHITE:	GrDepthCueColor(GR_WHITE);	break;
  case LGD_RED:		GrDepthCueColor(GR_RED);	break;
  case LGD_GREEN:	GrDepthCueColor(GR_GREEN);	break;
  case LGD_YELLOW:	GrDepthCueColor(GR_YELLOW);	break;
  case LGD_BLUE:	GrDepthCueColor(GR_BLUE);	break;
  case LGD_MAGENTA:	GrDepthCueColor(GR_MAGENTA);	break;
  case LGD_CYAN:	GrDepthCueColor(GR_CYAN);	break;
  }
}
