/* $Id: matrixentry.h,v 4.0 89/06/06 15:38:53 mbp Exp $
 *
 * matrixentry.c: field operations for matrix package
 */

/************************************************************************
 *      Copyright (C) 1989 by Michael J. Raue, Mark B. Phillips         *
 *			and William M. Goldman                          *
 * 									*
 * Permission to use, copy, modify, and distribute this software and	*
 * its documentation for any purpose and without fee is hereby granted,	*
 * provided that the above copyright notice appear in all copies and	*
 * that both that copyright notice and this permission notice appear in	*
 * supporting documentation, and that the names of Michael J. Raue,	*
 * Mark B. Phillips, William M. Goldman, or the University of Maryland	*
 * not be used in advertising or publicity pertaining to distribution	*
 * of the software without specific, written prior permission.  This	*
 * software is provided "as is" without express or implied warranty.	*
 ************************************************************************/

/*
 * This file defines the ground field operations used by the matrix
 * package (matrix.c and matrix.h).  The matrix package implements
 * matrix operations over this field.
 */ 

#include "complex.h"            /* complex number macros. */
#include <math.h>               /* math library, which must be accessed
                                   with the "-lm" option to the "cc"      
                                   command */

typedef Complex Matrix_entry;     /* defines the matrices to be of type
                                   COMPLEX. */
#define copy(a,b)   C_COPY((a), (b))
#define equal(a,b)  C_ISEQUAL((a), (b))
#define add(c,a,b)  C_ADD((c), (a), (b) )
#define sub(c,a,b)  C_SUB((c), (a), (b) )
#define mult(c,a,b) C_MUL((c), (a), (b))
#define div(c,a,b)  C_DIV((c), (a), (b) )
#define root(c,a)   /* unimplemented */
#define ZERO        C_ZERO	
#define write(a)    printf("%f %f ",a.re, a.im);
