/***************************************************************************
 *                Copyright (C) 1990 by Mark B. Phillips                   *
 *                                                                         *
 *  Permission to use, copy, modify, and distribute this software, its     *
 *  documentation, and any images it generates for any purpose and without *
 *  fee is hereby granted, provided that                                   *
 *                                                                         *
 *  (1) the above copyright notice appear in all copies and that both      *
 *      that copyright notice and this permission notice appear in         *
 *      supporting documentation, and that the names of Mark B.            *
 *      Phillips, or the University of Maryland not be used in             *
 *      advertising or publicity pertaining to distribution of the         *
 *      software without specific, written prior permission.               *
 *                                                                         *
 *  (2) Explicit written credit be given to the author Mark B. Phillips    *
 *      in any publication which uses part or all of any image produced    *
 *      by this software.                                                  *
 *                                                                         *
 * This software is provided "as is" without express or implied warranty.  *
 ***************************************************************************/

#ifndef GLGBUTTONDEF

typedef struct {

  /* Number of values this button can take on, and the current value
     (current value should be from 0 to nvals-1, inclusive) */
  int nvals, n;

  /* Pointer to array of nvals label strings --- one for each value */
  char **strings;

  /* Pointer to array of nvals color numbers --- one for each value */
  Colorindex *colors;

  /* Text and outline color */
  Colorindex txtcol, outline;

  /* callback procedure; gets called with button value each
   * time the value changes */
  int	(*proc)();

  /* lower left corner of button rect */
  double x,y;

  /* width and height of button rect */
  double w,h;

} GlgButton;

extern int GlgButtonDraw();
extern int GlgButtonEvent();

#define GLGBUTTON(button, gadget, proc, x, y, w, h, nvals, n, strings, colors, txtcol, outline) \
  GlgButton button =					\
   { nvals, n, strings, colors, txtcol, outline, proc,	\
     x, y, w, h };					\
  GlGadget gadget =					\
   { (char*)(&button), GlgButtonDraw, GlgButtonEvent }

#define GLGBUTTONDEF

#endif
