
/*
  $Header: /usr4/Geom_utilities/Poly2xy/RCS/proj_to_plane.c,v 1.1 91/03/12 11:00:33 meuer Exp $

  Projects the verticies of the polygon to the xy plane.

  Mark Meuer
  #1267045

  */

#include	"poly2xy.h"

void
project_verticies_to_xy( poly )
     Polygon	*poly;
{
    Angle		phi, theta;
    Matrix		final_matrix;
    Matrix		rotate_phi;
    Matrix		rotate_phi_inv;
    Matrix		rotate_theta;
    Matrix		rotate_theta_inv;
    Matrix		temp_matrix;
    Matrix		to_origin;
    Vector		normal, sides[2];
    Vertex		*vertex;
    int			i;

    /* GET THE NORMAL TO THE POLYGON AT A VERTEX */
    for ( i = 0; i < VECTOR_SIZE ; i++ )
    {
	sides[0][i] = poly->top_vertex->next_vertex->world_coords[i] - poly->top_vertex->world_coords[i];
	sides[1][i] = poly->top_vertex->prev_vertex->world_coords[i] - poly->top_vertex->world_coords[i];
    }
    cross_product( normal, sides[0], sides[1] );
    normalize_vector( normal );

    /* COMPUTE INTERMEDIATE MATRICIES: */
    /* TRANSLATE VERTEX TO THE ORIGIN */
    translation_matrix(to_origin,
		       (PointElement) ( -1.0 * poly->top_vertex->world_coords[0] ),
		       (PointElement) ( -1.0 * poly->top_vertex->world_coords[1] ),
		       (PointElement) ( -1.0 * poly->top_vertex->world_coords[2]) );
    
    /* COMPUTE INTERMEDIATE ANGLES */
    angles_from_z( normal, &theta, &phi );
    
    /* ROTATE ABOUT Z TO BRING NORMAL INTO THE XZ PLANE */
    z_rotation_matrix( rotate_theta, theta );
    transpose_matrix( rotate_theta_inv, rotate_theta );
    
    /* ROTATE ABOUT Y TO BRING NORMAL ONTO THE Z AXIS */
    y_rotation_matrix( rotate_phi, phi );
    transpose_matrix( rotate_phi_inv, rotate_phi );

    /* CREATE THE FINAL MATRIX */
    matrix_multiply( rotate_theta_inv, rotate_phi_inv, temp_matrix );
    matrix_multiply( to_origin, temp_matrix, final_matrix );

    /* TRANSFORM THE COORDINATES OF THE VERTICIES USING THE MATRIX */
    vertex = poly->top_vertex;
    do
    {
	/* Project the point to the X,Y plane */
	transform_point( final_matrix, vertex->world_coords, vertex->plane_coords );
	
	/* Zero out any Z coord that might be there.  A non-zero Z coord means the polygon wasn't quite
	   planar. */
	vertex->plane_coords[2] = 0.0;

	/* Get the next vertex */
	vertex = vertex->next_vertex;
    } while( vertex != poly->top_vertex );
}
