
/*
  $Header: /usr4/Geom_utilities/Poly2xy/RCS/poly2xy.h,v 1.2 91/03/12 16:43:47 meuer Exp $

  Header file for the poly2tri program.

  Mark Meuer
  #1267045

  */

#ifndef	POLY2XY_HEADER
#define	POLY2XY_HEADER

/* STANDARD INCLUDE FILES */
#include	<stdio.h>

/* SOME NON-STANDARD INCLUDE FILES */
#include	"matrix.h"


/* MACROS */
#ifndef	TRUE
#define	TRUE	1
#endif
#ifndef	FALSE
#define	FALSE	0
#endif


#define	CONCAVE 	1	/* Values for VertexType */
#define	CONVEX 		2
#define	UNCLASSIFIED	0

#define	PRINT_FULL_INFO		0	/* Format types for print_polygon routine. */
#define	PRINT_PLANE_COORDS	1

/* TYPE DEFINITIONS */
typedef	double	Float;			/* Change this to double to increase precision. */
typedef	int	VertexType;

typedef	struct	vertex_struct {
    Point			world_coords;	/* World coordinates of vertex */
    Point			plane_coords;	/* Planar coords after projection to x,y plane. */
    VertexType			type;
    struct vertex_struct	*prev_vertex;
    struct vertex_struct	*next_vertex;
}	Vertex;

typedef	struct	{
    int		no_verticies;	/* Number of verticies */
    Vertex	*top_vertex;	/* Pointer to list of verticies */
}	Polygon;



/*
  These macros are a hack to get rid of prototype arguments for compilers (like the SUN's)
  that won't allow them.
*/
#ifdef	sun
#define	ARGSLIST(x)	()
#else
#define	ARGSLIST(x)	x
#endif


/* FUNCTION PROTOTYPES */
void	break_polygon ARGSLIST( (Polygon *polygon, FILE *out_file, int order_changed) );
int	break_polygon_to_list ARGSLIST( (Polygon *polygon, double *triangle, int order_changed) );
void	classify_verticies ARGSLIST( (Polygon *polygon) );
Float	euclidian_area ARGSLIST( (Polygon *polygon) );     
void	fatal_error ARGSLIST( (char *message) );
void	parse_command_line ARGSLIST( (int argc, char **argv, char **in_file, char **out_file, int *sides) );
int	point_in_triangle ARGSLIST( (Point tr1, Point tri2, Point tri3, Point test_point) );
void	poly2xy ARGSLIST( (int num, double *poly, double *new_poly ) );     
void	print_polygon ARGSLIST( (FILE *out_file, Polygon *polygon, int format) );
void	process_polygons ARGSLIST( (FILE *in_file, FILE *out_file, int no_sides) );
void	project_verticies_to_xy ARGSLIST( (Polygon *polygon) );
int	read_polygon ARGSLIST( (FILE *in_file, Polygon *polygon, int no_verticies) );
int	sort_verticies ARGSLIST( (Polygon *polygon) );
void	usage ARGSLIST( ( char *prog_name ) );
     
#endif	/* POLY2XY_HEADER */



