
/*
  $Header: /usr2/meuer/Geom_utilities/Poly2tri/RCS/break_poly.c,v 1.5 91/02/20 17:08:33 meuer Exp $
  
  Break one polygon into triangles
  
  Mark Meuer
  #1267045
  
  */
#include	"poly2tri.h"

void
break_polygon( poly, out_file, order_changed )
     Polygon	*poly;
     FILE	*out_file;
     int	order_changed;	/* TRUE if original order of verticies has been reversed. */
{
    Vertex	*convex_vert;
    Vertex	*concave_vert;
    Vertex	*triangle_vert;
    int		i;
    int		broken_off;
    int		inside_triangle;
    
    /* CLASSIFY EACH VERTEX AS CONVEX OR CONCAVE. */
    classify_verticies( poly );
    
    /* FOR EACH CONVEX VERTEX, (until a triangle is broken off) */
    convex_vert = poly->top_vertex;
    broken_off = FALSE;
    do
    {
	if ( convex_vert->type == CONVEX )
	{
	    /* SEARCH FOR A CONCAVE VERTEX LYING WITHIN TRIANGLE FORMED BY THIS VERTEX AND IT'S NEIGHBORS. */
	    inside_triangle = FALSE;
	    concave_vert = poly->top_vertex;
	    do
	    {
		if ( concave_vert->type == CONCAVE )
		{
		    inside_triangle = point_in_triangle(convex_vert->prev_vertex->plane_coords,
							convex_vert->plane_coords,
							convex_vert->next_vertex->plane_coords,
							concave_vert->plane_coords);
		}
		concave_vert = concave_vert->next_vertex;
	    } while ( (!inside_triangle) && (concave_vert != poly->top_vertex) );
	    
	    /* IF NONE ARE FOUND, */
	    if ( ! inside_triangle )
	    {
		/* BREAK THIS TRIANGLE OFF THE POLYGON AND RECLASSIFY EFFECTED VERTICIES. */
		/* Print it out */
		if ( ! order_changed )	/* Print out in same order as original polygon */
		{
		    for (i = 0, triangle_vert = convex_vert->prev_vertex ;
			 i < 3 ;
			 i++, triangle_vert = triangle_vert->next_vertex )
		    {
			fprintf(out_file, "%f %f %f    ",
				triangle_vert->world_coords[0],
				triangle_vert->world_coords[1],
				triangle_vert->world_coords[2]);
		    }
		}
		else
		{
		    for (i = 0, triangle_vert = convex_vert->next_vertex ;
			 i < 3 ;
			 i++, triangle_vert = triangle_vert->prev_vertex )
		    {
			fprintf(out_file, "%f %f %f    ",
				triangle_vert->world_coords[0],
				triangle_vert->world_coords[1],
				triangle_vert->world_coords[2]);
		    }
		    
		}
		
		fprintf(out_file, "\n");
		
		/* Remove the link */
		convex_vert->prev_vertex->next_vertex = convex_vert->next_vertex;
		convex_vert->next_vertex->prev_vertex = convex_vert->prev_vertex;
		if ( poly->top_vertex == convex_vert )	/* Assign a new top vertex if necessary */
		{
		    poly->top_vertex = convex_vert->next_vertex;
		}
		poly->no_verticies--;
		broken_off = TRUE;
		
		/* RECURSIVELY BREAK APART THE NEW POLYGON */
		if ( poly->no_verticies >= 3 )
		{
		    break_polygon( poly, out_file, order_changed );
		}
	    }
	}

	convex_vert = convex_vert->next_vertex;
    } while ( ! broken_off );
}
