

/*
 * $Header: /n/poincare/usr5/meuer/5117/RCS/debug.c,v 1.6 89/05/01 12:41:21
 * meuer Exp $
 */
/* $Source: /n/poincare/usr2/meuer/5117/RCS/debug.c,v $ */

/*
 * Routine to print debugging information if the debug flag is set.
 *
 * Mark Meuer
 */

#include	"matrix.h"



void
debug(message)
char           *message;
{
#ifdef DEBUG
	FILE           *stream;

	stream = debug_stream();
	fprintf(stream, "%s\n", message);
	fflush(stream);
#endif DEBUG
}

/*
 * Routine to initialize the debug output file stream.
 *
 */

FILE *
debug_stream()
{
	char            error_string[ERROR_STRING_LENGTH];
	static int      first_time = TRUE;
	static FILE    *stream;

	if (first_time)
	{
		first_time = FALSE;
		stream = open_file(DEBUG_FILE, "w");
		if (stream == NULL)
		{
			sprintf(error_string,
				"debug_stream: Could not open file \"%s\" for writing.",
				DEBUG_FILE);
			fatal_error(error_string);
		}
	}
	return (stream);
}



/*
 * Routine to print a vector only if the debug flag is set.
 *
 * Mark Meuer
 */

void
debug_vector(message, vector)
char            message[];
Vector          vector;
{
#ifdef	DEBUG
	FILE           *stream;

	stream = debug_stream();
	print_vector(stream, message, vector);
#endif	DEBUG
}


/*
 * Routine to print a matrix only if the debug flag is set.
 *
 * Mark Meuer
 */

void
debug_matrix(message, matrix)
char            message[];
Matrix          matrix;
{
#ifdef	DEBUG
	FILE           *stream;

	stream = debug_stream();
	fprintf(stream, "%s\n", message);
	matrix_print(stream, matrix);
#endif	DEBUG
}



/*
 * Routine to print a point only if the debug flag is set.
 *
 * Mark Meuer
 */

void
debug_point(message, point)
char            message[];
Point           point;
{
#ifdef	DEBUG
	FILE           *stream;

	stream = debug_stream();
	print_point(stream, message, point);
#endif	DEBUG
}


/*
 * Routine to print a screen point only if the debug flag is set.
 *
 * Mark Meuer
 */

void
debug_screen_point(message, point)
char            message[];
ScreenPoint     point;
{
#ifdef	DEBUG
	FILE           *stream;

	stream = debug_stream();
	print_screen_point(stream, message, point);
#endif	DEBUG
}
