/*************************************************************
*  This file is part of the Surface Evolver source code.     *
*  Programmer:  Ken Brakke, brakke@geom.umn.edu              *
*************************************************************/


/**********************************************************
*
*  File: tmain.c
*
*  Contents:  main() for Surface Evolver
*/

#include "include.h"

#ifdef NeXTapp
int old_main(argc,argv)
#else
int main(argc,argv)
#endif
int argc;
char *argv[];
{
  sprintf(msg,"Surface Evolver %s\n\n",VERSION);
  outstring(msg);

  scratch_mat = dmatrix(0,MAXCOORD,0,MAXCOORD);

  /* parse command line options */
  argv++;
  while ( (argv[0] != NULL) && (argv[0][0] == '-') )
    { switch ( argv[0][1] )
        {  
           case 'r' :  fprintf(stderr,"-r option not functional.\n");
             /* restore(argv[2]); */
             break;
           case 'f' : /* commands from file */
             commandfd = fopen(argv[0]+2,"r");
             if ( commandfd == NULL )
               { perror(argv[0]+2);
                 break;
               }
             break;
           default:
             fprintf(stderr,"Illegal option: %s\n",argv[0]);
             fprintf(stderr,"Legal options: \n");
             fprintf(stderr,"  -ffilename        take commands from file\n");
             break;
         }
      argv++;
    }

  signal(SIGINT,catcher);   /* to catch user interrupt */    
  scoeff_init();
  vcoeff_init();  
  init_view();

  startup(argv[0]);

  /* for resetting jumpbuf after starting new file */
  if ( setjmp(jumpbuf) )   /* return here after recoverable errors */
    { if ( commandfd ) { fclose(commandfd); commandfd = NULL;} /* revert */
    }

#ifndef NeXTapp
  while ( 1 )  /* main event loop of program */
    {
	char response[200];
#ifndef NOPIPE
	 if ( outfd != stdout )
	   { pclose(outfd);
	     outfd = stdout;   /* in case of previous piping */
	     /* put here so will execute after previous loop error */
	   }
#endif
         temp_free_all(); /* stray memory blocks */
	 free_discards(); /* from previous cycle */
         memset(response,0,sizeof(response));
         prompt("Enter command: ",response);
         breakflag = 0;
         old_menu(response);
    }
#endif


  return 0; /* success return code */
}

/****************************************************************
*
* Function: startup()
*
* Purpose:  Start new datafile.
*
*****************************************************************/

void startup(filename)
char *filename;  /* NULL if need to ask for name */
{
  char *name = filename;
  char response[100];

  if ( setjmp(jumpbuf) )   /* return here after recoverable errors */
    { if ( commandfd ) { fclose(commandfd); commandfd = NULL;} /* revert */
      name = NULL;
    }


  if ( data_fd ) fclose(data_fd);
  data_fd = NULL;
  datafile_flag = 0;

  if ( name == NULL )
    { prompt("Enter new datafile name (none to continue, q to quit): ",response);
      if ( strcmp(response,"q") == 0 )
        { if ( OOGL_flag ) End_OOGL();
          exit(1);
        }
      else if ( !response[0] ) return; /* continue same */
      name = response;
    }
  reset_web(); 
  data_fd = path_open(name);
  if (data_fd == NULL) return; /* continue with old */
  strncpy(datafilename,name,sizeof(datafilename));


#ifdef TC
if ( farheapcheck() < 0 )
  error("Corrupt heap.\n",UNRECOVERABLE);
#endif

  datafile_flag = 1;  /* so parser knows */
  initialize();
  datafile_flag = 0;
  if ( parse_errors ) 
    error("Invalid datafile.\n",RECOVERABLE);
  reset_view();
  resize();
  run_checks();
  calc_content();
  calc_pressure();
  calc_energy();  /* just to get initial total area */
  target_length = web.total_area; /* for square curvature string model */
  update_display();
}

