#include	<X11/Xlib.h>
#include	<X11/StringDefs.h>
#include	<X11/Intrinsic.h>


#define WIDTH   384
#define HEIGHT  128
#define MAXVALS 64
#define	NBOX	4

extern void	initLut();
extern void	initButtons();
extern void	initBoxes();
extern void	initGC();

extern void	setScheme();
extern void	setSpline();

extern void     map_to_tuple();	/* (x, &tuple) computes {r,g,b,a}@x => tuple */
extern int	eval_box();	/* (ix, box) returns function value */

extern void	boxMessage();	/* (box, fmt, args...) Display string in box */
extern void	panelMessage();	/* (fmt, args...) Display msg in top panel */


extern void	boxDraw();
extern void	boxSel();
extern void	boxClear();	/* (box, lox, hix) */
extern void	boxResize();
extern void	boxLockX();	/* (box, lockXon) set/clear "Lock X" button */
extern void	boxAnnounce();	/* (box, point) */

extern void	reset_boxes();	/* () */
extern void	box_lock_x();	/* (box, str)  (str=contents of text box) */
extern void	box_delete();	/* (box, str)  (str=contents of text box) */
extern void	box_setadd();	/* (box, str)  (str=contents of text box) */
extern void	box_spot();	/* (box, ix, iy, flags)  pick arbitrary spot */

extern void	box_point();	/* (box, ix, iy, flags)  add control point */
extern void	box_drag();	/* (box, ix, iy, flags)  drag control point */

extern void	redo();		/* (box, lo, hi, flags) handle changed ctl pts */
#define	RECALC	1			/* e.g. recompute spline parameters */
#define	REDOLUT	2			/* reconstruct color table */
#define	UNDRAW	4			/* erase area in prep. for changing */

extern void	add_point();	/* (box, ix, iy, flags)	insert ctl point */
extern void	move_point();	/* (box, point, ix, iy, flags) move ctl point */
extern void	del_point();	/* (box, point, flags)	delete ctl point */

extern void	initCbar();
extern void	pick_cbar();	/* (ix, iy, flags) */

extern void	updateCmap();	/* (loix, hiix)	reload colormap from lut[] */
extern void	loadPixar();
extern void	turnPixar();

extern void	file_save();	/* (w, op, Save_to_pixar_too) */
extern void	file_load();	/* (w, ..., ...) Read file named by widget */
extern char	curfname[128];	/* Current file name */

extern void	quit();		/* () */

extern void	putlines();	/* (boxno, pvec, npts, on) */
extern void	putpoints();	/* (boxno, pvec, npts, on) */

extern int	pixar;
extern enum colorscheme { RGB, HSV, YIQ } colorscheme;
extern char *schemename[];

extern int	spline;	/* 0 => linear, 1 => cubic */
extern int	savetable;

	/* X specific data */
	/* Graphics contexts -- line widths 1 & 2; [0] = white, [1] = black */
extern GC	gc_w1[2], gc_w2[2];

extern	Widget	rgb_button, file_name;	/* Widely used widgets */

extern XColor	lut[256];

extern int	has_color;

extern Colormap color_map;


			/* Internal coordinates: .Cbx files, cval[].{x,y} */
#define	XSCALE	256			/* cval.x ranges 0..255 */
#define	YSCALE	32768			/* cval.y ranges 0..32767 */

			/* graphics coordinates: for putlines() etc. */
extern int	boxwidth;		/* real width of box */
extern int	boxheight;		/* real height of box */

			/* graphics<->internal transforms */
#define	ItoGX(ix)	((ix) * boxwidth / XSCALE)
#define	ItoGY(iy)	((YSCALE-1 - (iy)) * boxheight / YSCALE)
#define	GtoIX(gx)	((gx) * XSCALE / boxwidth)
#define	GtoIY(gy)	(YSCALE-1 - ((gy) * YSCALE / boxheight))

			/* user<->internal transforms */
			/* might depend on the box someday soon (89.05.19) */
#define	ItoUX(ix, box)	((ix) * 256 / XSCALE)
#define	ItoUY(iy, box)	((iy) * 256 / YSCALE)
#define	UtoIX(ux, box)	((ux) * XSCALE / 256)
#define	UtoIY(uy, box)	((uy) * YSCALE / 256)


extern int	lastbox, lastpt;	/* Last-touched (current) ctrl point */

struct cbox {
	Widget	namelbl, boxws, diatxt, lockbtn, delbtn, setbtn;
	char	*diastr;		/* String for body of diatxt box */
	int	count;
	struct cval {
		short x;
		char flags;		/* see below... */
#define	LOCK_X	01		/* Flag: don't budge in X */
#define	LOCK_Y	02		/* Flag: don't budge in Y */
#define	LWING	04		/* Is left wing of a spline ctrl point */
#define	RWING	010		/* Is right wing */
#define	WTIED	020		/* Set in both wing points if tied together */
		char pump;	/* hue wrap: Y[i] - Y[i-1] += pump*YSCALE */
		int y;
		float p, w;	/* Spline parameters, derived */
	} cval[MAXVALS];
} cbox[NBOX];


/* One value from each box.  Parameter to map_to_tuple and hsv2rgb etc. */

struct tuple {
	int	v[NBOX];
};
