#include	<stdio.h>
#include	<malloc.h>
#include	"cmap.h"
#include	<X11/Box.h>
#include	<Xw/Xw.h>
#include	<Xw/SRaster.h>

Widget	cbar_widget;
char	*cbar_data = NULL;
XImage	*cbar_image = NULL;

XImage *
buildCbar(w, reset)
    Widget w;
{
	register int i, width;
	register char *p;
	int nrows = 24;			/* color-bar height */

	width = (boxwidth+3) & ~3;	/* Round up to multiple of 4 */
	if(cbar_image != NULL) free(cbar_image);
	if(cbar_data != NULL) free(cbar_data);
	cbar_data = malloc(nrows * width);
	if(cbar_data == NULL) {
		perror("cbar");
		exit(2);
	}
	if(has_color) {
	    p = cbar_data;
	    i = 0;
	    do { *p++ = i*256/width; } while(++i < width);
	    for(i = 1; i < nrows; i++) {
		    memcpy(p, cbar_data, width);
		    p += width;
	    }
	} else {
	    register int row;
	    int pixbit;
	    int black = BlackPixelOfScreen(XtScreen(w));
	    int white = WhitePixelOfScreen(XtScreen(w));

	    p = cbar_data;
	    for(row = 0; row < nrows; row++) {
		pixbit = 1 << (row / (nrows / 8));
		i = 0;
		do {
		    *p++ = (i*256/width) & pixbit ? white : black;
		} while(++i < width);
	    }
	}
	cbar_image = XCreateImage(XtDisplay (w),
		      XDefaultVisualOfScreen (XtScreen (w)),
			8, ZPixmap, 0, cbar_data, width, nrows, 8, 0);

	if(cbar_image == NULL) {
		perror("cbar");
		exit(2);
	}
	if(reset) {
		/* Change the colorbar, e.g. expand it */
	    Arg arg;

	    XtSetArg (arg, XtNsRimage, (XtArgVal) cbar_image);
	    XtSetValues(cbar_widget, &arg, 1);
	}
}

/*
 * Action table for color-bar picks.
 */
extern void cbarPick();

XtActionsRec cbar_actions[] = {
	"cbarPick", cbarPick,
};

/*
 * Translation table for color-bar picks
 */
static String cbar_translations = "\
<Btn1Down>:cbarPick()\n\
<Btn1Motion>:cbarPick()\n\
<Btn2Down>:cbarPick()\n\
<Btn2Motion>:cbarPick()\n\
<Btn3Down>:cbarPick(\"mark\")\n\
";

void
initCbar (parent)
    Widget	parent;
{
    int		i;
    Arg		arg[10];
    Widget	fu;

    /*
     * File handler part
     */
    fu = XtCreateManagedWidget ("file", boxWidgetClass, parent, arg, 0);


    buildCbar(parent, 0);
    /*
     * Color Bar handler part
     */
    XtSetArg (arg[0], XtNheight, (XtArgVal) 25);
    XtSetArg (arg[1], XtNwidth, (XtArgVal) boxwidth);
    XtSetArg (arg[2], XtNsRimage, (XtArgVal) cbar_image);
    cbar_widget = XtCreateManagedWidget ("bar", XwsrasterWidgetClass,
				     fu, arg, 3);
    XtAppAddActions( XtWidgetToApplicationContext(cbar_widget),
		     cbar_actions, XtNumber(cbar_actions) );
    XtOverrideTranslations( cbar_widget,
			    XtParseTranslationTable(cbar_translations) );
}

void
cbarPick(w, ev, argv, argcp)
    Widget w;
    register XEvent *ev;
    String *argv;
    Cardinal *argcp;
{
    switch(ev->type) {
    case ButtonPress:
    case ButtonRelease:
    case MotionNotify:
	pick_cbar(GtoIX(ev->xbutton.x), GtoIY(ev->xbutton.y), 
		*argcp>0 ? 1 : 0);
	break;

    default:
	printf("cbarPick: ev->type %d != ButtonPress/Release/Motion?\n",			ev->type);
    }
}
