(* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of CirclePack. CirclePack is free software; you can
redistribute it and/or modify it only under the terms given in the
file COPYING, which you should have received along with this file.
This and other software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. *)

(* Author: Silvio Levy *)
(* $Id: Minkowski.m,v 1.2 1992/07/17 16:09:52 oag Exp $ *)
(* NOTE: This package is under development as part of a separate
   hyperbolic geometry package. *)

BeginPackage["Minkowski`", "Normalize`"]

Minkowski::usage = "\n
   Minkowski[x], where x has head List, is a vector in Minkowski space.\n
   Such vectors can be added and multiplied by scalars.\n
   Dot, Cross and Normalize are suitably modified."

Cross::usage = "\n
  Cross[x_,y_], where x and y are vectors in Minkowski space, gives their\n
  cross product."

Begin["`private`"]

Minkowski[x_List]+Minkowski[y_List] ^:= Minkowski[x+y]
x_*Minkowski[y_List] ^:= Minkowski[x*y] (* here x is meant as a scalar *)

Minkowski[{xs__,lastx_}].Minkowski[{ys__,lasty_}] ^:= {xs}.{ys} - lastx lasty

Normalize::isotropic = "Cannot normalize ``"
Normalize[x_Minkowski] := (Message[Normalize::isotropic,x];Null) /; x.x==0
Normalize[x_Minkowski] := x / Sqrt[Abs[x.x]]

Cross[Minkowski[x_List],Minkowski[y_List]] := 
 Minkowski[{1,1,-1} RotateLeft[RotateLeft[y] x - RotateLeft[x] y]]

End[]
EndPackage[]
