/*=========================================================================
      Main.c-   This file contains the function main.
  ========================================================================*/  

#define global
#include "structs.h"
#include"macros.h"

/*--------------------------------------------------------------------------
        Main calls the functions that build the convex hull.  The options
  are -d ( sets the debug mode ) or -t ( sets the test mode ).
  All of the debug and test output is written to standard error.
  -------------------------------------------------------------------------*/
main( argc, argv )
int argc;
char *argv[];
{

	char *s;

	if ( argc > 1 && argv[1][0] == '-' )
             for ( s = argv[1] + 1; *s; ++s )
                   switch ( *s ) {
                          case 'd': debug = TRUE;
                                    test  = TRUE;
                                    fprintf( stderr, "Debug mode\n");
                                    break;
                          case 't': debug = FALSE;
                                    test  = TRUE;
                                    fprintf( stderr, "Test mode\n\n");
                                    break;
                          default : debug = FALSE;
                                    test  = FALSE;
                          }

        else if ( argc > 1 && argv[1][0] != '-' )
             printf ("Usage:  input file | %s -d[ebug]t[est] \n", *argv ),
             exit(1);

        read_vertices();
        init_tet();
        complete_hull();
        print();
        if (test)  checks();
        
}
