/* lib.d file fsa.c */
#include <stdio.h>
#include "defs.h"
#include "list.h"
#include "word.h"
#include "input.h"
#include "lg.h"

static int asint_vindex_sgn_dp PARMS ((dp, dp));
static int PAIRsgn_mp PARMS ((dp, dp));
static void PAIRcpy_mp PARMS ((dp, dp));
static void PAIRprint_mp PARMS ((FILE *,dp));
static int TRIPLEsgn_mp PARMS ((dp, dp));
static void TRIPLEcpy_mp PARMS ((dp, dp));
static void TRIPLEprint_mp PARMS ((FILE *,dp));
static int PAIRstruct_sgn PARMS ((vindex, vindex));
static PAIRstruct * PAIRstruct_create PARMS ((VOID));
static void PAIRstruct_kill PARMS ((vindex));
static void PAIRstruct_print PARMS ((FILE *,vindex));
static int TRIPLEstruct_sgn PARMS ((vindex, vindex));
static TRIPLEstruct * TRIPLEstruct_create PARMS ((VOID));
static void TRIPLEstruct_kill PARMS ((vindex));
static void TRIPLEstruct_print PARMS ((FILE *,vindex));
static int LISTstruct_sgn PARMS ((vindex, vindex));
static LISTstruct * LISTstruct_create PARMS ((VOID));
static void LISTstruct_kill PARMS ((vindex));
static void LISTstruct_print PARMS ((FILE *,vindex));
static int min_category PARMS ((list * lp));
static int max_category PARMS ((list * lp));
int degree;

elt_fntab
ASINT_VINDEX_fntab =
	{
		asint_vindex_sgn_dp,
/* signature function, vindices are compared as integers */
		vindex_cpy_dp,
		(V2DP)vindex_create,
		Free_dp,
		vindex_print_dp,
		0,
		0
	};


elt_fntab
PAIRpocket_fntab = {
	PAIRsgn_mp,
	PAIRcpy_mp,
	(V2DP)PAIRstruct_create,
	Free_dp,
	PAIRprint_mp,
	0,
	0
};

#define PAIRpocket &PAIRpocket_fntab

elt_fntab
TRIPLEpocket_fntab = {
	TRIPLEsgn_mp,
	TRIPLEcpy_mp,
	(V2DP)TRIPLEstruct_create,
	Free_dp,
	TRIPLEprint_mp,
	0,
	0
};

#define TRIPLEpocket &TRIPLEpocket_fntab


mp_fntab PAIR_fntab =
{
	PAIRstruct_sgn,
	(V2DP)PAIRstruct_create,
	PAIRstruct_kill,
	PAIRstruct_print,
	0,
	0
};

mp_fntab TRIPLE_fntab =
{
	TRIPLEstruct_sgn,
	(V2DP)TRIPLEstruct_create,
	TRIPLEstruct_kill,
	TRIPLEstruct_print,
	0,
	0
};

mp_fntab LIST_fntab =
{
	LISTstruct_sgn,
	(V2DP)LISTstruct_create,
	LISTstruct_kill,
	LISTstruct_print,
	0,
	0
};


static int 
asint_vindex_sgn_dp(DP1,DP2)
       dp DP1, DP2;
{
	int sgn;
	vindex n1, n2;
	n1 = (*(vindex *)DP1);
	n2 = (*(vindex *)DP2);
	if (n1<n2)
		sgn=1;
	else if (n1>n2)
		sgn = -1;
	else
		sgn=0;
	return sgn;
}


static int 
PAIRsgn_mp(dp1, dp2)
	dp dp1;
	dp dp2;
{
	int sgn = -1;
	PAIRstruct * Ps1 = (PAIRstruct *)dp1;
	PAIRstruct * Ps2 = (PAIRstruct *)dp2;
	if ((Ps1->state1)<(Ps2->state1))
		sgn=1;
	else if ((Ps1->state1)==(Ps2->state1)){
		if ((Ps1->state2)<(Ps2->state2))
			sgn=1;
		else if ((Ps1->state2)==(Ps2->state2))
			sgn=0;
	}
	return sgn;
}

static void 
PAIRcpy_mp(dp1, dp2)
	dp dp1;
	dp dp2;
{
	PAIRstruct * Ps1 = (PAIRstruct *)dp1;
	PAIRstruct * Ps2 = (PAIRstruct *)dp2;
	Ps2->state1=Ps1->state1;
	Ps2->state2=Ps1->state2;
}


static void 
PAIRprint_mp(wfile,DP)
	FILE * wfile;
	dp DP;
{
	PAIRstruct * Ps = (PAIRstruct *)DP;
	assert(Ps);
	fprintf(wfile,"PAIR: 0x%x 0x%x\n",Ps->state1,Ps->state2);
}


static int
PAIRstruct_sgn(v1,v2)
	vindex v1,v2;
{
	return PAIRsgn_mp(v1->mp,v2->mp);
}

static PAIRstruct *
PAIRstruct_create()
{
	PAIRstruct * Ps = vzalloc1(PAIRstruct);
	return Ps;
}

static void
PAIRstruct_kill(v)
	vindex v;
{
	assert(v->mp);
	assert((v->fntab)==PAIR);
	Free_dp(v->mp); v->mp=0;
}

static void
PAIRstruct_print(wfile,v)
	FILE * wfile;
	vindex v;
{
	assert((v->fntab)==PAIR);
	PAIRprint_mp(wfile,v->mp);
}

static int 
TRIPLEsgn_mp(dp1, dp2)
	dp dp1;
	dp dp2;
{
	int sgn = -1;
	TRIPLEstruct * Ts1 = (TRIPLEstruct *)dp1;
	TRIPLEstruct * Ts2 = (TRIPLEstruct *)dp2;
	if ((Ts1->state1)<(Ts2->state1))
		sgn=1;
	else if ((Ts1->state1)==(Ts2->state1)){
		if ((Ts1->state2)<(Ts2->state2))
			sgn=1;
		else if ((Ts1->state2)==(Ts2->state2)){
			if ((Ts1->state3)<(Ts2->state3))
				sgn=1;
			else if ((Ts1->state3)==(Ts2->state3))
				sgn=0;
		}
	}
	return sgn;
}

static void 
TRIPLEcpy_mp(dp1, dp2)
	dp dp1;
	dp dp2;
{
	TRIPLEstruct * Ts1 = (TRIPLEstruct *)dp1;
	TRIPLEstruct * Ts2 = (TRIPLEstruct *)dp2;
	Ts2->state1=Ts1->state1;
	Ts2->state2=Ts1->state2;
	Ts2->state3=Ts1->state3;
}


static void 
TRIPLEprint_mp(wfile,DP)
	FILE * wfile;
	dp DP;
{
	TRIPLEstruct * Ts = (TRIPLEstruct *)DP;
	assert(Ts);
	fprintf(wfile,"TRIPLE: 0x%x 0x%x 0x%x\n",Ts->state1,Ts->state2,Ts->state3);
}


static int
TRIPLEstruct_sgn(v1,v2)
	vindex v1,v2;
{
	return TRIPLEsgn_mp(v1->mp,v2->mp);
}

static TRIPLEstruct *
TRIPLEstruct_create()
{
	TRIPLEstruct * Ts = vzalloc1(TRIPLEstruct);
	return Ts;
}

static void
TRIPLEstruct_kill(v)
	vindex v;
{
	assert(v->mp);
	assert((v->fntab)==TRIPLE);
	Free_dp(v->mp); v->mp=0;
}

static void
TRIPLEstruct_print(wfile,v)
	FILE * wfile;
	vindex v;
{
	assert((v->fntab)==TRIPLE);
	TRIPLEprint_mp(wfile,v->mp);
}

static int
LISTstruct_sgn(v1,v2)
	vindex v1;
	vindex v2;
{
	int sgn=0;
	list * lp1=((LISTstruct *)(v1->mp))->listp;	
	list * lp2=((LISTstruct *)(v2->mp))->listp;	
	if (lp1==0 && lp2==0)
		sgn=0;
	else if (lp1==0)
		sgn=1;
	else if (lp2==0)
		sgn = -1;
	else
		sgn = list_sgn(lp1,lp2);
	return sgn;
}	
		
static LISTstruct *
LISTstruct_create()
{
	LISTstruct * Cs = vzalloc1(LISTstruct);
	Cs->listp=0;
	return Cs;
}

static void
LISTstruct_kill(v)
	vindex v;
{
	LISTstruct *Cs = (LISTstruct *)(v->mp);
	assert(v->mp);
	assert((v->fntab)==LIST);
	if (Cs->listp){
		list_clear(Cs->listp);
		Free_dp((dp)Cs->listp); Cs->listp=0;
	}
	Free_dp(v->mp); v->mp=0;
}

static void
LISTstruct_print(wfile,v)
	FILE * wfile;
	vindex v;
{
	LISTstruct * Cs = (LISTstruct *)(v->mp);
	assert((v->fntab)==LIST);
	assert(Cs);
	fprintf(wfile,"LIST \n");
	list_print(wfile,Cs->listp);
}

lg *
fsa_or(fsa1,fsa2)
	lg * fsa1;
	lg * fsa2;
{
	lg *  or;
	vindex v;
	vindex v1;
	vindex v2;
	vtxhashlist vertices;
	int N;
	int hashsize=1;
	int hash;
	list fringe;
	assert(fsa1->degree==fsa2->degree);
	degree=fsa1->degree;
	if (get_type(fsa1)!=OPT_FSA)
		fsa_opt(2,fsa1);
	lg_set_indices(fsa1);
	if (get_type(fsa2)!=OPT_FSA)
		fsa_opt(2,fsa2);
	lg_set_indices(fsa2);
	N=get_num_verts(fsa1)+2*get_num_verts(fsa2);
	while (hashsize<N)
		hashsize *=2;
	vtxhashlist_init(&vertices,hashsize);
	list_init(&fringe,VINDEX,FIFO);
	or = vzalloc1(lg);
	lg_init(or,PAIR,BASIC_FSA,degree);
	v=basept(or);
	v1=basept(fsa1);
	v2=basept(fsa2);
	list_init(&fringe,VINDEX,FIFO);
	set_state1(v,v1);
	set_state2(v,v2);
	set_category(v,max(get_category(v1),get_category(v2)));
	hash=get_index(v1)+2*get_index(v2);
	list_insert(&fringe,(dp)&v);
	vtxhashlist_insert(&vertices,&v,hash);
	while (list_delget_first(&fringe,(dp)&v)){
		int g;
		v1=get_state1(v);
		v2=get_state2(v);
		for (g=1;g<=degree;g++){
			vindex vg=UNDEFINED; 
			vindex v1g=UNDEFINED;
			vindex v2g=UNDEFINED;
			if (v1!=UNDEFINED)
				v1g=get(v1,g);
			if (v2!=UNDEFINED)
				v2g=get(v2,g);
			if (v1g!=UNDEFINED||v2g!=UNDEFINED){
				vindex w=UNDEFINED;
				vg=lg_vertex_create(or); 
				set_state1(vg,v1g);
				set_state2(vg,v2g);
				hash=get_index(v1g)+2*get_index(v2g);
			if (vtxhashlist_find(&vertices,&vg,&w,hash)){
					lg_vertex_kill(or,vg);
					vg=w;
				}
				else{ 
					if (v1g==UNDEFINED)
					set_category(vg,get_category(v2g));
					else if (v2g==UNDEFINED)
					set_category(vg,get_category(v1g));
					else
		set_category(vg,max(get_category(v1g),get_category(v2g)));
					list_insert(&fringe,(dp)&vg); 
				vtxhashlist_insert(&vertices,&vg,hash);
				} 
				set(v,g,vg); 
			}
		}
	}
	list_clear(&fringe);
	vtxhashlist_clear(&vertices);
	fsa_opt(2,or);
	return or;
}
		

lg *
fsa_and(fsa1,fsa2)
	lg * fsa1;
	lg * fsa2;
{
	lg  * and;
	vindex v;
	vindex v1;
	vindex v2;
	vtxhashlist vertices;
	int N;
	int hashsize=1;
	int hash;
	list fringe;
	assert(fsa1->degree==fsa2->degree);
	degree=fsa1->degree;
	if (get_type(fsa1)!=OPT_FSA)
		fsa_opt(2,fsa1);
	lg_set_indices(fsa1);
	if (get_type(fsa2)!=OPT_FSA)
		fsa_opt(2,fsa2);
	lg_set_indices(fsa2);
	N=get_num_verts(fsa1)+2*get_num_verts(fsa2);
	while (hashsize<N)
		hashsize *=2;
	vtxhashlist_init(&vertices,hashsize);
	and = vzalloc1(lg);
	lg_init(and,PAIR,BASIC_FSA,degree);
	v=basept(and);
	v1=basept(fsa1);
	v2=basept(fsa2);
	list_init(&fringe,VINDEX,FIFO);
	set_state1(v,v1);
	set_state2(v,v2);
	if (get_category(v1)==ACCEPTSTATE)
		set_category(v,get_category(v2));
	else
		set_category(v,NONACCEPTSTATE);
	hash=get_index(v1)+2*get_index(v2);
	list_insert(&fringe,(dp)&v);
	vtxhashlist_insert(&vertices,&v,hash);
	while (list_delget_first(&fringe,(dp)&v)){
		int g;
		v1=get_state1(v);
		v2=get_state2(v);
		for (g=1;g<=degree;g++){
			vindex vg=UNDEFINED; 
	/* we don't have to worry about v1 or v2 being undefined in the and
machine */
			vindex v1g=get(v1,g);
			vindex v2g=get(v2,g);
			if (v1g!=UNDEFINED&&v2g!=UNDEFINED){
				vindex w=UNDEFINED;
				vg=lg_vertex_create(and); 
				set_state1(vg,v1g);
				set_state2(vg,v2g);
				hash=get_index(v1g)+2*get_index(v2g);
				if (vtxhashlist_find(&vertices,&vg,&w,hash)){
					lg_vertex_kill(and,vg);
					vg=w;
				}
				else {
					if (get_category(v1g)==ACCEPTSTATE)
						set_category(vg,get_category(v2g));
					else
						set_category(vg,NONACCEPTSTATE);
					list_insert(&fringe,(dp)&vg); 
					vtxhashlist_insert(&vertices,&vg,hash);
				} 
				set(v,g,vg); 
			}
		}
	}
	list_clear(&fringe);
	vtxhashlist_clear(&vertices);
	fsa_opt(2,and);
	return and;
}


static int min_category(lp)
	list * lp;
{
	int ans=ACCEPTSTATE;
	vindex w;
	list_traverser lt;
	list_traverser_init(&lt,lp);
	while (list_next(&lt,(dp)&w))
		ans = min(ans,get_category(w));
	list_traverser_clear(&lt);
	return ans;
}

	
static int max_category(lp)
	list * lp;
{
	int ans=NONACCEPTSTATE;
	vindex w;
	list_traverser lt;
	list_traverser_init(&lt,lp);
	while (list_next(&lt,(dp)&w))
		ans = max(ans,get_category(w));
	list_traverser_clear(&lt);
	return ans;
}

	
lg *
fsa_not(fsa)
	lg * fsa;
{
	int degree=fsa->degree;
	lg * not;
	list vertices;
	vindex v;
	vindex sink=UNDEFINED;
	int g;
	bfs_traverser nott;
	if (get_type(fsa)!=OPT_FSA)
		fsa_opt(2,fsa); 
	list_init(&vertices,VINDEX,FIFO);
	not = vzalloc1(lg);
	lg_init(not,GENERIC,OPT_FSA,degree);
	lg_cpy(fsa,not);
	bfs_init(&nott,not);
	while (bfs_next(&nott,&v))
		list_insert(&vertices,(dp)&v);
	bfs_clear(&nott);
	while (list_delget_first(&vertices,(dp)&v)){
		for (g=1;g<=degree;g++)
			if (get(v,g)==UNDEFINED){
				if (sink==UNDEFINED){
					int h;
					sink=lg_vertex_create(not);
					set_category(sink,ACCEPTSTATE);
					for (h=1;h<=degree;h++)
						set(sink,h,sink);
				}
				set(v,g,sink);
			}
		if (get_category(v)==ACCEPTSTATE)
			set_category(v,NONACCEPTSTATE);
		else if (get_category(v)==NONACCEPTSTATE)
			set_category(v,ACCEPTSTATE);
	}
	list_clear(&vertices);
	return not;
}
		
	
lg *
fsa_exists(fsa,coordinate)
	lg * fsa;
	int coordinate; /* equal to 1 or 2 */
{
	lg * pre_exists;
	lg * exists;
	list fringe;
	vtxhashlist vertices;
	int N;
	int hashsize=1;
	int hash;
	list * states;
	vindex v;
	int g;
	int degree=0;
	while (degree*degree<fsa->degree)
		degree++;
	if (get_type(fsa)!=OPT_FSA)
		fsa_opt(2,fsa);
	lg_set_indices(fsa);
	N=get_num_verts(fsa);
	while (hashsize<N)
		hashsize *=2;
	vtxhashlist_init(&vertices,hashsize);
	pre_exists = vzalloc1(lg);
	lg_init(pre_exists,LIST,BASIC_FSA,degree);
	v=basept(pre_exists);
	states=vzalloc1(list);
	list_init(states,ASINT_VINDEX,ORDERED);
	list_init(&fringe,VINDEX,FIFO);
	list_insert(states,(dp)&(basept(fsa)));
	set_listp(v,states);
	states=0;
	set_category(v,get_category(basept(fsa)));
	hash=get_index(basept(fsa))&(hashsize-1);
	list_insert(&fringe,(dp)&v);
	vtxhashlist_insert(&vertices,&v,hash);
	while (list_delget_first(&fringe,(dp)&v)){
		for (g=1;g<=degree;g++){
			vindex vg=UNDEFINED;
			vindex u=UNDEFINED;
			list * image;
			list_traverser lt;
			vindex w,x;
			gen h;
			image = vzalloc1(list);
			list_init(image,ASINT_VINDEX,ORDERED);
			list_traverser_init(&lt,get_listp(v));
			while (list_next(&lt,(dp)&w)){
				for (h=1;h<=degree;++h){
					if (coordinate==1)
						x=get(w,degree*(h-1)+g);
					else if (coordinate==2)
						x=get(w,degree*(g-1)+h);
					if (x!=UNDEFINED)
						list_insert(image,(dp)&x);
				}
			}
			list_traverser_clear(&lt);
			if (list_empty(image)){
				list_clear(image);
				Free_dp((dp)image); image=0;
			}
			else {
				vg=lg_vertex_create(pre_exists); 
				set_listp(vg,image);
				hash=statelist_hash(image,hashsize-1);
				if (vtxhashlist_find(&vertices,&vg,&u,hash)){
					lg_vertex_kill(pre_exists,vg);
					vg=u;
				}
				else { 
					set_category(vg,max_category(image));
					list_insert(&fringe,(dp)&vg);
					vtxhashlist_insert(&vertices,&vg,hash);
				} 
				set(v,g,vg); 
			}
		}
	}
	list_clear(&fringe);
	vtxhashlist_clear(&vertices);
	fsa_opt(2,pre_exists);
	exists=fsa_eosclosure(pre_exists);
	lg_clear(pre_exists);
	Free_dp((dp)pre_exists); pre_exists=0;
	return exists;
}

lg *
fsa_exists_x2y1(fsa1,fsa2)
	lg * fsa1;
	lg * fsa2;
{
	lg * exists;
	lg * pre_exists;
	list fringe;
	vtxhashlist vertices;
	int hashsize=1;
	int N;
	list * pairs = 0;
	PAIRstruct Ps;
	PAIRstruct Ps1;
	PAIRstruct Ps2;
	vindex v;
	int hash;
	int degree=fsa1->degree;
	int num_syms=0;
	assert(degree==fsa2->degree);
	while ((num_syms*num_syms)<degree)
		num_syms++;
	if (get_type(fsa1)!=OPT_FSA)
		fsa_opt(2,fsa1);
	lg_set_indices(fsa1);
	if (get_type(fsa2)!=OPT_FSA)
		fsa_opt(2,fsa2);
	lg_set_indices(fsa2);
	N=get_num_verts(fsa1)+2*get_num_verts(fsa2);
	while (hashsize<N)
		hashsize *=2;
	list_init(&fringe,VINDEX,FIFO);
	vtxhashlist_init(&vertices,hashsize);
	pre_exists = vzalloc1(lg);
	lg_init(pre_exists,LIST,BASIC_FSA,degree);
	v=basept(pre_exists);
	pairs=vzalloc1(list);
	list_init(pairs,PAIRpocket,ORDERED);
	Ps.state1=basept(fsa1);
	Ps.state2=basept(fsa2);
	set_category(v,min(get_category(Ps.state1),get_category(Ps.state2)));
	list_insert(pairs,(dp)&Ps);
	set_listp(v,pairs);
	hash=(get_index(Ps.state1)+2*get_index(Ps.state2)) & (hashsize-1);
	pairs=0;
	list_insert(&fringe,(dp)&v);
	vtxhashlist_insert(&vertices,&v,hash);
	while (list_delget_first(&fringe,(dp)&v)){
		int x;
		for (x=1;x<=num_syms;x++){
			int y;
			for (y=1;y<=num_syms;y++){
				list_traverser lt;
				int i;
				pairs = vzalloc1(list);
				list_init(pairs,PAIRpocket,ORDERED);
				list_traverser_init(&lt,get_listp(v));
				while (list_next(&lt,(dp)&Ps1))
				for (i=1;i<=num_syms;i++)
					if ((Ps2.state1=get(Ps1.state1,((x-1)*num_syms)+i))!=UNDEFINED)
						if ((Ps2.state2=get(Ps1.state2,(i-1)*num_syms+y))!=UNDEFINED)
							list_insert(pairs,(dp)&Ps2);
				list_traverser_clear(&lt);
				if (list_empty(pairs)){
					list_clear(pairs);
					Free_dp((dp)pairs); pairs=0;
				}
				else {
					vindex vxy=UNDEFINED;
					vindex w=UNDEFINED;
					vxy=lg_vertex_create(pre_exists);
					set_listp(vxy,pairs);
					hash=0;
					list_traverser_init(&lt,pairs);
					while (list_next(&lt,(dp)&Ps))
						hash = (4*hash + get_index(Ps.state1) + 2*get_index(Ps.state2))&(hashsize-1);
					list_traverser_clear(&lt);
					if (vtxhashlist_find(&vertices,&vxy,&w,hash)){
						lg_vertex_kill(pre_exists,vxy);
						set(v,((x-1)*num_syms)+y,w);
					}
					else{
						int cat=NONACCEPTSTATE;
						list_traverser_init(&lt,pairs);
						while (list_next(&lt,(dp)&Ps))
						if (get_category(Ps.state1)==ACCEPTSTATE&&get_category(Ps.state2)==ACCEPTSTATE){
							cat=ACCEPTSTATE;
							break;
						}
						list_traverser_clear(&lt);
						set_category(vxy,cat);
						list_insert(&fringe,(dp)&vxy);
						vtxhashlist_insert(&vertices,&vxy,hash);
						set(v,((x-1)*num_syms)+y,vxy);
					}
				}
			}
		}
	}
	list_clear(&fringe);
	vtxhashlist_clear(&vertices);
	fsa_opt(2,pre_exists);
	exists=fsa_eosclosure(pre_exists);
	lg_clear(pre_exists);
	Free_dp((dp)pre_exists); pre_exists=0;
	return exists;
}
	
		
boolean 
fsa_is_diag(fsa)
	lg * fsa;
{
	boolean ans=TRUE;
	bfs_traverser bfst;
	int d=0;
	gen g,h;
	vindex v;
	while (d*d<fsa->degree)
		d++;
	if (d*d>fsa->degree)
		return FALSE;
	bfs_init(&bfst,fsa);
	while (bfs_next(&bfst,&v)){
		for  (g=1;g<=d;g++){
			for (h=1;h<=d;h++){
				if (g==h)
					continue;
				else if (get(v,(g-1)*d+h)!=UNDEFINED){
					ans=FALSE;
					break;
				}
			}
			if (ans==FALSE)
				break;
		}
		if (ans==FALSE)
			break;
	}
	bfs_clear(&bfst);
	return ans;
}

lg *
fsa_diag(fsa)
	lg * fsa;
{
	lg * diag;
	int degree=fsa->degree;
	int num_verts;
	vindex * vertices1;
	vindex * vertices2;
	vindex v;
	vindex w;
	int g;
	int i=1;
	bfs_traverser fsat;
	if (get_type(fsa)!=OPT_FSA)
		fsa_opt(2,fsa); 
	num_verts=get_num_verts(fsa);
	diag = vzalloc1(lg);
	lg_init(diag,GENERIC,OPT_FSA,degree*degree);
	vertices1=vzalloc2(vindex,num_verts+1);
	vertices2=vzalloc2(vindex,num_verts+1);
	bfs_init(&fsat,fsa);
	while (bfs_next(&fsat,&v)){
		vertices1[i]=v;
		set_index(v,i++);
	}
	bfs_clear(&fsat);
	vertices2[1]=basept(diag);
	for (i=2;i<=num_verts;i++)
		vertices2[i]=lg_vertex_create(diag);
	for (i=1;i<=num_verts;i++){
		v=vertices2[i];
		set_category(v,get_category(vertices1[i]));
		for (g=1;g<=degree;g++)
			if ((w=get(vertices1[i],g))!=UNDEFINED)
				set(v,((g-1)*degree)+g,vertices2[get_index(w)]);
	}
	Free_dp((dp)vertices1); vertices1=0;
	Free_dp((dp)vertices2); vertices2=0;
	return diag;
}
	

lg*
fsa_eosdelete(fsa)
	lg * fsa;
{
	lg * eosdelete;
	list fringe;
	vtxhashlist vertices;
	int hash;
	int N;
	int hashsize=1;
	list * states;
	list * image;
	list_traverser lt;
	vindex v=UNDEFINED;
	vindex x=UNDEFINED;
	vindex w=UNDEFINED;
	int g;
	degree=fsa->degree;
	if (get_type(fsa)!=OPT_FSA)
		fsa_opt(2,fsa);
	lg_set_indices(fsa);
	N=get_num_verts(fsa);
	while (hashsize<N)
		hashsize *=2;
	eosdelete = vzalloc1(lg);
	lg_init(eosdelete,LIST,BASIC_FSA,degree-1);
	list_init(&fringe,VINDEX,FIFO);
	vtxhashlist_init(&vertices,hashsize);
	v=basept(eosdelete);
	states=vzalloc1(list);
	list_init(states,ASINT_VINDEX,ORDERED);
	list_insert(states,(dp)&(basept(fsa)));
	w=basept(fsa);
	list_insert(states,(dp)&w);
	while ((x=get(w,degree))!=UNDEFINED){
		if (x==w||list_insert(states,(dp)&x)==FALSE)
			break;
		else
			w=x;
	}
	set_listp(v,states);
	hash=statelist_hash(states,hashsize-1);
	set_category(v,max_category(states));
	states=0;
	list_insert(&fringe,(dp)&v);
	vtxhashlist_insert(&vertices,&v,hash);
	while (list_delget_first(&fringe,(dp)&v)){
		for (g=1;g<degree;g++){
			vindex vg=UNDEFINED;
			image = vzalloc1(list);
			list_init(image,ASINT_VINDEX,ORDERED);
			list_traverser_init(&lt,get_listp(v));
			while (list_next(&lt,(dp)&w)){
				w=get(w,g);
				if (w!=UNDEFINED){
					list_insert(image,(dp)&w);
					while ((x=get(w,degree))!=UNDEFINED){
						if (x==w||list_insert(image,(dp)&x)==FALSE)
							break;
						else
							w=x;
					}
				}
			}
			list_traverser_clear(&lt);
			if (list_empty(image)){
				list_clear(image);
				Free_dp((dp)image); image=0;
			}
			else{
				vg=lg_vertex_create(eosdelete); 
				hash=statelist_hash(image,hashsize-1);
				set_listp(vg,image);
				if (vtxhashlist_find(&vertices,&vg,&w,hash)){
					lg_vertex_kill(eosdelete,vg);
					set(v,g,w);
				}
				else {
					set_category(vg,max_category(image));
					set(v,g,vg);
					list_insert(&fringe,(dp)&vg);
					vtxhashlist_insert(&vertices,&vg,hash);
				}	
			}
		}
	}
	list_clear(&fringe);
	vtxhashlist_clear(&vertices);
	fsa_opt(2,eosdelete);
	return eosdelete;
}

lg*
fsa_eosinsert(fsa)
	lg * fsa;
{
	lg * eosinsert;
	int degree=fsa->degree;
	int num_verts;
	vindex * vertices1;
	vindex * vertices2;
	vindex v;
	vindex w;
	int g;
	int i=1;
	bfs_traverser fsat;
	boolean sink=FALSE;
	if (get_type(fsa)!=OPT_FSA)
		fsa_opt(2,fsa); 
	num_verts=get_num_verts(fsa);
	eosinsert = vzalloc1(lg);
	lg_init(eosinsert,GENERIC,OPT_FSA,degree+1);
	vertices1=vzalloc2(vindex,num_verts+1);
	vertices2=vzalloc2(vindex,num_verts+2);
	bfs_init(&fsat,fsa);
	while (bfs_next(&fsat,&v)){
		vertices1[i]=v;
		set_index(v,i++);
	}
	bfs_clear(&fsat);
	vertices2[1]=basept(eosinsert);
	for (i=2;i<=num_verts+1;i++)
		vertices2[i]=lg_vertex_create(eosinsert);
	for (i=1;i<=num_verts;i++){
		v=vertices2[i];
		set_category(v,NONACCEPTSTATE);
		for (g=1;g<=degree;g++)
			if ((w=get(vertices1[i],g))!=UNDEFINED)
				set(v,g,vertices2[get_index(w)]);
		if (get_category(vertices1[i])==ACCEPTSTATE){
			set(v,degree+1,vertices2[num_verts+1]);
			sink=TRUE;
		}
	}
	if (sink){
		set_category(vertices2[num_verts+1],ACCEPTSTATE);
		set(vertices2[num_verts+1],degree+1,vertices2[num_verts+1]);
	}
	else
		lg_vertex_kill(eosinsert,vertices2[num_verts+1]);
	Free_dp((dp)vertices1); vertices1=0;
	Free_dp((dp)vertices2); vertices2=0;
	return eosinsert;
}

lg*
fsa_eosclosure(fsa)
	lg * fsa;
{
	lg * eosclosure;
	list fringe;
	vtxhashlist vertices;
	int hash;
	int N;
	int hashsize=1;
	list * states;
	list * image;
	list_traverser lt;
	vindex v=UNDEFINED;
	vindex x=UNDEFINED;
	vindex w=UNDEFINED;
	int g;
	degree=fsa->degree;
	if (get_type(fsa)!=OPT_FSA)
		fsa_opt(2,fsa);
	lg_set_indices(fsa);
	N=get_num_verts(fsa);
	while (hashsize<N)
		hashsize *=2;
	eosclosure = vzalloc1(lg);
	lg_init(eosclosure,LIST,BASIC_FSA,degree);
	list_init(&fringe,VINDEX,FIFO);
	vtxhashlist_init(&vertices,hashsize);
	v=basept(eosclosure);
	states=vzalloc1(list);
	list_init(states,ASINT_VINDEX,ORDERED);
	list_insert(states,(dp)&(basept(fsa)));
	w=basept(fsa);
	list_insert(states,(dp)&w);
	set_listp(v,states);
	hash=statelist_hash(states,hashsize-1);
	set_category(v,max_category(states));
	states=0;
	list_insert(&fringe,(dp)&v);
	vtxhashlist_insert(&vertices,&v,hash);
	while (list_delget_first(&fringe,(dp)&v)){
		for (g=1;g<=degree;g++){
			vindex vg=UNDEFINED;
			image = vzalloc1(list);
			list_init(image,ASINT_VINDEX,ORDERED);
			list_traverser_init(&lt,get_listp(v));
			while (list_next(&lt,(dp)&w)){
				w=get(w,g);
				if (w!=UNDEFINED){
					list_insert(image,(dp)&w);
					if (g==degree){
						while ((x=get(w,degree))!=UNDEFINED){
							if (x==w||list_insert(image,(dp)&x)==FALSE)
								break;
							else
								w=x;
						}
					}
				}
			}
			list_traverser_clear(&lt);
			if (list_empty(image)){
				list_clear(image);
				Free_dp((dp)image); image=0;
			}
			else{
				vg=lg_vertex_create(eosclosure); 
				hash=statelist_hash(image,hashsize-1);
				set_listp(vg,image);
				if (vtxhashlist_find(&vertices,&vg,&w,hash)){
					lg_vertex_kill(eosclosure,vg);
					set(v,g,w);
				}
				else {
					set_category(vg,max_category(image));
					set(v,g,vg);
					list_insert(&fringe,(dp)&vg);
					vtxhashlist_insert(&vertices,&vg,hash);
				}	
			}
		}
	}
	list_clear(&fringe);
	vtxhashlist_clear(&vertices);
	fsa_opt(2,eosclosure);
	return eosclosure;
}


int
statelist_hash(lp,m)
	list * lp;
	int m;
{
	int ans=0;
	vindex w;
	list_traverser lt;
	list_traverser_init(&lt,lp);
	while (list_next(&lt,(dp)&w))
		ans=(2*ans+get_index(w))&m;
	list_traverser_clear(&lt);
	return ans;
}
	


lg * fsa_swapxy(fsa)
	lg * fsa;
{
	lg * swap;
	int degree=fsa->degree;
	int num_syms=0;
	int num_verts;
	vindex * vertices1;
	vindex * vertices2;
	vindex v;
	vindex w;
	int g;
	int h;
	int i=1;
	bfs_traverser fsat;
	if (get_type(fsa)!=OPT_FSA)
		fsa_opt(2,fsa); 
	num_verts=get_num_verts(fsa);
	while ((num_syms*num_syms)<degree)
		num_syms++;
	swap = vzalloc1(lg);
	lg_init(swap,GENERIC,OPT_FSA,degree);
	vertices1=vzalloc2(vindex,num_verts+1);
	vertices2=vzalloc2(vindex,num_verts+1);
	bfs_init(&fsat,fsa);
	while (bfs_next(&fsat,&v)){
		vertices1[i]=v;
		set_index(v,i++);
	}
	bfs_clear(&fsat);
	vertices2[1]=basept(swap);
	for (i=2;i<=num_verts;i++)
		vertices2[i]=lg_vertex_create(swap);
	for (i=1;i<=num_verts;i++){
		v=vertices2[i];
		set_category(v,get_category(vertices1[i]));
		for (g=1;g<=num_syms;g++)
			for (h=1;h<=num_syms;h++)
				if ((w=get(vertices1[i],((g-1)*num_syms)+h))!=UNDEFINED)
					set(v,((h-1)*num_syms)+g,vertices2[get_index(w)]);
	}
	Free_dp((dp)vertices1); vertices1=0;
	Free_dp((dp)vertices2); vertices2=0;
	return swap;
}
	

/*Pairs of strings are accepted where either or both strings are terminated
with any number of |$| symbols. |$| symbols are not acceptable except at the
ends of strings
*/
lg*
fsa_preprocessor1()
{
	lg * preprocessor;
	int i;
	int g;
	vindex * vertices;
	int eos=num_gens+1;

	preprocessor = vzalloc1(lg);
	vertices = vzalloc2(vindex,8);
	lg_init(preprocessor,GENERIC,OPT_FSA,num_gens+1);
	if (num_gens==0){
		vertices[1]=lg_vertex_create(preprocessor);
		set_category(vertices[1],NONACCEPTSTATE);
		set(basept(preprocessor),eos,vertices[1]);
		set(vertices[1],eos,basept(preprocessor));
	}
	else {
		for (i=1;i<=7;i++)
			vertices[i]=lg_vertex_create(preprocessor);
		for (i=1;i<=7;i+=2)
			set_category(vertices[i],NONACCEPTSTATE);
		set(basept(preprocessor),eos,vertices[3]);
		set(vertices[1],eos,vertices[4]);
		set(vertices[2],eos,vertices[3]);
		set(vertices[3],eos,vertices[6]);
		set(vertices[4],eos,vertices[7]);
		set(vertices[5],eos,vertices[4]);
		set(vertices[6],eos,vertices[7]);
		set(vertices[7],eos,vertices[6]);
		for (g=1;g<=num_gens;++g){
			set(basept(preprocessor),g,vertices[1]);
			set(vertices[1],g,basept(preprocessor));
			set(vertices[3],g,vertices[2]);
			set(vertices[4],g,vertices[5]);
		}
	}
	Free_dp((dp)vertices); vertices=0;
	return preprocessor;
}

/*
Pairs of strings are accepted where at most one  strings is terminated
with any number of |$| symbols. |$| symbols are not acceptable except at the
ends of strings
*/
lg *
fsa_preprocessor2()
{
	lg * preprocessor;
	int i;
	int g;
	vindex * vertices;
	int eos=num_gens+1;

	preprocessor = vzalloc1(lg);
	vertices = vzalloc2(vindex,6);
	lg_init(preprocessor,GENERIC,OPT_FSA,num_gens+1);
	for (i=1;i<=5;i++)
		vertices[i]=lg_vertex_create(preprocessor);
	for (i=0;i<=4;i+=2)
			set_category(vertices[i],NONACCEPTSTATE);
	for (i=1;i<=5;i+=2)
			set_category(vertices[i],NONACCEPTSTATE);
	set(basept(preprocessor),eos,vertices[3]);
	set(vertices[1],eos,vertices[4]);
	set(vertices[2],eos,vertices[3]);
	set(vertices[5],eos,vertices[4]);
	for (g=1;g<=num_gens;++g){
		set(basept(preprocessor),g,vertices[1]);
		set(vertices[1],g,basept(preprocessor));
		set(vertices[3],g,vertices[2]);
		set(vertices[4],g,vertices[5]);
	}
	Free_dp((dp)vertices); vertices=0;
	return preprocessor;
}

lg *
fsa_false(degree)
	int degree;
{
	lg * false;
	int g;
	false = vzalloc1(lg);
	lg_init(false,GENERIC,OPT_FSA,degree);
	set_category(basept(false),NONACCEPTSTATE);
	for (g=1;g<=degree;g++)
		set(basept(false),g,UNDEFINED);
	return false;
}

lg *
fsa_prod(fsa1,fsa2)
	lg * fsa1;
	lg * fsa2;
{
	lg *prod=0;
	
	vindex v;
	int N=get_num_verts(fsa1);
	list fringe;
	vtxhashlist vertices;
	int hash;
	int hashsize=1;
	lg_set_indices(fsa1);
	lg_set_indices(fsa2);
	prod=vzalloc1(lg);
	lg_init(prod,PAIR,BASIC_FSA,(num_gens+1)*(num_gens+1));
	v=basept(prod);
	while (hashsize<N)
		hashsize*=2;
	vtxhashlist_init(&vertices,hashsize);
	list_init(&fringe,VINDEX,FIFO);
	
	set_1state(v,basept(fsa1));
	set_2state(v,basept(fsa2));
	hash=get_index(basept(fsa1))+2*get_index(basept(fsa2));
	list_insert(&fringe,(dp)&v);
	vtxhashlist_insert(&vertices,&v,hash);
	while (list_delget_first(&fringe,(dp)&v)){
		int x;
		for (x=1;x<=num_gens+1;x++){
			vindex v1x=get(get_1state(v),x);
			int y;
			for (y=1;y<=num_gens+1;y++){
				int z=(num_gens+1)*(x-1)+y;
				vindex v2y=get(get_2state(v),y);
				if (v1x!=UNDEFINED&&v2y!=UNDEFINED){
					vindex w=UNDEFINED;
					vindex vz=lg_vertex_create(prod);
					set_1state(vz,v1x);
					set_2state(vz,v2y);
					if (get_category(v1x)==ACCEPTSTATE && get_category(v2y)==ACCEPTSTATE)
						set_category(vz,ACCEPTSTATE);
					else
						set_category(vz,NONACCEPTSTATE);
					hash=get_index(v1x)+2*get_index(v2y);
					assert(hash!=0);
		/* does this state already exist? */
					if (vtxhashlist_find(&vertices,&vz,&w, hash)){
						lg_vertex_kill(prod,vz);
						vz=w;
					}
					else {
						list_insert(&fringe,(dp)&vz);
						vtxhashlist_insert(&vertices,&vz,hash);
					}
					set(v,z,vz);
				}
			}
		}
	}
	list_clear(&fringe);
	vtxhashlist_clear(&vertices);
	fsa_opt(2,prod); 
	return prod;
}

lg *
fsa_doubleprod(fsa1,fsa2)
	lg * fsa1;
	lg * fsa2;
{
	lg *prod=0;
	
	vindex v;
	int N=get_num_verts(fsa1);
	list fringe;
	vtxhashlist vertices;
	int hash;
	int hashsize=1;
	lg_set_indices(fsa1);
	lg_set_indices(fsa2);
	prod=vzalloc1(lg);
	lg_init(prod,TRIPLE,BASIC_FSA,(num_gens+1)*(num_gens+1));
	v=basept(prod);
	while (hashsize<N)
		hashsize*=2;
	vtxhashlist_init(&vertices,hashsize);
	list_init(&fringe,VINDEX,FIFO);
	
	set_1state(v,basept(fsa1));
	set_2state(v,basept(fsa1));
	set_3state(v,basept(fsa2));
	if (get_category(basept(fsa1))==ACCEPTSTATE)
						set_category(v,get_category(basept(fsa2)));
					else
						set_category(v,NONACCEPTSTATE);
	hash=get_index(basept(fsa1))+2*get_index(basept(fsa1))+4*get_index(basept(fsa2));
	list_insert(&fringe,(dp)&v);
	vtxhashlist_insert(&vertices,&v,hash);
	while (list_delget_first(&fringe,(dp)&v)){
		int x;
		for (x=1;x<=num_gens+1;x++){
			vindex v1x=get(get_1state(v),x);
			int y;
			for (y=1;y<=num_gens+1;y++){
				int z=(num_gens+1)*(x-1)+y;
				vindex v2y=get(get_2state(v),y);
				vindex v3z=get(get_3state(v),z);
				if (v1x!=UNDEFINED&&v2y!=UNDEFINED&&v3z!=UNDEFINED){
					vindex w=UNDEFINED;
					vindex vz=lg_vertex_create(prod);
					set_1state(vz,v1x);
					set_2state(vz,v2y);
					set_3state(vz,v3z);
					if (get_category(v1x)==ACCEPTSTATE && get_category(v2y)==ACCEPTSTATE)
						set_category(vz,get_category(v3z));
					else
						set_category(vz,NONACCEPTSTATE);
					hash=get_index(v1x)+2*get_index(v2y)+4*get_index(v3z);
					assert(hash!=0);
		/* does this state already exist? */
					if (vtxhashlist_find(&vertices,&vz,&w, hash)){
						lg_vertex_kill(prod,vz);
						vz=w;
					}
					else {
						list_insert(&fringe,(dp)&vz);
						vtxhashlist_insert(&vertices,&vz,hash);
					}
					set(v,z,vz);
				}
			}
		}
	}
	list_clear(&fringe);
	vtxhashlist_clear(&vertices);
	fsa_opt(3+num_gens,prod); 
	return prod;
}

lg *
fsa_amalgcomp(fsa1,fsa2,fsa3)
	lg * fsa1;
	lg * fsa2;
	lg * fsa3;
{
	lg * comp;
	lg * pre_comp;
	list fringe;
	vtxhashlist vertices;
	int hashsize=1;
	int N;
	list * triple = 0;
	TRIPLEstruct Ts;
	TRIPLEstruct Ts1;
	TRIPLEstruct Ts2;
	vindex v;
	int hash;
	int degree=fsa1->degree;
	int num_syms=0;
	assert(degree==fsa2->degree);
	while ((num_syms*num_syms)<degree)
		num_syms++;
	if (get_type(fsa1)!=OPT_FSA)
		fsa_opt(2,fsa1);
	lg_set_indices(fsa1);
	if (get_type(fsa2)!=OPT_FSA)
		fsa_opt(2,fsa2);
	lg_set_indices(fsa2);
	if (get_type(fsa3)!=OPT_FSA)
		fsa_opt(2,fsa3);
	lg_set_indices(fsa3);
	N=get_num_verts(fsa1)+2*get_num_verts(fsa2)+4*get_num_verts(fsa3);;
	while (hashsize<N)
		hashsize *=2;
	list_init(&fringe,VINDEX,FIFO);
	vtxhashlist_init(&vertices,hashsize);
	pre_comp = vzalloc1(lg);
	lg_init(pre_comp,LIST,BASIC_FSA,degree);
	v=basept(pre_comp);
	triple=vzalloc1(list);
	list_init(triple,TRIPLEpocket,ORDERED);
	Ts.state1=basept(fsa1);
	Ts.state2=basept(fsa2);
	Ts.state3=basept(fsa3);
	if (get_category(Ts.state3)==ACCEPTSTATE)
		if (get_category(Ts.state1)==ACCEPTSTATE&&get_category(Ts.state2)==ACCEPTSTATE)
		set_category(v,ACCEPTSTATE);
	else
		set_category(v,NONACCEPTSTATE);
	list_insert(triple,(dp)&Ts);
	set_listp(v,triple);
	hash=(get_index(Ts.state1)+2*get_index(Ts.state2)+4*get_index(Ts.state3));
	hash=hash & (hashsize-1);
	triple=0;
	list_insert(&fringe,(dp)&v);
	vtxhashlist_insert(&vertices,&v,hash);
	while (list_delget_first(&fringe,(dp)&v)){
		int x;
		for (x=1;x<=num_syms;x++){
			int y;
			for (y=1;y<=num_syms;y++){
				list_traverser lt;
				int i;
				triple = vzalloc1(list);
				list_init(triple,TRIPLEpocket,ORDERED);
				list_traverser_init(&lt,get_listp(v));
				while (list_next(&lt,(dp)&Ts1))
				for (i=1;i<=num_syms;i++)
					if ((Ts2.state1=get(Ts1.state1,((x-1)*num_syms)+i))!=UNDEFINED)
						if ((Ts2.state2=get(Ts1.state2,(i-1)*num_syms+y))!=UNDEFINED)
							if ((Ts2.state3=get(Ts1.state3,i))!=UNDEFINED)
								list_insert(triple,(dp)&Ts2);
				list_traverser_clear(&lt);
				if (list_empty(triple)){
					list_clear(triple);
					Free_dp((dp)triple); triple=0;
				}
				else {
					vindex vxy=UNDEFINED;
					vindex w=UNDEFINED;
					vxy=lg_vertex_create(pre_comp);
					set_listp(vxy,triple);
					hash=0;
					list_traverser_init(&lt,triple);
					while (list_next(&lt,(dp)&Ts)){
						hash = (hash+get_index(Ts.state1)+2*get_index(Ts.state2)+4*get_index(Ts.state3));
						hash=hash&(hashsize-1);
					}
					list_traverser_clear(&lt);
					if (vtxhashlist_find(&vertices,&vxy,&w,hash)){
						lg_vertex_kill(pre_comp,vxy);
						set(v,((x-1)*num_syms)+y,w);
					}
					else{
						int cat=NONACCEPTSTATE;
						list_traverser_init(&lt,triple);
						while (list_next(&lt,(dp)&Ts))
						if (get_category(Ts.state3)==ACCEPTSTATE)
							if (get_category(Ts.state1)==ACCEPTSTATE&&get_category(Ts.state2)==ACCEPTSTATE){
							cat=ACCEPTSTATE;
							break;
						}
						list_traverser_clear(&lt);
						set_category(vxy,cat);
						list_insert(&fringe,(dp)&vxy);
						vtxhashlist_insert(&vertices,&vxy,hash);
						set(v,((x-1)*num_syms)+y,vxy);
					}
				}
			}
		}
	}
	list_clear(&fringe);
	vtxhashlist_clear(&vertices);
	fsa_opt(2,pre_comp);
	comp=fsa_eosclosure(pre_comp);
	lg_clear(pre_comp);
	Free_dp((dp)pre_comp); pre_comp=0;
	return comp;
}
	
