/* isom.d/src file testisom.c */
# define INITPAR  2
# define INITPAR2  20
# include <stdio.h>
# include <math.h>
# include <ctype.h>
#include <sys/types.h>
# include <sys/times.h>
# include "defs.h"
# include "input.h"
# include "gptree.h"
# define time_so_far ((buffer.tms_utime)/60 + (buffer.tms_cutime)/60) 
#define BOTH 0
#define ISO 1
#define NONISO 2
int mode = BOTH;
int exit_code;
char gp1[50], gp2[50];
char permgp[100];
#define NREG 6 /* inluding the trivial group */
#define NPERMGPS 38 /* including the trivial group */
char * permgps[NPERMGPS];
boolean nreps_checked[NPERMGPS]; 
boolean ns_checked[NREG]; 
int nregreps[NREG];
int bestpgp = 0, nrepsofbestpgp=0;
boolean permcheck_complete = FALSE;
char sfx1[50], sfx2[50], sfx3[50];
char rep[50];
char filename[100];
char command[200];
char label[9];
int par=INITPAR; /* used to bound the time and space used by various processes
which can only be run for a finite length of time */ 
int par2=INITPAR2;
int kb1run = 1;
int kb2run = 1;
FILE * rfile;
FILE * rfile2;
FILE * wfile;
FILE * wfile2;
struct tms buffer;
void list_permgps PARMS((VOID));
boolean nreps_check PARMS((int i,int time,int size,int * anreps));
boolean trivrep_normal_series_check PARMS((int time,int vtime));
boolean normal_series_check PARMS((int i,int time,int vtime));
gptree * normal_series 
PARMS((char * gp, char * rep,int time,int vtime,boolean * time_expiredp));
boolean is_prime PARMS((int i));
char  verbose=FALSE, keepfiles=FALSE;

main(argc,argv)
  int argc;
  char * argv[];
{
  boolean a,b;
  int i,j,arg;
  char * Gp1=gp1, * Gp2=gp2;
  boolean listpermgps=FALSE;
  
  for (i=0;i<NPERMGPS;i++)
    nreps_checked[i]=FALSE;
  for (i=0;i<NREG;i++)
    ns_checked[i]=FALSE;
  for (i=0;i<NREG;i++)
    nregreps[i]=0;
  list_permgps();

  arg=1;
  if (argc<=arg) badusage();
  while (argv[arg][0]=='-'){
    if (argv[arg][1]=='v') verbose=TRUE;
    else if (argv[arg][1]=='k') keepfiles=TRUE;
    else if (argv[arg][1]=='n') mode=NONISO;
    else if (argv[arg][1]=='i'){
      mode=ISO;
      permcheck_complete=TRUE;
    }
    else if (argv[arg][1]=='p'){
	  listpermgps=TRUE;
  	  for (i=1;i<NPERMGPS;i++)
        nreps_checked[i]=TRUE;
      for (i=1;i<NREG;i++)
        ns_checked[i]=TRUE;
      if (argc-2<=arg+1 || argv[arg+1][0]=='-'){
/* The last two arguments must be gp1 and gp2 */
		badusage();
        exit(2);
      }
	  else do {
        strcpy(permgp,argv[arg+1]);
		for (i=1;i<NPERMGPS;i++){
			if (strcmp(permgps[i],permgp)==0){
			  nreps_checked[i]=FALSE;
			  if (i<NREG)
				ns_checked[i]=FALSE;
			  break;
			}
		}
		if (i==NPERMGPS) /* permgp isn't in list */
			fprintf(stderr,
				"Sorry. %s isn't in our list of permutation groups.\n",permgp);
		arg++;
		} while (argc-2> arg+1 && argv[arg+1][0]!='-');
/* The last two arguments must be gp1 and gp2 */
	}
    else badusage();
    arg++;
    if (argc<=arg) badusage();
  }
  strcpy(gp1,argv[arg]);
  arg++;
  if (argc<=arg) badusage();
  strcpy(gp2,argv[arg]);

  setbuf(stdout,(char*)0);
  setbuf(stderr,(char*)0);

  sprintf(command,"ordrels %s",gp1);
  if (verbose) printf("%s\n",command);
  if (system(command)) exit_clear(2);
  sprintf(command,"ordrels %s",gp2);
  if (verbose) printf("%s\n",command);
  if (system(command)) exit_clear(2);
/* if mode is ISO and a permgp is specified, run permim on that group */
  if (mode==ISO && listpermgps){
    for (i=1;i<NPERMGPS;i++)
      if (nreps_checked[i]==FALSE){
        bestpgp=i;
        nreps_checked[i]=TRUE;
        break;
      }
    sprintf(command,"permim %s %s",permgps[bestpgp],gp1);
    if (verbose) printf("%s\n",command);
    if (system(command)) exit_clear(2);
    sprintf(command,"permim %s %s",permgps[bestpgp],gp2);
    if (verbose) printf("%s\n",command);
    if (system(command)) exit_clear(2);
  }
  sprintf(command,"abquot %s",gp1);
  if (verbose) printf("%s\n",command);
  if (system(command)) exit_clear(2);
  sprintf(command,"abquot %s",gp2);
  if (verbose) printf("%s\n",command);
  if (system(command)) exit_clear(2);
  if (mode!=ISO){
    sprintf(filename,"%s.abquot",gp1);
    rfile = fopen(filename,"r");
    sprintf(filename,"%s.abquot",gp2);
    rfile2 = fopen(filename,"r");
    (void)find_keyword("abinvariants",rfile);
    (void)find_keyword("abinvariants",rfile2);
    while (getc(rfile)!='{'); while (getc(rfile2)!='{');
    do {
      a=read_next_int(&i,rfile);
      b=read_next_int(&j,rfile2);
      if ((a)||(b))
        if (a==FALSE || b==FALSE || i!=j){
    printf("%s and %s cannot be isomorphic since their abelian\n",gp1,gp2);
    printf("quotients don't match.\n");
          exit_clear(0);
        }
    } while ((a)&&(b));
    fclose(rfile); fclose(rfile2);
  }

  while (mode!=NONISO ||permcheck_complete==FALSE){
    char * spare,
    verboseflag[5];
    int isomtime,prevtime;
    times(&buffer); prevtime = time_so_far;
	if (mode!=NONISO){
    	if (kb1run){
   sprintf(command,"kbeqn -t %d -o -h %d %d %d %s",10*par,par2,par2,par2/2,gp1); 
    	if (verbose) printf("%s\n",command);
    	kb1run = (system(command))/256;
    	if (kb1run>1) exit_clear(2);
    	}
    	if (kb2run){
   sprintf(command,"kbeqn -t %d -o -h %d %d %d %s",10*par,par2,par2,par2/2,gp2);
    	if (verbose) printf("%s\n",command);
    	kb2run = (system(command))/256;
    	if (kb2run>1) exit_clear(2);
    	}
    	if (verbose) strcpy(verboseflag," -v "); else strcpy(verboseflag,"");
    	if (bestpgp!=0 && nreps_checked[bestpgp])
      		sprintf(command,
            "findisoms%s -m 30 -tt %d -ot %d -s -p %s -a %s %s",
            verboseflag,par2,par2/10,permgps[bestpgp],Gp1,Gp2);
    	else 
      		sprintf(command,
            "findisoms%s -m 30 -tt %d -ot %d -a -s %s %s",
            verboseflag,par2,par2/10,Gp1,Gp2);
    	if (verbose) printf("%s\n",command);
    	exit_code=system(command)/256;
    	if (exit_code>1) exit_clear(2);
    	if (exit_code==0){
      		printf("Isomorphism found.\n");
      		exit_clear(0);
    	}
    	spare = Gp2; Gp2 = Gp1; Gp1 = spare; 
/* we swap the two groups over because findisoms may work much more 
effectively in one direction than the other */
    	times(&buffer);
    	isomtime = time_so_far-prevtime;
    	prevtime = time_so_far;
	}
	if (permcheck_complete){
    	par *=2;
   		par2 *= 5;
		continue;
	}
    if (ns_checked[0]==FALSE)
      ns_checked[0] = trivrep_normal_series_check(4*par,par);
    for (i=1;i<NPERMGPS;i++){
      if (nreps_checked[i]==FALSE){
        int nreps=0;
        if ((nreps_checked[i] =nreps_check(i,10*par,10*par,&nreps))==FALSE)
          break; /* permim has failed on the i-th perm group.
The chances are permim will fail on the later perm groups in the list as
well. To save time we avoid looking at them until the next run through the
loop. */
        if (i<NREG && nreps>0){
        sprintf(command,"permim -f rep %sreg %s",permgps[i],gp1); 
        if (verbose) printf("%s\n",command);
          if (system(command)) exit_clear(2);
        sprintf(command,"permim -f rep %sreg %s",permgps[i],gp2); 
        if (verbose) printf("%s\n",command);
          if (system(command)) exit_clear(2);
          nregreps[i]=0;
          do {
        sprintf(filename,"%s.%sregrep%d",gp1,permgps[i],nregreps[i]+1);
            if ((rfile = fopen(filename,"r"))==0)
              break;
            else {
              nregreps[i]++;
              fclose(rfile);
            }
          } while (0!=1);
        }
      }
      if (nreps_checked[i]==TRUE && i<NREG  && ns_checked[i]==FALSE)
        ns_checked[i] 
        = normal_series_check(i,4*par,par);
      times(&buffer);
/* Make sure we do not spend more than twice as long on this as we did
  on the previous attempt to find an isomorphism
*/
      if (time_so_far-prevtime > 2*isomtime){
        if (verbose) printf("Time expired.\n"); break;
      }
    }
	permcheck_complete = TRUE;
	for (i=0;i<NPERMGPS;i++){
		if (nreps_checked[i]==FALSE){
			permcheck_complete = FALSE;
			break;
		}
	}
	if (permcheck_complete){
		for (i=0;i<NREG;i++){
			if (ns_checked[i]==FALSE)
				permcheck_complete = FALSE;
		}
	}
	if (permcheck_complete){
		printf("Search for evidence of lack of isomorphism using\n");
		printf("permutations images is inconclusive.\n");
	}
    par *=2;
    par2 *= 5;
  }
}

void
list_permgps()
{
  permgps[1] = "s4";
  permgps[2] = "a5"; permgps[3] = "s5"; permgps[4] = "l27";
  permgps[5] = "pgl27"; permgps[6] = "a6"; permgps[7] = "l28";
  permgps[8] = "l211"; permgps[9] = "l213"; permgps[10] = "l217";
  permgps[11] = "a7"; permgps[12] = "l219"; permgps[13] = "l216";
  permgps[14] = "l33"; permgps[15] = "u33"; permgps[16] = "l223";
  permgps[17] = "l225"; permgps[18] = "m11"; permgps[19] = "l227";
  permgps[20] = "l229"; permgps[21] = "l231"; permgps[22] = "a8";
  permgps[23] = "l34"; permgps[24] = "l237"; permgps[25] = "u42";
  permgps[26] = "sz8"; permgps[27] = "l232"; permgps[28] = "l241";
  permgps[29] = "l243"; permgps[30] = "l247"; permgps[31] = "l249";
  permgps[32] = "u34"; permgps[33] = "l253"; permgps[34] = "m12";
  permgps[35] = "u35"; permgps[36] = "j1"; permgps[37] = "a9";
}

/* returns TRUE if test should be run again with longer time */
boolean
trivrep_normal_series_check(time,vtime)
  int time,vtime;
{
  boolean ans=TRUE;
  boolean time_limit=FALSE;
  gptree * gt1;
  gptree * gt2;
  gt_diff gtdiff;
  gt1 = normal_series(gp1,"-t",time,vtime,&time_limit);
  if (time_limit)
    ans = FALSE;
  gt2 = normal_series(gp2,"-t",time,vtime,&time_limit);
  if (time_limit)
    ans = FALSE;
  if (gt_equiv(gt1,gt2,&gtdiff)==FALSE){
printf("Normal series for trivial reps of %s and %s don't match.\n",gp1,gp2);
    printf("%s and %s cannot be isomorphic.\n",gp1,gp2);
     gt_diff_message(&gtdiff,gp1,gp2,"-t",0,0);
    exit_clear(0);
  }
  gt_clear(gt1); Free_dp((dp)gt1); gt1 = 0;
  gt_clear(gt2); Free_dp((dp)gt2); gt2 = 0;
  return ans;
}

boolean
nreps_check(i,time,size,anreps)
  int i;
  int time,size,* anreps;
{
  int nreps1=0;
  int nreps2=0;
  char c;
  sprintf(command,
    "permim -T -t %d %s %s",time,permgps[i],gp1); 
  if (verbose) printf("%s\n",command);
  if ((exit_code=(system(command))/256)==1)
    return FALSE;
  else if (exit_code == 2) exit_clear(2);
  sprintf(command,
    "permim -T -t %d %s %s",time,permgps[i],gp2); 
  if (verbose) printf("%s\n",command);
  if ((exit_code=(system(command))/256)==1)
    return FALSE;
  else if (exit_code == 2) exit_clear(2);

  sprintf(filename,"%s.%spermim",gp1,permgps[i]);
  rfile = fopen(filename,"r");
  c=getc(rfile);
  while (isdigit(c)==0) c=getc(rfile);
  ungetc(c,rfile);
  fscanf(rfile,"%d",&nreps1);
  fclose(rfile);
    
  sprintf(filename,"%s.%spermim",gp2,permgps[i]);
  rfile = fopen(filename,"r");
  c=getc(rfile);
  while (isdigit(c)==0) c=getc(rfile);
  ungetc(c,rfile);
  fscanf(rfile,"%d",&nreps2);
  fclose(rfile);
    
  if (verbose) printf("Numreps %d %d\n",nreps1,nreps2);
  if (nreps1!=nreps2){
    printf("%s and %s have different numbers of maps onto\n",gp1,gp2);
    printf("%s, and so cannot be isomorphic.\n",permgps[i]);
    exit_clear(0);
  }

  if (nreps1>size){
    *anreps=0;
    return TRUE;
  }
        if (nreps1!=0 && (bestpgp==0 || nreps1<=nrepsofbestpgp)){
        sprintf(command,"permim %s %s",permgps[i],gp1);
        if (verbose) printf("%s\n",command);
        system(command);
        sprintf(command,"permim %s %s",permgps[i],gp2);
        if (verbose) printf("%s\n",command);
        system(command);
    if (bestpgp>0){
      if (keepfiles==FALSE){
        sprintf(command,"rm -f %s.%spermim",gp1,permgps[bestpgp]);
        system(command);
        sprintf(command,"rm -f %s.%spermim",gp2,permgps[bestpgp]);
        system(command);
      }
    }
    bestpgp=i; nrepsofbestpgp=nreps1;
    if (verbose) printf("bestpgp=%s\n",permgps[i]);
  }
  if (i!=bestpgp){
      if (keepfiles==FALSE){
        sprintf(command,"rm -f %s.%spermim",gp1,permgps[i]);
        system(command);
        sprintf(command,"rm -f %s.%spermim",gp2,permgps[i]);
        system(command);
      }
  }
  *anreps = nreps1;
  return TRUE;
}

boolean
normal_series_check(i,time,vtime)
  int i;
  int time,vtime;
{
  boolean ans=TRUE;
  boolean time_limit=FALSE;
  int k,j;
  gptree ** gt1;
  gptree ** gt2;
  gt_diff * gtdiff;
  if (nregreps[i]==0)
  return TRUE;
  gt1 = vzalloc2(gptree *,nregreps[i] + 1);
  gt2 = vzalloc2(gptree *,nregreps[i] + 1);
  gtdiff = vzalloc2(gt_diff,nregreps[i]+1);
  for (k=1;k<=nregreps[i];k++){
    sprintf(rep,"%sregrep%d",permgps[i],k);
    gt1[k] = normal_series(gp1,rep,time,vtime,&time_limit); 
    if (time_limit)
      ans = FALSE;
  }
  for (k=1;k<=nregreps[i];k++){
    sprintf(rep,"%sregrep%d",permgps[i],k);
    gt2[k] = normal_series(gp2,rep,time,vtime,&time_limit); 
    if (time_limit) 
      ans = FALSE;
  }
  for (k=1;k<=nregreps[i];k++){
    for (j=1;j<=nregreps[i];j++)
      if (gt_equiv(gt1[k],gt2[j],gtdiff+j)==TRUE)
        break;
    if (j>nregreps[i]){
      printf("No normal series match for rep %d of %s.\n",k,gp1);
      printf("%s and %s cannot be isomorphic.\n",gp1,gp2);
      for (j=1;j<=nregreps[i];j++)
        gt_diff_message(gtdiff+j,gp1,gp2,permgps[i],k,j);
      exit_clear(0);
    }
  }
  for (k=1;k<=nregreps[i];k++){
    for (j=1;j<=nregreps[i];j++)
      if (gt_equiv(gt2[k],gt1[j],gtdiff+j)==TRUE)
        break;
    if (j>nregreps[i]){
      printf("No normal series match for rep %d of %s.\n",k,gp2);
      printf("%s and %s cannot be isomorphic.\n",gp1,gp2);
      for (j=1;j<=nregreps[i];j++)
        gt_diff_message(gtdiff+j,gp1,gp2,permgps[i],j,k);
      exit_clear(0);
    }
  }
  for (k=1;k<=nregreps[i];k++){
    gt_clear(gt1[k]); Free_dp((dp)gt1[k]);gt1[k]=0;
    gt_clear(gt2[k]); Free_dp((dp)gt2[k]);gt2[k]=0;
  }
  Free_dp((dp)gt1); gt1 = 0;
  Free_dp((dp)gt2); gt2 = 0;
  Free_dp((dp)gtdiff); gtdiff = 0;
  if (ans==TRUE && keepfiles==FALSE){
    for (k=1;k<=nregreps[i];k++){
      sprintf(command,"rm -f %s.%sregrep%d",gp1,permgps[i],k); system(command);
      sprintf(command,"rm -f %s.%sregrep%d",gp2,permgps[i],k); system(command);
    }  
    sprintf(command,"rm -f %s.%sregpermim",gp1,permgps[i]); system(command);
    sprintf(command,"rm -f %s.%sregpermim",gp2,permgps[i]); system(command);
  }
  return ans;
}

gptree * 
normal_series(gp,rep,time,vtime,time_limitp)
  char * gp;
  char * rep;
  int time,vtime;
  boolean * time_limitp;
{
  gptree * nsp;
  gt_vertex *oldvtx,*lastnewvtx,*newvtx; 
  gt_edge *edge; 
  int k; 
  int p;
  int n;
  int M;
  boolean allprimes = FALSE;
  int r=0,s=0;
  int time0;
  int vtime0;
  boolean time_expired = FALSE;
  *time_limitp = FALSE;
  times(&buffer);
  time0 = time_so_far; 
  nsp = vzalloc1(gptree);
  gt_init(nsp);
  lastnewvtx = oldvtx = nsp->root; 
  
  
  while (r<=s) {
    if (time_expired)
      break;
    times(&buffer);
    if (time_expired = ((time_so_far - time0)>time))
      break;
    if (r==0){
      if (strcmp(rep,"-t")==0)
        strcpy(sfx1,"-t");
       else 
        sprintf(sfx1,"%s",rep);
    }
    else 
      sprintf(sfx1,"op%d",r);
    sprintf(command,"subabquot -c -t %d %s %s",vtime,gp,sfx1);
    if (verbose) printf("%s\n",command);
    if ((exit_code=(system(command))/256)==0){
      sprintf(filename,"%s.subabquot",gp);
      rfile = fopen(filename,"r");
	  while (read_next_string(label,8,rfile)){
		if (strcmp(label,"timeout ")==0){
			*time_limitp = TRUE;
			M=1; allprimes = TRUE;
      		if (verbose) printf("subabquot ran out of time.\n");
			break;
	  	}
		else if (strcmp(label,"abinvari")==0){
      		allprimes = FALSE;
      		M = 1;
      		oldvtx->subabquot = TRUE;
      		if (verbose) printf("abinvariants:- ");
      		while (getc(rfile)!='{')
       			 ;
      		while (read_next_int(&k,rfile)){
        		if (verbose) printf("%d ",k);
        		gt_ai_append(oldvtx,k);
        		if (k==0)
          			allprimes = TRUE;
        		else
          			M = k;
      		}
      		if (verbose) printf("\n");
			break;
		}
	  }
      fclose(rfile);
      if (keepfiles==FALSE){
        sprintf(command,"rm -f %s",filename); system(command);
      }
    }
    else{
      if (verbose) printf("subabquot couldn't complete\n");
      M = 1;
      allprimes = TRUE;
    }
    times(&buffer);
    vtime0 = time_so_far;
    if (verbose) fprintf(stdout,"r= %d,s= %d\n",r,s);
    if (verbose) printf("edges:- ");
    for (p=2;(allprimes)||p<=M;p++){
      times(&buffer);
      if (time_expired=((time_so_far - time0)>time)){
        *time_limitp = TRUE;
        break;
      }
      else if (time_so_far - vtime0 > vtime){
        *time_limitp = TRUE;
        break;
      }
      if ((is_prime(p)) && ((allprimes) || M%p ==0)){
        sprintf(sfx2,"op%d",s+1);
      sprintf(command,"foxreg -s -p %d %s %s %s",p,gp,sfx1,sfx2);
        if (system(command)) exit_clear(2);
        sprintf(filename,"%s.foxreg",gp);
        rfile = fopen(filename,"r");
        n=0;
        (void)find_keyword("elabinvariants",rfile);
        while (getc(rfile)!='{')
          ;
        while (read_next_int(&k,rfile))
          n++;
        fclose(rfile);
        if (keepfiles==FALSE){
          sprintf(command,"rm -f %s",filename); system(command);
        }
        edge = gt_edge_append(oldvtx,p,n); /* If the group index is too 
large no permutation rep will have been output. We need to know that, 
so that we stop looking along this branch. */
        if (verbose) printf("%d;%d  ",p,n);
        sprintf(filename,"%s.%s",gp,sfx2);
        if ((rfile=fopen(filename,"r"))==0){
      /* no file created by foxreg, because numbers were too big */
          if (n!=0 && M%p!=0) 
/* no point in trying any larger primes that
only divide the zero invariant factors, since they'll all give the same 
dimension module as this one */ 
            allprimes = FALSE;
        }  
        else {
          fclose(rfile);
          s++;
          newvtx = gt_vertex_create();
          gt_set_primeseq(newvtx,oldvtx,p);
          sprintf(command,"orders %s.%s",gp,sfx2); 
          if (verbose) printf("%s\n",command);
          if (system(command)) exit_clear(2);
          sprintf(filename,"%s.%s.orders",gp,sfx2);
          if (verbose) printf("orders:- ");
          rfile = fopen(filename,"r");
          (void)find_keyword("orders",rfile);
          while (getc(rfile)!='{');
          while (read_next_int(&k,rfile)){
            if (verbose) printf("%d ",k);
            gt_order_append(newvtx,k);
          }
          if (verbose) printf("\n");
          fclose(rfile);
          if (keepfiles==FALSE){
            sprintf(command,"rm -f %s\n",filename);
            system(command);
          }
          lastnewvtx->next = edge->target = newvtx;
          lastnewvtx = newvtx;
        }
      }
    }
    if (verbose) printf("\n");
    if (r>0){ 
      if (keepfiles==FALSE){
        sprintf(command,"rm -f %s.%s",gp,sfx1); if (system(command)) exit_clear(2); 
      }
    }
    r++;
    oldvtx = oldvtx->next;
  }
  if (time_expired)
    if (verbose) printf("Time expired.\n");
/* clear away any files that are still hanging around */
  for (k=1;k<=s;k++){
    sprintf(filename,"%s.op%d",gp,k);
    if (rfile = fopen(filename,"r")){
      fclose(rfile);
      if (keepfiles==FALSE){
        sprintf(command,"rm -f %s",filename); if (system(command)) exit_clear(2);  
      }
    }
  }
  return nsp;
}

boolean is_prime(i)
  int i;
{
  double root = sqrt((double)i);
  int j;
  for (j=2;j<=root;j++)
    if (i%j==0)
      return FALSE;
  return TRUE;
}

badusage()
{ fprintf(stderr,
	"Usage:  testisom [-v] [-k] [-i] [-n] [-p permgp+] group1 group2\n");
  exit_clear(2);
}

exit_clear(n)
  int n;
{ char command[100];
  if (keepfiles==FALSE){
    sprintf(command,"rm -f %s.ordrels",gp1); system(command);
    sprintf(command,"rm -f %s.ordrels.kbeqn",gp1); system(command);
    sprintf(command,"rm -f %s.abquot",gp1); system(command);
    sprintf(command,"rm -f %s.ordrels",gp2); system(command);
    sprintf(command,"rm -f %s.ordrels.kbeqn",gp2); system(command);
    sprintf(command,"rm -f %s.abquot",gp2); system(command);
  }
  exit(n);
}
