/* automata.d/src file reducewords.c */
#include <stdio.h>
#include "defs.h"
#include "list.h"
#include "word.h"
#include "reduce.h"
#include "input.h"
#include "afsa.h"
#include "reduce.h"

#define DIFF1OP ".diff1"
#define KBEQNOP ".kbeqn"
FILE * rfile=stdin;
FILE * keyboard=0;
FILE * wfile=stdout;
boolean fast_reduction = FALSE;
afsa * WA=0;
twoafsa * DIFF=0;
int *** rules;
word * rulewords[2];
int nrules;
extern word * user_gen_name;
extern gen * inv_of;
extern int gen_array_size;
extern int num_gens;

main(argc,argv)
	int argc;
	char * argv[];
{
	boolean first_fc = TRUE;
	char * label;
	char gpname[100];
	char filename[100];
	boolean interactive=FALSE;
	list words;
	word w;
	word w1;
	word w2;
	int i,j;
	
	i=1;
    while (i<argc && argv[i][0]=='-'){
		if (strcmp(argv[i],"-i")==0)
			interactive = TRUE;
		else if (strcmp(argv[i],"-f")==0)
			fast_reduction = TRUE;
		else {
			fprintf(stderr,"Usage: reducewords [-f] [-i] [gpname]\n");
			exit(2);
		}
		i++;
	}
	if (i<argc-1){
		fprintf(stderr,"Usage: reducewords [-f] [-i] [gpname]\n");
		exit(2);
	}
	else if (i==argc-1){
		strcpy(gpname,argv[argc -1]);
		strcpy(filename,gpname);
		if (fast_reduction)
			strcat(filename,KBEQNOP);
		else
			strcat(filename,DIFF1OP);
		if ((rfile=fopen(filename,"r"))==0)
  			{ fprintf(stderr,"Cannot open %s.\n",filename); exit(2);}
	}

	setbuf(stdout,(char*)0);
	setbuf(stderr,(char*)0);
	setbuf(wfile,(char*)0);
	label=vzalloc2(char,9);

	if (interactive){
		keyboard = fopen("/dev/tty","w");
	}
	else 
		list_init(&words,WORD,FIFO);
	while (read_next_string(label,8,rfile)||(interactive==FALSE&&rfile!=stdin)){
		if (strcmp(label,"Format  ")==0){
			if (first_fc){
				format_echocheck("2.2",rfile,wfile);
				first_fc = FALSE;
			}
			else
				format_check("2.2",rfile);
		}
		else if (strcmp(label,"fsa     ")==0){
			if ((fast_reduction) && (WA==0)){
				WA=afsa_read(&user_gen_name,rfile); 
				if (WA->eos){ 
					afsa * WAcopy; 
					WAcopy=WA;
					WA=0;
					WA=afsa_eosdelete(WAcopy);
					afsa_clear(WAcopy);
					Free_dp((dp)WAcopy); WAcopy=0;
				}
				nrules = afsa_num_negstates(WA);
				rulewords[0]=vzalloc2(word,nrules+1);
	  			rulewords[1]=vzalloc2(word,nrules+1);
				num_gens = WA->base_symbols;
			}
			else if (DIFF==0){
				DIFF=twoafsa_read(&user_gen_name,rfile);
				num_gens = DIFF->base_symbols -1;
			}
		}
		else if (strcmp(label,"rels    ")==0 && (fast_reduction)){
			while (getc(rfile)!='\{')
				;
			word_init(&w);
			for (j=1;j<=nrules;j++){
				for (i=0;i<=1;i++){
					word_init((rulewords[i])+j);
					(void)read_next_word(&w,rfile);
					word2prog_word(&w,(rulewords[i])+j);
					word_reset(&w);
				}
			}
			word_clear(&w);
			while (getc(rfile)!='\}')
				;
			rules = reduction_rules(rulewords,nrules);
		}			
		else if (strcmp(label,"inverses")==0 && (inv_of==0))	
			read_inverse_array(rfile);
		else if (interactive==FALSE &&
				rfile==stdin && strcmp(label,"words   ")==0){
			while (getc(rfile)!='\{')
				;
			if (inv_of==0)
				default_inverse_array();
			word_init(&w1);
			word_init(&w2);
			while (read_next_word(&w1,rfile)){
				word2prog_word(&w1,&w2);
				list_insert(&words,&w2);
				word_reset(&w1);
				word_reset(&w2);
			}
			while (getc(rfile)!='\}')
				;
			break;
		}
		else if (interactive==FALSE && rfile!=stdin){
			rfile=stdin;
		}
	}
	if (WA==0 && DIFF==0) /* one of these should have been set, depending on
whether fast reduction is in use or not */
		bad_data();
	if (interactive){
		rfile = fopen("/dev/tty","r");
		fprintf(keyboard,"In interactive mode. Input words to be reduced, one at\n");
		fprintf(wfile,"a time, terminating the list with a closing \}.\n");
		fprintf(wfile,"words \{\n");
		if (inv_of==0)
			default_inverse_array();
		word_init(&w1);
		word_init(&w2);
		while (read_next_word(&w1,rfile)){
			word2prog_word(&w1,&w2);
			fprintf(keyboard," reduces to ");
			if (fast_reduction)
				wa_reduction(WA,rules,&w2);
			else
				diff_reduction(DIFF,&w2);
			word_print(keyboard,&w2);
			fprintf(keyboard,"\n");
			word_reset(&w1);
			word_reset(&w2);
		}
		while (getc(rfile)!='\}')
			;
	}
	else {
		fprintf(wfile,"words \{\n");
		while (list_delget_first(&words,&w1)){
			if (fast_reduction)
				wa_reduction(WA,rules,&w1);
			else
				diff_reduction(DIFF,&w1);
			word_print(wfile,&w1);
			fprintf(wfile,"\n");
			word_reset(&w1);
		}	
		fprintf(wfile,"\}\n");
		list_clear(&words);
	}
	word_clear(&w1);
	word_clear(&w2);

	if (fast_reduction){
		afsa_clear(WA);
		Free_dp((dp)WA); WA=0;
		for (i=0;i<=1;i++){
			for (j=1;j<=nrules;j++)
				word_clear((rulewords[i])+j);
			Free_dp((dp)rulewords[i]);
			rulewords[i]=0;
		}
		clear_reduction_rules(rules);
		Free_dp((dp)rules); rules=0;
	}
	else {
		twoafsa_clear(DIFF);
		Free_dp((dp)DIFF); DIFF=0;
	}
	for (i=0;i<gen_array_size;i++)
		word_clear(user_gen_name+i);
	Free_dp((dp)user_gen_name); user_gen_name=0;
	Free_dp((dp)inv_of); inv_of=0;
	Free_dp((dp)label); label=0;
	assert(store_ptrs==0);
	exit(0);
}


