


medit(1)            Geometry Center Programs             medit(1)



NAME
     medit - Define lighting and surface properties of a scene

SYNOPSIS
     medit

DESCRIPTION
     Medit is a general-purpose material and lighting editor.  It
     is primarily used by MinneView (an interactive visualization
     program) to define the lighting and surface  characteristics
     of a scene.

     Lights can be added and removed from the scene, and the user
     can   set  each  light's  _p_o_s_i_t_i_o_n,  _c_o_l_o_r,  and  _i_n_t_e_n_s_i_t_y.
     Material surface properties effecting  illumination  can  be
     edited with medit.  They are: _c_o_l_o_r, _s_h_i_n_i_n_e_s_s, and the _d_i_f_-
     _f_u_s_e, and _s_p_e_c_u_l_a_r coefficients of reflection.

     The  settings  are  saved  to  the  files   .medit.lgt   and
     .medit.mat  in  the user's home directory, where they can be
     accessed by other programs.

USING MEDIT
  RUNNING
     Medit takes no command line arguments. To run it, just  type
     medit  from the normal _I_r_i_s shell and drag out the window on
     the screen with the left mouse button.

  THE DISPLAY
     In the window are five slider bars, a subwindow containing a
     shaded  rendering  of  a  sphere, and two smaller subwindows
     below  it  showing  the  colors  of  the  material  and  the
     currently  selected light.  The left subwindow is divided in
     half.  The bottom half shows the current material color. The
     top half shows the current highlight color.  The view of the
     sphere shows what a surface looks like  when  rendered  with
     the current settings.

     Each slider bar controls one numeric value and  should  have
     an  abbreviated  label  and  numeric value under it.  If the
     window is too small for them to fit, the labels will not  be
     printed.  Just enlarge the window to make them appear.

     Parameter values are changed with the slider bars.   To  set
     the  value  of a slider, move the mouse pointer onto the bar
     and press the left button.  This ``grabs'' the bar,  and  it
     will  now  slide  up and down with the movement of the mouse
     while you continue to hold down the mouse button..

  MATERIAL SURFACE CONSTANTS
     The three left-most slider  bars  control  how  the  surface
     reflects  light.   The first two sliders are coefficients of



             Last change: $Date: 90/05/25 10:11:01 $            1






medit(1)            Geometry Center Programs             medit(1)



     reflection.  They range in value from zero to one, and  each
     controls  how  much  of  a  particular kind of reflection is
     taken into account when an object's surface is shaded.  When
     a  coefficient  is  zero, none of its light is considered in
     the shading formula.  When it is one, all of  its  light  is
     considered. The coefficients are (from left to right):

     _D_i_f_f_u_s_e
          Diffuse reflection  is  the  non-shiny  part  of  light
          reflection  off  of  a  surface.  It gets brighter as a
          surface more fully  faces  the  light,  and  it  always
          reflects  the color of the surface.  The coefficient of
          diffuse  reflection  controls  the  brightness  of  the
          surface's color, but not how shiny it appears.

     _S_p_e_c_u_l_a_r
          The coefficient of  specular  reflection  controls  the
          appearances  of  shiny  highlights on the surface.  The
          higher the coefficient, the  brighter  the  highlights.
          The  color of the highlights can be set to be different
          from the color of the diffuse reflection.

     _S_h_i_n_i_n_e_s_s
          While  the coefficient of _s_p_e_c_u_l_a_r reflection  controls
          the  brightness of the highlights, the _s_h_i_n_i_n_e_s_s slider
          bar controls the size of the highlights.  The lower the
          shininess value, the broader the highlights will be.

     Setting the color of the  material  and  its  highlights  is
     explained in another section.

  LIGHTING PARAMETERS
     The lighting parameters can be  adjusted  independently  for
     each  light  in  the  scene.   All  of the lighting controls
     operate on the current light.  To make a light  the  current
     light,  click with the left mouse button on its highlight on
     the sphere.

     A light is moved by dragging its highlight  on  the  sphere.
     The  light  source  moves  so that the highlight follows the
     position of the mouse cursor.

     The intensity of the current  light  is  controlled  by  the
     right-most slider bar.

     Lights are added and deleted through  the  use  of  a  menu.
     Holding  the  right mouse button down anywhere in the window
     brings up a menu  with  the  choices  _c_r_e_a_t_e  _l_i_g_h_t,  _d_e_l_e_t_e
     _l_i_g_h_t, and _q_u_i_t.  The menu selections do the obvious things.

  SELECTING COLORS
     Three different colors  can  be  set:  The  material  color,



             Last change: $Date: 90/05/25 10:11:01 $            2






medit(1)            Geometry Center Programs             medit(1)



     specular highlight color and light color.  Each color is set
     by first creating the desired color in  another  window  and
     then indicating that color to medit.

     The easiest way to bring up the  correct  color  in  another
     window is with the program cedit.  It allows you to interac-
     tively mix red, green,  and  blue  to  specify  the  desired
     color.

     Once the proper color is displayed in  another  window,  the
     color  is  indicated  to  medit  by  pressing a mouse button
     (which button depends on what color you want to change)  and
     dragging  the cursor outside of the medit window until it is
     over the target color and releasing the mouse  button.   The
     color will be set to whatever color the cursor was over when
     the mouse button is released.

     Which color is set (light, material or highlight) depends on
     the  combination  of  keys  and mouse buttons held down when
     dragging to the target color:

     _M_a_t_e_r_i_a_l _C_o_l_o_r
          Left mouse button

     _C_u_r_r_e_n_t _L_i_g_h_t _C_o_l_o_r
          Middle mouse button

     _S_p_e_c_u_l_a_r _H_i_g_h_l_i_g_h_t _C_o_l_o_r
          Alt key and left mouse button

  SAVING PARAMETERS
     Every time the mouse leaves the medit  window,  the  current
     parameters  are  written  out  to  the  files .medit.mat and
     .medit.lgt in the user's home directory.  Programs that  are
     designed  to  work in conjunction with medit will often read
     these files whenever the mouse enters their  window.   Thus,
     the parameters are set with medit, and as the mouse is moved
     out of the medit window they are written to the  files.   As
     the  mouse continues and moves into the other program's win-
     dow, the parameters are read in.   (This  is  how  MinneView
     works.)

BUGS
     The shininess control reaches zero before the slider bar  is
     put  in  the  lowest position.  When it goes below zero, all
     highlights are turned off.

     Deleting the only light in a scene  makes  medit  abort  and
     dump core.

     The slider bars will follow  the  mouse  whenever  the  left
     mouse button is pushed and the mouse is inside the bar area.



             Last change: $Date: 90/05/25 10:11:01 $            3






medit(1)            Geometry Center Programs             medit(1)



     The occurs even if the mouse button was pushed down  outside
     of the slider bar area and then moved onto the bar.  This is
     a bug because if you are dragging with the left mouse button
     held  down and accidentally cross over a slider bar, the bar
     will snap to the position of the mouse.

AUTHORS
     Medit was written by Pat Hanrahan.

     This manual page was written by Mark Meuer

SEE ALSO
     The program MinneView for dynamically  visualizing  geometry
     with characteristics defined by medit.









































             Last change: $Date: 90/05/25 10:11:01 $            4



