/*
 * Copyright (c) 1992, The Geometry Center
 *                     University of Minnesota 
 *                     1300 South Second Street
 *                     Minneapolis, MN  55454
 *
 * email address: software@geom.umn.edu
 *
 * This software is copyrighted as noted above.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the authors, who may or may not act on them as they desire.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 *     The National Science and Technology Research Center for
 *      Computation and Visualization of Geometric Structures
 */

/* Generated by Interface Builder */

#import "LabelField.h"
#import <appkit/TextField.h>
#import <appkit/Text.h>

@implementation LabelField

- init
{
  [super init];
  textField = [[TextField allocFromZone:[self zone]] initFrame:NULL];
  [textField setBackgroundTransparent:YES];
  [textField setBezeled:NO];
  [textField setBordered:NO];
  [textField setAlignment:NX_CENTERED];
  xoffset = yoffset = 0;
  return self;
}

- stopCursor
{
  [textField setSelectable:NO];
  return self;
}

- resetState
{
  [textField setEditable:YES];
  return self;
}

- write:(NXTypedStream *) tstream
{
  [super write:tstream];
  NXWriteObject(tstream, textField);
  NXWriteTypes(tstream, "ii", &xoffset, &yoffset);
  return self;
}

- read:(NXTypedStream *) tstream
{
  [super read:tstream];
  textField = NXReadObject(tstream);
  NXReadTypes(tstream, "ii", &xoffset, &yoffset);
  return self;
}

@end
