/*
 * Copyright (c) 1992, The Geometry Center
 *                     University of Minnesota 
 *                     1300 South Second Street
 *                     Minneapolis, MN  55454
 *
 * email address: software@geom.umn.edu
 *
 * This software is copyrighted as noted above.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the authors, who may or may not act on them as they desire.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 *     The National Science and Technology Research Center for
 *      Computation and Visualization of Geometric Structures
 */


/* Generated by Interface Builder */

#import "HelpObj.h"
#import <appkit/TextField.h>
#import <appkit/Text.h>
#import <appkit/ScrollView.h>
#import <appkit/Application.h>
#include <streams/streams.h>
#import <appkit/Matrix.h>
#import <appkit/defaults.h>  // for NXArgv
#import <libc.h>// for chdir, getwd
#include <string.h>
#import <appkit/Button.h>

void getAppDirectory (char *appDirectory)
{
  FILE *process;
  char command[256];
  char *suffix;
  
  strcpy (appDirectory,NXArgv[0]);
  if (appDirectory[0] == '/') { /* if absolute path */
    if (suffix = rindex(appDirectory,'/'))
      *suffix  = '\0'; /* remove executable name */
  } else {
    sprintf(command,"which '%s'\n",NXArgv[0]);
    process=popen(command,"r");
    fscanf(process,"%s",appDirectory);
    pclose(process);
    if (suffix = rindex(appDirectory,'/'))
      *suffix  = '\0'; /* remove executable name */
    chdir(appDirectory);
    getwd(appDirectory);
  }
}


@implementation HelpObj

- showNotationHelp
{
  [self showPanel:self];
  [notationButton performClick:self];
  return self;
}

- showPanel:sender
{
  if (helpPanel == NULL)
    [NXApp loadNibSection:"Help.nib" owner:self withNames:NO fromZone:[self zone]];
  [helpPanel makeKeyAndOrderFront:self];
  return self;
}

- showHelp:sender
{
  char filename[256];
  NXStream *file;
  
  getAppDirectory(filename);        /* Find where application lives */
  [[helpScroll docView] setEditable:NO];
  switch([sender selectedRow])      /* Take cases on which button was hit */
    {
    case 0:
      [helpTitle setStringValue:"General"];
      strcat(filename, "/LinktoolHelp/General.rtf");
      break; 
    case 1:
      [helpTitle setStringValue:"Helpful hints"];
      strcat(filename, "/LinktoolHelp/Helpful_hints.rtf");
      break;
    case 2:
      [helpTitle setStringValue:"Editing a link"];
      strcat(filename, "/LinktoolHelp/Editing_a_link.rtf");
      break;
    case 3:
      [helpTitle setStringValue:"Displaying a link"];
      strcat(filename, "/LinktoolHelp/Displaying_a_link.rtf");
      break;
    case 4:
      [helpTitle setStringValue:"Notation"];
      strcat(filename, "/LinktoolHelp/Notation.rtf");
      break;
    case 5:
      [helpTitle setStringValue:"Formatting"];
      strcat(filename, "/LinktoolHelp/Formatting.rtf");
      break;
    case 6:
      [helpTitle setStringValue:"Files"];
      strcat(filename, "/LinktoolHelp/Files.rtf");
      break;
    case 7:
      [helpTitle setStringValue:"Matrix file format"];
      strcat(filename, "/LinktoolHelp/Matrix_file_format.rtf");
      break;
    case 8:
      [helpTitle setStringValue:"Evolution"];
      strcat(filename, "/LinktoolHelp/Evolution.rtf");
      break;
    case 9:
      [helpTitle setStringValue:"Changes since 1.0"];
      strcat(filename, "/LinktoolHelp/Changes_since_1_0.rtf");
      break;
    case 10:
      [helpTitle setStringValue:"Copyright"];
      strcat(filename, "/LinktoolHelp/Copyright.rtf");
      break;
    case 11:
      [helpTitle setStringValue:"Guide to source code"];
      strcat(filename,"/LinktoolHelp/Guide_to_source_code.rtf");
      break;
    }
  
  /* Read in help file */
  file = NXMapFile(filename, NX_READONLY);
  if (file == NULL)
    {
      [helpTitle setStringValue:"Help file not found"];
      [[helpScroll docView] setText:"In the same directory as Linktool, there should be another directory, LinktoolHelp, under which all help files should be located."];
      return self;
    }
  [[helpScroll docView] readRichText:file];
  NXCloseMemory(file, NX_FREEBUFFER);
  return self;
}


@end
