/*****************************************************************/
/*                                                               */
/*          Copyright (c) 1991-1992 by J.Nisimoto                */
/*                                                               */
/*                   H  c  a  d  3  D  - Ver 2.0                 */
/*                                                               */
/*  Permission to use,copy,modify,and distribute this software.  */
/*                                                               */
/*  data_menu.c: Functions for data menu window.                 */
/*                                                               */
/*                                                               */
/*****************************************************************/

#include <stdio.h>   
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <math.h>
#include "source/Hcad.h"
#include <ctype.h>
#include <string.h>

#include "source/Hcadext.h"

int button_x[3],button_y[3];
int editing_plane;
double in_point[3][3];
int key_in,side_flg;


/*------------------------------------------------------------

  Function : data_menu(int)

-------------------------------------------------------------*/
data_menu(invert_num)
int invert_num;
{

	int looping,i,cnt,p_num,j;
	char text_buffer[3][60], s[5];
	int text_width;
	XSetWindowAttributes  atr;

	total_plane = 0;
	while(plane[total_plane].r != 0.0){
		total_plane++;
	}
	sub_menuhint.x = 270;
	sub_menuhint.y = 35 + 20*invert_num;
	sub_menuhint.width = 0;
	sub_menuhint.height = 0;
	sub_menuhint.flags = PPosition | PSize;

	/*  File menu */
	switch(invert_num){
	case 0:
		/* show data menu */
		sub_menuhint.width = 300;
		sub_menuhint.height =140;
		break;
	case 1:
		/* add data menu */
		sub_menuhint.width = 300;
		sub_menuhint.height =280;
		break;
	case 2:
		/* change data menu */
		sub_menuhint.width = 300;
		sub_menuhint.height =280;
		break;
	case 3:
		/* remove data menu */
		sub_menuhint.width = 300;
		sub_menuhint.height =140;
		break;
	case 4:
		/* clear data menu */
		init_plane();
		clear_task();
		XWarpPointer(disp,None,basewin,0,0,0,0,300,20);
		show_object(0);
		return;
		break;
	case 5:
		/* data style menu */
		sub_menuhint.width = 300;
		sub_menuhint.height =140;
		break;
	default:
		return;
		break;
	}

	button_x[0] = 10;
	button_x[1] = 110;
	button_x[2] = 210;
	button_y[0] = sub_menuhint.height - 40;
	button_y[1] = sub_menuhint.height - 40;
	button_y[2] = sub_menuhint.height - 40;


	sub_menuwin = XCreateSimpleWindow(disp,basewin,sub_menuhint.x,sub_menuhint.y,
	sub_menuhint.width,sub_menuhint.height,
	2,black,white);
	sub_menugc = XCreateGC(disp,sub_menuwin,0,0);
	XSetBackground(disp,sub_menugc,white);
	XSetForeground(disp,sub_menugc,black); 
	XSetFunction(disp,sub_menugc,GXcopy);
        if(font_flg == TRUE){
          XSetFont(disp,sub_menugc,font);
        }
	atr.save_under = True;
	XChangeWindowAttributes(disp,sub_menuwin,CWSaveUnder,&atr);
	XMapRaised(disp,sub_menuwin);
	looping = 0;
	show_data_menu(invert_num,0);
	editing_plane = 0;
	XWarpPointer(disp,None,sub_menuwin,0,0,0,0,50,80);
	cnt = 0;
	text_buffer[0][0] = '\0';
	text_buffer[1][0] = '\0';
	text_buffer[2][0] = '\0';
	p_num = 0;
	for(i=0;i<3;i++){
		for(j=0;j<3;j++){
			in_point[i][j]=0.0;
		}
	}
	side_flg = OUTSIDE;
	key_in = TRUE;
	while(looping == 0){
		if(XEventsQueued(disp,QueuedAfterReading)==0){
			XFlush(disp);
		}
		XNextEvent(disp,&ev);

		switch(ev.type){
		case MotionNotify:
			if(ev.xmotion.subwindow != sub_menuwin){
				looping = 1;
			}
			break; 
		case ButtonPress:
			data_button_check(invert_num);
			break;

		case KeyPress:
			if((invert_num == 1)||(invert_num == 2)){
				i=XLookupString(&ev,s,20,&mykey,0);
				if(i == 1){
					switch(s[0]){
					case '\b':
						if(cnt>0){
							cnt--;
							text_buffer[p_num][cnt] = '\0';
							draw_inv_str(sub_menuwin,sub_menugc,ON,75,125+20*p_num,220,20,
							80,140+20*p_num,text_buffer[p_num]);
						}
						break;
					case 13:
						if(check_form(text_buffer[p_num],p_num)==TRUE){
							draw_inv_str(sub_menuwin,sub_menugc,OFF,75,125+20*p_num,220,20,
							80,140+20*p_num,text_buffer[p_num]);
							p_num++;
							if(p_num == indata_style){
								p_num = 0;
								key_in = FALSE;
							}
							cnt = strlen(text_buffer[p_num]);
							draw_inv_str(sub_menuwin,sub_menugc,ON,75,125+20*p_num,220,20,
							80,140+20*p_num,text_buffer[p_num]);
						}
						else{
							text_buffer[p_num][0] = '\0';
							cnt = 0;
							draw_inv_str(sub_menuwin,sub_menugc,ON,75,125+20*p_num,220,20,
							80,140+20*p_num,text_buffer[p_num]);
						}
						break;

					default:
						if (isprint(s[0]) != 0){
							if(cnt<50){
								text_buffer[p_num][cnt] = s[0];
								text_buffer[p_num][cnt+1] = '\0';
								if(cnt==0){
									text_buffer[p_num][1] = '\0';
								}    
								draw_inv_str(sub_menuwin,sub_menugc,ON,75,125+20*p_num,220,20,
								80,140+20*p_num,text_buffer[p_num]);
								cnt++;
							}
						}
					}
				}
			}
		default:
			break;
		}
	}
	XFreeGC(disp,sub_menugc);
	XDestroyWindow(disp,sub_menuwin);
	XMapRaised(disp,drawin);
}   

/*------------------------------------------------------------

  Function : show_data_menu(int,int)

-------------------------------------------------------------*/
show_data_menu(invert_num,pid)
int invert_num;
int pid;
{
	int i;

	XClearWindow(disp,sub_menuwin);
	XDrawRectangle(disp,sub_menuwin,sub_menugc,2,2,sub_menuhint.width - 4,
	sub_menuhint.height - 4);
	XDrawRectangle(disp,sub_menuwin,sub_menugc,4,4,sub_menuhint.width - 8,
	sub_menuhint.height - 8);
	XDrawLine(disp,sub_menuwin,sub_menugc,4,90,292,90);

	switch(invert_num){
	case 0:
		show_edit_data(pid);
		XDrawImageString(disp,sub_menuwin,sub_menugc,60,20,
		"<< SHOW PLANE DATA >>",strlen("<< SHOW PLANE DATA >>"));
		draw_button(sub_menuwin,sub_menugc,button_x[0],button_y[0],80,25,
		button_x[0]+10,button_y[0]+20,"NEXT");
		draw_button(sub_menuwin,sub_menugc,button_x[1],button_y[1],80,25,
		button_x[1]+10,button_y[1]+20,"PRE");
		draw_button(sub_menuwin,sub_menugc,button_x[2],button_y[2],80,25,
		button_x[2]+10,button_y[2]+20,"Quit");
		break;

	case 1:
		show_edit_data(pid);
		show_input_data();
		XDrawImageString(disp,sub_menuwin,sub_menugc,60,20,
		"<< ADD PLANE DATA >>",strlen("<< ADD PLANE DATA >>"));
		draw_button(sub_menuwin,sub_menugc,button_x[0],button_y[0],80,25,
		button_x[0]+10,button_y[0]+20,"NEXT");
		draw_button(sub_menuwin,sub_menugc,button_x[1],button_y[1],80,25,
		button_x[1]+10,button_y[1]+20,"PRE");
		draw_button(sub_menuwin,sub_menugc,button_x[2],button_y[2],80,25,
		button_x[2]+10,button_y[2]+20,"ADD");
		break;
	case 2:
		show_edit_data(pid);
		show_input_data();
		XDrawImageString(disp,sub_menuwin,sub_menugc,60,20,"<< CHANGE PLANE DATA >>",
		strlen("<< CHANGE PLANE DATA >>"));
		draw_button(sub_menuwin,sub_menugc,button_x[0],button_y[0],80,25,
		button_x[0]+10,button_y[0]+20,"NEXT");
		draw_button(sub_menuwin,sub_menugc,button_x[1],button_y[1],80,25,
		button_x[1]+10,button_y[1]+20,"PRE");
		draw_button(sub_menuwin,sub_menugc,button_x[2],button_y[2],80,25,
		button_x[2]+10,button_y[2]+20,"CHANGE");
		break;
	case 3:
		show_edit_data(pid);
		XDrawImageString(disp,sub_menuwin,sub_menugc,50,20,"<< REMOVE PLANE DATA >>",
		strlen("<< REMOVE PLANE DATA >>"));
		draw_button(sub_menuwin,sub_menugc,button_x[0],button_y[0],80,25,
		button_x[0]+10,button_y[0]+20,"NEXT");
		draw_button(sub_menuwin,sub_menugc,button_x[1],button_y[1],80,25,
		button_x[1]+10,button_y[1]+20,"PRE");
		draw_button(sub_menuwin,sub_menugc,button_x[2],button_y[2],80,25,
		button_x[2]+10,button_y[2]+20,"REMOVE");
		break;
	case 5:
		XDrawImageString(disp,sub_menuwin,sub_menugc,30,20,"<< DATA STYLE >>",
		strlen("<< DATA STYLE >>"));
		XDrawImageString(disp,sub_menuwin,sub_menugc,10,40,
		"1:Enter plane center",strlen("1:Enter plane center"));
		XDrawImageString(disp,sub_menuwin,sub_menugc,10,60,"2:Enter 2 points of plane's normal",
		strlen("2:Enter 2 points of plane's normal"));
		XDrawImageString(disp,sub_menuwin,sub_menugc,10,80,
		"3:Enter 3 points of plane",strlen("3:Enter 3 points of plane"));
		draw_button(sub_menuwin,sub_menugc,button_x[0],button_y[0],80,25,
		button_x[0]+35,button_y[0]+20,"1");
		draw_button(sub_menuwin,sub_menugc,button_x[1],button_y[1],80,25,
		button_x[1]+35,button_y[1]+20,"2");
		draw_button(sub_menuwin,sub_menugc,button_x[2],button_y[2],80,25,
		button_x[2]+35,button_y[2]+20,"3");
		switch(indata_style){
		case 1:
			draw_inv_str(sub_menuwin,sub_menugc,ON,button_x[0]+2,button_y[0]+2,77,22,
			button_x[0]+35,button_y[0]+20,"1");
			break;
		case 2:
			draw_inv_str(sub_menuwin,sub_menugc,ON,button_x[1]+2,button_y[1]+2,77,22,
			button_x[1]+35,button_y[1]+20,"2");

			break;
		case 3:
			draw_inv_str(sub_menuwin,sub_menugc,ON,button_x[2]+2,button_y[2]+2,77,22,
			button_x[2]+35,button_y[2]+20,"3");

			break;
		}
		break;
	default:
		break;
	}
}

/*------------------------------------------------------------

  Function : show_edit_data(int)

-------------------------------------------------------------*/
show_edit_data(pid)
int pid;
{
	char s[60];

	sprintf(s,"[Total Plane] = %d  [Plane ID] = %d",total_plane,plane[pid].id);
	XDrawImageString(disp,sub_menuwin,sub_menugc,10,40,s,strlen(s));
	sprintf(s,"(x,y,z) = (%f,%f,%f)",plane[pid].x,plane[pid].y,plane[pid].z);
	XDrawImageString(disp,sub_menuwin,sub_menugc,10,60,s,strlen(s));
	sprintf(s,"[radius] = %f",plane[pid].r);
	XDrawImageString(disp,sub_menuwin,sub_menugc,10,80,s,strlen(s));
	if(plane[pid].side == OUTSIDE){
		XDrawImageString(disp,sub_menuwin,sub_menugc,190,80,"OUTSIDE",strlen("OUTSIDE"));
	}
	else{
		XDrawImageString(disp,sub_menuwin,sub_menugc,190,80,"INSIDE",strlen("INSIDE"));
	}
}  

/*------------------------------------------------------------

  Function : show_input_data()

-------------------------------------------------------------*/
show_input_data(){
	char s[60];
	int i;

	sprintf(s,"Enter  %d  Points",indata_style);
	XDrawImageString(disp,sub_menuwin,sub_menugc,10,110,s,strlen(s));
	for(i=1;i<indata_style+1;i++){
		sprintf(s,"%d (x,y,z)= ",i);
		XDrawImageString(disp,sub_menuwin,sub_menugc,10,120+20*i,s,strlen(s));
	}
	draw_inv_str(sub_menuwin,sub_menugc,ON,75,125,218,20,
	13,65," ");
	XDrawImageString(disp,sub_menuwin,sub_menugc,10,210,"Select side",strlen("Select side"));
	draw_button(sub_menuwin,sub_menugc,113,193,84,24,
	120,210,"OUTSIDE");
	draw_button(sub_menuwin,sub_menugc,208,193,84,24,
	215,210,"INSIDE");
	side_flg = OUTSIDE;
	draw_inv_str(sub_menuwin,sub_menugc,ON,115,195,81,21,
	120,210,"OUTSIDE");
}


int check_form(t_buf,num)
char t_buf[];
int num;
{
	float x,y,z;
	char x_buf[20];
	int ret;

	ret = sscanf(t_buf,"(%f,%f,%f)",&x,&y,&z);
	if(ret == 3){
		in_point[num][0] = (double)x;
		in_point[num][1] = (double)y;
		in_point[num][2] = (double)z;
		return(TRUE);
	}
	else{
		return(FALSE);
	}

}


data_button_check(invert_num)
int invert_num;
{
	if((ev.xbutton.y > button_y[0]+sub_menuhint.y)&&
	    (ev.xbutton.y < button_y[0] + 25 + sub_menuhint.y)){
		if((ev.xbutton.x > 10+sub_menuhint.x)&&(ev.xbutton.x < 90+sub_menuhint.x)){
			left_button_act(invert_num);
		}
		if((ev.xbutton.x >110+sub_menuhint.x)&&(ev.xbutton.x <190+sub_menuhint.x)){
			center_button_act(invert_num);
		}
		if((ev.xbutton.x >210+sub_menuhint.x)&&(ev.xbutton.x <290+sub_menuhint.x)){
			right_button_act(invert_num);
		}
	}
	if((invert_num ==1)||(invert_num ==2)){
		if((ev.xbutton.y>195 + sub_menuhint.y)&&(ev.xbutton.y<215+sub_menuhint.y)){
			if((ev.xbutton.x>115+sub_menuhint.x)&&(ev.xbutton.x<195+sub_menuhint.x)&&(side_flg==INSIDE)){
				side_flg = OUTSIDE;
				draw_inv_str(sub_menuwin,sub_menugc,OFF,210,195,81,21,
				215,210,"INSIDE");
				draw_inv_str(sub_menuwin,sub_menugc,ON,115,195,81,21,
				120,210,"OUTSIDE");
			}
			if((ev.xbutton.x>210+sub_menuhint.x)&&(ev.xbutton.x<290+sub_menuhint.x)&&(side_flg==OUTSIDE)){
				side_flg = INSIDE;
				draw_inv_str(sub_menuwin,sub_menugc,OFF,115,195,81,21,
				120,210,"OUTSIDE");
				draw_inv_str(sub_menuwin,sub_menugc,ON,210,195,81,21,
				215,210,"INSIDE");
			}
		}
	}
}


left_button_act(invert_num)
int invert_num;
{
	switch(invert_num){
		/*     NEXT BUTTON */
	case 0:
	case 1:
	case 2:
	case 3:
		if(editing_plane < total_plane-1){
			editing_plane++;
			show_data_menu(invert_num,editing_plane);
		}
		break;
	case 5:
		indata_style = 1;
		show_data_menu(invert_num,editing_plane);
		break;
	default:
		break;
	}
}

center_button_act(invert_num)
int invert_num;
{
	switch(invert_num){
	case 0:
	case 1:
	case 2:
	case 3:
		if(editing_plane > 0){
			editing_plane--;
			show_data_menu(invert_num,editing_plane);
		}
		break;
	case 5:
		indata_style = 2;
		show_data_menu(invert_num,editing_plane);
		break;
	default:
		break;
	}
}


right_button_act(invert_num)
int invert_num;
{
	int i;
	double r,f,g,h,k,a,b,c;
	double p,q;

	switch(invert_num){
	case 0:
		XWarpPointer(disp,None,basewin,0,0,0,0,200,400);
		break;      
	case 1:
		if(key_in == FALSE){
			if(make_center(&plane[total_plane])==TRUE){
				editing_plane = total_plane;
				total_plane++;
				show_data_menu(invert_num,editing_plane);
				XClearWindow(disp,drawin);
				search_cross();
				show_object(0);
			}
			else{
				show_input_data();
			}
		}
		break;
	case 2:
		if(key_in == FALSE){
			if(make_center(&plane[editing_plane])==TRUE){
				show_data_menu(invert_num,editing_plane);
				XClearWindow(disp,drawin);
				search_cross();
				show_object(0);
			}
			else{
				show_input_data();
			}
		}
		break;
	case 3:
		for(i=editing_plane;i<total_plane-1;i++){
			plane[i].x = plane[i+1].x;
			plane[i].y = plane[i+1].y;
			plane[i].z = plane[i+1].z;
			plane[i].r = plane[i+1].r;
			plane[i].side = plane[i+1].side;
		}
		plane[total_plane-1].x = 0.0;
		plane[total_plane-1].y = 0.0;
		plane[total_plane-1].z = 0.0;
		plane[total_plane-1].r = 0.0;
		plane[total_plane-1].side = OUTSIDE;
		total_plane--;
		XClearWindow(disp,drawin);
		search_cross();
		show_object(0);
		break;
	case 5:
		indata_style = 3;
		show_data_menu(invert_num,editing_plane);
		break;
	default:
		break;
	}
}

int make_center(pln)
HPlane *pln;
{
	double r;
	double f,g,h,p,q,s,a,b,c,k;
	HPoint vect1,vect2,vect3;

	switch(indata_style){
	case 1:
		r = pow(in_point[0][0],2.0)+pow(in_point[0][1],2.0)+pow(in_point[0][2],2.0)-1.0;
		if(r>0.0){
			pln->x = in_point[0][0];
			pln->y = in_point[0][1];
			pln->z = in_point[0][2];
			pln->r = sqrt(r);
			pln->side = side_flg;
			return(TRUE);
		}
		else{
			return(FALSE);
		}
		break;

	case 2:
		f = pow(in_point[0][0],2.0)+pow(in_point[0][1],2.0)+pow(in_point[0][2],2.0);
		g = pow(in_point[1][0],2.0)+pow(in_point[1][1],2.0)+pow(in_point[1][2],2.0);
		h = in_point[0][0]*in_point[1][0]+in_point[0][1]*in_point[1][1]+in_point[0][2]*in_point[1][2];
		if((f<=1.0)&&(g<=1.0)){
			if(fabs(f-g)>0.02){
				k = (f-3.0*g-2.0*h+4.0)/(4.0*(f-g));
				pln->x = k*in_point[0][0]+(1.0-k)*in_point[1][0];
				pln->y = k*in_point[0][1]+(1.0-k)*in_point[1][1];
				pln->z = k*in_point[0][2]+(1.0-k)*in_point[1][2];
				r = pow(pln->x,2.0)+pow(pln->y,2.0)+pow(pln->z,2.0)-1.0;
				if(r>0.0){
					pln->r = sqrt(r);
					pln->side = side_flg;
					return(TRUE);
				}
				else{
					pln->x = 0.0;
					pln->y = 0.0;
					pln->z = 0.0;
					pln->r = 0.0;
					return(FALSE);
				}
			}
			else{
				vect1.x = in_point[1][0] - in_point[0][0];
				vect1.y = in_point[1][1] - in_point[0][1];
				vect1.z = in_point[1][2] - in_point[0][2];
				r = sqrt(pow(vect1.x,2.0)+pow(vect1.y,2.0)+pow(vect1.z,2.0));
				vect1.x = vect1.x/r;
				vect1.y = vect1.y/r;
				vect1.z = vect1.z/r;
				pln->x = LIMIT * vect1.x;
				pln->y = LIMIT * vect1.y;
				pln->z = LIMIT * vect1.z;
				pln->side = OUTSIDE;
				r = pow(pln->x,2.0)+pow(pln->y,2.0)+pow(pln->z,2.0)-1.0;
				pln->r = sqrt(r);
				return(TRUE);
			}
		}
		else{
			return(FALSE);
		}        
		break;

	case 3:
		/***************************************************************************************/
		/*     3 point (x1,y1,z1) (x2,y2,z2) (x3,y3,z3) ------->(X,Y,Z)                        */
		/*                                                                                     */
		/*        |x1 y1|        |y1 z1|        |z1 x1|                                        */
		/*    f = |x2 y2|    g = |y2 z2|    h = |z2 x2|                                        */
		/*                                                                                     */
		/*    a = (x1*x1 + y1*y1 + z1*z1 + 1)/2                                                */
		/*    b = (x2*x2 + y2*y2 + z2*z2 + 1)/2                                                */
		/*    c = (x3*x3 + y3*y3 + z3*z3 + 1)/2                                                */
		/*                                                                                     */
		/*    Solve                                                                            */
		/*      x1*X + y1*Y + z1*Z = a                                                         */
		/*      x2*X + y2*Y + z2*Z = b                                                         */
		/*      x3*X + y3*Y + z3*Z = c                                                         */
		/***************************************************************************************/

		vect1.x = in_point[0][1]*in_point[1][2] - in_point[0][2]*in_point[1][1];
		vect1.y = in_point[0][2]*in_point[1][0] - in_point[0][0]*in_point[1][2];
		vect1.z = in_point[0][0]*in_point[1][1] - in_point[0][1]*in_point[1][0];
		vect2.x = in_point[1][1]*in_point[2][2] - in_point[1][2]*in_point[2][1];
		vect2.y = in_point[1][2]*in_point[2][0] - in_point[1][0]*in_point[2][2];
		vect2.z = in_point[1][0]*in_point[2][1] - in_point[1][1]*in_point[2][0];
		vect3.x = in_point[2][1]*in_point[0][2] - in_point[2][2]*in_point[0][1];
		vect3.y = in_point[2][2]*in_point[0][0] - in_point[2][0]*in_point[0][2];
		vect3.z = in_point[2][0]*in_point[0][1] - in_point[2][1]*in_point[0][0];

		if(pow(vect1.x,2.0)+pow(vect1.y,2.0)+pow(vect1.z,2.0)!=0.0){
			if( ((pow(vect2.x,2.0)+pow(vect2.y,2.0)+pow(vect2.z,2.0)!=0.0)
			    &&(same_vect(vect1,vect2)==TRUE))
			    ||((pow(vect3.x,2.0)+pow(vect3.y,2.0)+pow(vect3.z,2.0)!=0.0)
			    &&(same_vect(vect1,vect3)==TRUE)))
			{
				r = sqrt(pow(vect1.x,2.0)+pow(vect1.y,2.0)+pow(vect1.z,2.0));
				vect1.x = vect1.x/r;
				vect1.y = vect1.y/r;
				vect1.z = vect1.z/r;
				pln->x = LIMIT * vect1.x;
				pln->y = LIMIT * vect1.y;
				pln->z = LIMIT * vect1.z;
				pln->side = OUTSIDE;
				r = pow(pln->x,2.0)+pow(pln->y,2.0)+pow(pln->z,2.0)-1.0;
				pln->r = sqrt(r);
				return(TRUE);
			}
		}
		else{
			if(same_vect(vect2,vect3)==TRUE)
			{
				r = sqrt(pow(vect2.x,2.0)+pow(vect2.y,2.0)+pow(vect2.z,2.0));
				vect2.x = vect2.x/r;
				vect2.y = vect2.y/r;
				vect2.z = vect2.z/r;
				pln->x = LIMIT * vect2.x;
				pln->y = LIMIT * vect2.y;
				pln->z = LIMIT * vect2.z;
				pln->side = OUTSIDE;
				r = pow(pln->x,2.0)+pow(pln->y,2.0)+pow(pln->z,2.0)-1.0;
				pln->r = sqrt(r);
				return(TRUE);
			}
		}
		f = in_point[0][0]*in_point[1][1] - in_point[0][1]*in_point[1][0];
		g = in_point[0][1]*in_point[1][2] - in_point[0][2]*in_point[1][1];
		h = in_point[0][2]*in_point[1][0] - in_point[0][0]*in_point[1][2];
		s = g*in_point[2][0]+h*in_point[2][1]+f*in_point[2][2];
		if(s != 0.0){
			a = (pow(in_point[0][0],2.0)+pow(in_point[0][1],2.0)+pow(in_point[0][2],2.0)+1.0)/2.0;
			b = (pow(in_point[1][0],2.0)+pow(in_point[1][1],2.0)+pow(in_point[1][2],2.0)+1.0)/2.0;
			c = (pow(in_point[2][0],2.0)+pow(in_point[2][1],2.0)+pow(in_point[2][2],2.0)+1.0)/2.0;
			if(g!=0.0){
				p = in_point[1][1]*in_point[2][2] - in_point[1][2]*in_point[2][1];
				q = in_point[0][1]*in_point[2][2] - in_point[0][2]*in_point[2][1];
				pln->x = (g*c+p*a-q*b)/s;
				pln->y = (h*pln->x +a*in_point[1][2]-b*in_point[0][2])/g;
				pln->z = (f*pln->x -a*in_point[1][1]+b*in_point[0][1])/g;
			}
			else{
				if(h!=0.0){
					p = in_point[2][0]*in_point[1][2] - in_point[1][0]*in_point[2][2];
					q = in_point[2][0]*in_point[0][2] - in_point[0][0]*in_point[2][2];
					pln->y = (h*c+p*a-q*b)/s;
					pln->x = (g*pln->y -a*in_point[1][2]+b*in_point[0][2])/h;
					pln->z = (f*pln->y +a*in_point[1][0]-b*in_point[0][0])/h;
				}
				else{
					if(f!=0.0){
						p = in_point[1][0]*in_point[2][1] - in_point[2][0]*in_point[1][1];
						q = in_point[0][0]*in_point[2][1] - in_point[2][0]*in_point[0][1];
						pln->z = (f*c+p*a-q*b)/s;
						pln->x = (g*pln->z +a*in_point[1][1]-b*in_point[0][1])/f;
						pln->y = (h*pln->z -a*in_point[1][0]+b*in_point[0][0])/f;
					}
					else{
						pln->x = 0.0;
						pln->y = 0.0;
						pln->z = 0.0;
						return(FALSE);
					}
				}
			}
		}
		else{
			return(FALSE);
		}
		r = pow(pln->x,2.0)+pow(pln->y,2.0)+pow(pln->z,2.0)-1.0;
		if(r>0.0){
			pln->r = sqrt(r);
			pln->side = side_flg;
			return(TRUE);
		}
		else{
			pln->x = 0.0;
			pln->y = 0.0;
			pln->z = 0.0;
			pln->r = 0.0;
			return(FALSE);
		}
		break;

	default:
		return(FALSE);
		break;
	}
}     

int same_vect(v1,v2)
HPoint v1;
HPoint v2;
{
	double mat,d1,d2;

	d1 = sqrt(pow(v1.x,2.0)+pow(v1.y,2.0)+pow(v1.z,2.0));
	d2 = sqrt(pow(v2.x,2.0)+pow(v2.y,2.0)+pow(v2.z,2.0));
	mat = (v1.x*v2.x+v1.y*v2.y+v1.z*v2.z)/(d1*d2);

	if((mat == 1.0)||(mat== -1.0)){
		return(TRUE);
	}
	else{
		return(FALSE);
	}
} 


