/*****************************************************************/
/*                                                               */
/*          Copyright (c) 1991-1992 by J.Nisimoto                */
/*                                                               */
/*                   H  c  a  d  3  D  - Ver 2.0                 */
/*                                                               */
/*  Permission to use,copy,modify,and distribute this software.  */
/*                                                               */
/*  Hcad3d.c: Main program.                                      */
/*                                                               */
/*                                                               */
/*****************************************************************/

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/X.h>
#include <X11/Xatom.h>
#include <math.h>
#include <string.h>
#include "source/Hcad.h"

/**************** include mouse cursor bitmap file ***************/
#include "image/cursor.bm"

/**************** include gray level bitmap file *****************/
#include "image/gray.bm"

/**************** include global variable ************************/
#include "source/Hcadvar.h"


/*------------------------------------------------------------

  Function : set_window()

-------------------------------------------------------------*/
set_window()
{
	/* set base window */
	basehint.x = 10;
	basehint.y = 10;
	basehint.width = 815;
	basehint.height = 725;
	basehint.flags = PPosition | PSize;

	/* set drawing window */
	drahint.x = 3;
	drahint.y = 30;
	drahint.width = 807;
	drahint.height = 690;
	drahint.flags = PPosition | PSize;

	/* set menubar window */
	menubarhint.x = 3;
	menubarhint.y = 1;
	menubarhint.width = 809;
	menubarhint.height = 27;
	menubarhint.flags = PPosition | PSize; 


	basewin = XCreateSimpleWindow(disp,
	DefaultRootWindow(disp),
	basehint.x, basehint.y, basehint.width,
	basehint.height, 1, black,
	white);

	drawin = XCreateSimpleWindow(disp,basewin,
	drahint.x, drahint.y, drahint.width,
	drahint.height, 1, white, black);

	menubar = XCreateSimpleWindow(disp, basewin, menubarhint.x, menubarhint.y,
	menubarhint.width, menubarhint.height,
	1, black, white);

	dragc = XCreateGC(disp,drawin,0,0);
	XCopyGC(disp, DefaultGC(disp,0),-1,dragc);
	XSetBackground(disp,dragc,black);
	XSetForeground(disp,dragc,white);
	XSetFunction(disp,dragc,GXcopy);
	XSetLineAttributes(disp,dragc,0,LineSolid,CapNotLast,JoinMiter);
	XSetDashes(disp,dragc,0,dash,2);  


	menubargc = XCreateGC(disp,menubar,0,0);
	XCopyGC(disp, DefaultGC(disp,0),-1,menubargc);
	XSetBackground(disp,menubargc,white);
	XSetForeground(disp,menubargc,black); 
	XSetFunction(disp,menubargc,GXcopy);

	norm_gc = XCreateGC(disp,menubar,0,0);
	XCopyGC(disp, DefaultGC(disp,0),-1,norm_gc);
	XSetBackground(disp,norm_gc,white);
	XSetForeground(disp,norm_gc,black); 
	XSetFunction(disp,norm_gc,GXcopy);

	invert_gc = XCreateGC(disp,menubar,0,0);
	XCopyGC(disp, DefaultGC(disp,0),-1,invert_gc);
	XSetBackground(disp,invert_gc,black);
	XSetForeground(disp,invert_gc,white); 
	XSetFunction(disp,invert_gc,GXcopy);
}


/*------------------------------------------------------------

  Function : set_pixmap()

-------------------------------------------------------------*/

set_pixmap(){
	XColor cfore,cback;
	Colormap cmap;
	Status resl;

	curmap[0] = XCreateBitmapFromData(disp,drawin,r_cur_bits,
		r_cur_width,r_cur_height);
	curmap[1] = XCreateBitmapFromData(disp,drawin,l_cur_bits,
		l_cur_width,l_cur_height);
	curmap[2] = XCreateBitmapFromData(disp,drawin,t_cur_bits,
		t_cur_width,t_cur_height);
	curmap[3] = XCreateBitmapFromData(disp,drawin,b_cur_bits,
		b_cur_width,b_cur_height);
	curmap[4] = XCreateBitmapFromData(disp,drawin,rt_cur_bits,
		rt_cur_width,rt_cur_height);
	curmap[5] = XCreateBitmapFromData(disp,drawin,lt_cur_bits,
		lt_cur_width,lt_cur_height);
	curmap[6] = XCreateBitmapFromData(disp,drawin,rb_cur_bits,
		rb_cur_width,rb_cur_height);
	curmap[7] = XCreateBitmapFromData(disp,drawin,lb_cur_bits,
		lb_cur_width,lb_cur_height);

	cmap = DefaultColormap(disp,DefaultScreen(disp));
	resl = XParseColor(disp,cmap,"BLACK",&cback);
	resl = XParseColor(disp,cmap,"WHITE",&cfore);

	cur[0] = XCreatePixmapCursor(disp,curmap[0],None,&cfore,&cback,8,8);
	cur[1] = XCreatePixmapCursor(disp,curmap[1],None,&cfore,&cback,8,8);
	cur[2] = XCreatePixmapCursor(disp,curmap[2],None,&cfore,&cback,8,8);
	cur[3] = XCreatePixmapCursor(disp,curmap[3],None,&cfore,&cback,8,8);
	cur[4] = XCreatePixmapCursor(disp,curmap[4],None,&cfore,&cback,8,8);
	cur[5] = XCreatePixmapCursor(disp,curmap[5],None,&cfore,&cback,8,8);
	cur[6] = XCreatePixmapCursor(disp,curmap[6],None,&cfore,&cback,8,8);
	cur[7] = XCreatePixmapCursor(disp,curmap[7],None,&cfore,&cback,8,8);
}


/*------------------------------------------------------------

  Function : init_gray()

-------------------------------------------------------------*/
init_gray(){
	gray[0] = XCreateBitmapFromData(disp,drawin,gray0_bits,gray0_width,gray0_height);
	gray[1] = XCreateBitmapFromData(disp,drawin,gray1_bits,gray1_width,gray1_height);
	gray[2] = XCreateBitmapFromData(disp,drawin,gray2_bits,gray2_width,gray2_height);
	gray[3] = XCreateBitmapFromData(disp,drawin,gray3_bits,gray3_width,gray3_height);
	gray[4] = XCreateBitmapFromData(disp,drawin,gray4_bits,gray4_width,gray4_height);
	gray[5] = XCreateBitmapFromData(disp,drawin,gray5_bits,gray5_width,gray5_height);
	gray[6] = XCreateBitmapFromData(disp,drawin,gray6_bits,gray6_width,gray6_height);
	gray[7] = XCreateBitmapFromData(disp,drawin,gray7_bits,gray7_width,gray7_height);
	gray[8] = XCreateBitmapFromData(disp,drawin,gray8_bits,gray8_width,gray8_height);
}


/*------------------------------------------------------------

  Function : set_cosine()

-------------------------------------------------------------*/
void set_cosine(){

	int i;

	for(i=0;i<12;i++){
		cosin[i] = cos(i*PIE/12);
		sine[i] = sin(i*PIE/12);
	}
}

/*------------------------------------------------------------

  Function : init_plane()

-------------------------------------------------------------*/
init_plane(){
	int i,j;

	for(i = 0; i < PLANE_MAX; i++){
		plane[i].id = i;
		plane[i].side = OUTSIDE;
		plane[i].x  = 0.0;
		plane[i].y  = 0.0;
		plane[i].z  = 0.0;
		plane[i].r  = 0.0;
		for(j = 0; j < CROSS_MAX; j++){
			plane[i].cross[j] = -1;
		}
	}
	for(i = 0;i<LINE_MAX;i++){
		line1[i].id1 = -1;
		line1[i].id2 = -1;
	}
	total_plane = 0;
	total_line = 0;

}

/*------------------------------------------------------------

  Function : draw_inv_str()

-------------------------------------------------------------*/
draw_inv_str(win1,gc1,flg,x1,y1,w1,h1,x2,y2,str)
Window win1;
GC     gc1;
int flg,x1,y1,w1,h1,x2,y2;
char *str;
{

	if(flg){
		gc1 = norm_gc;
		XFillRectangle(disp,win1,gc1,x1,y1,w1,h1);
		gc1 = invert_gc;
		XDrawString(disp,win1,gc1,x2,y2,str,strlen(str));
	}
	else{
		gc1 = invert_gc;
		XFillRectangle(disp,win1,gc1,x1,y1,w1,h1);
		gc1 = norm_gc;
		XDrawString(disp,win1,gc1,x2,y2,str,strlen(str));
	}
}




/*------------------------------------------------------------

  Function : expose_task()

-------------------------------------------------------------*/
expose_task(){

	if(ev.xexpose.count == 0){
		XDrawImageString(
		ev.xexpose.display,
		ev.xexpose.window,
		dragc,200,200,
		winame,strlen(winame)  );
		set_menu();
		show_object(0);
	}
}

/*------------------------------------------------------------

  main()

-------------------------------------------------------------*/
main(argc,argv)
int argc;
char *argv[ ];

{
	int i,j;
	char text[10];
	Window rootwin;
	Atom atom,ret_atom;
	unsigned char *ret_prop;
	char *chg_prop;
	unsigned long ret_len,ret_after;
	int ret_format;
	int menu_num,ret_num;
	int take_property_flg;
	XSetWindowAttributes  atr;
        char font_name[50];
        char **font_list;
        int font_count;


	/* Copyright */
	printf("Hcad3D ver.2.00\n");
	printf("Copyright (c) 1991-1992 by J.Nisimoto\n");
	printf("Permission to use, copy, modify and distribute this software.\n\n");

	/* initialize hyperbolic planes */
	init_plane();

	/* establish display connection */
	disp = XOpenDisplay("");
	if(!disp){
		printf("Can't establish display connection\n");
		exit(0);
	}

	/* set deaults */
	hypscreen  = DefaultScreen(disp);
	rootwin = XDefaultRootWindow(disp);

	/* set white and black color */
	black = BlackPixel(disp,hypscreen);
	white = WhitePixel(disp,hypscreen);
        for(i = 2;i <= argc;i++){
  	       if(strcmp(argv[i-1],"-r")==0){ /* Reverse mode */ 
			black = WhitePixel(disp,hypscreen);
			white = BlackPixel(disp,hypscreen);
		}
                if((strcmp(argv[i-1],"-fn")==0)&&(i+1<=argc)){
                        strcpy(font_name,argv[i]);
                        i++;
                        font_list = XListFonts(disp,font_name,
                                strlen(font_name),&font_count);
                        if(font_count != 0){
                          font_flg = TRUE;    
                          font = XLoadFont(disp,font_name);
                        }
                        else{
                          printf("Font %s not exist !!!!!\n",font_name);
                        } 
                }     
	     }

	file_name[0] = '\0';
	ps_file[0] = '\0';
	strcpy(print_com,PRINT_COM);
	strcpy(file_path,HCAD_PATH);
	strcat(file_path,"/data/");
	strcpy(work_path,HCAD_PATH);
	strcat(work_path,"/data/");
	strcpy(demo_path,HCAD_PATH);
	strcat(demo_path,"/demo/");

	/*  set unit ball */
	unit_ball.x = 0.0;
	unit_ball.y = 0.0;
	unit_ball.z = 0.0;
	unit_ball.r = 1.0;

	/* Set array of cosine and sine used frequently */
	set_cosine();

	/* Set window size  */
	set_window();

	/* Set Pixmap for mouse cursor */
	set_pixmap();

	/* Set Pixmap for gray level*/
	init_gray();

	/* Set window property */
	atom = XInternAtom(disp,atom_name,False);
	XSetStandardProperties(disp,basewin,winame,iconame,
	None,argv,argc,&basehint);



	/* Set input event selection  */
	XSelectInput(disp,basewin,ButtonPressMask |ButtonReleaseMask | KeyPressMask |
	    PointerMotionMask|ExposureMask);
	XSelectInput(disp,rootwin,PropertyChangeMask);

	atr.backing_store = WhenMapped;
	XChangeWindowAttributes(disp,drawin,CWBackingStore,&atr);

        if(font_flg == TRUE){
          XSetFont(disp,menubargc,font);
          XSetFont(disp,invert_gc,font);
          XSetFont(disp,norm_gc,font);
        }
	/* Map window */
	XMapRaised(disp,basewin);
	XMapSubwindows(disp,basewin); 
	show_object(0);

	/* Main loop*/
	done = 0;
	take_property_flg = TRUE;

	while(done == 0){

		/*read next event */
		if(XEventsQueued(disp,QueuedAfterReading)==0){
			XFlush(disp);
		}
		XNextEvent(disp,&ev);

		switch(ev.type){
		case Expose:
			menu_num = MENU_MAX;
			if(ev.xexpose.count == 0){
				expose_task();
			}
			break;

		case MappingNotify:
			XRefreshKeyboardMapping(&ev);
			break;

		case  ButtonPress:
			if(menu_num <10){
				draw_inv_str(menubar,menubargc,OFF,menu_num*100,2,99,21,
				100*menu_num+30,20,menu_name[menu_num]);
				menu_num = MENU_MAX;
			}
			check_button();
			break;

		case ButtonRelease:
			XUndefineCursor(disp,drawin);
			break;

		case MotionNotify:
			if(ev.xmotion.subwindow == menubar){
				if(ev.xmotion.x/100 != menu_num){
					if(menu_num < MENU_MAX){
						draw_inv_str(menubar,menubargc,OFF,menu_num*100,2,99,21,
						100*menu_num+30,20,menu_name[menu_num]);
					}
					menu_num = ev.xmotion.x / 100;
					if(menu_num < MENU_MAX){
						draw_inv_str(menubar,menubargc,ON,menu_num*100,2,99,21,
						100*menu_num+30,20,menu_name[menu_num]);
					}
				}               
			}
			else{
				if(menu_num < MENU_MAX){
					draw_inv_str(menubar,menubargc,OFF,menu_num*100,2,99,21,
					100*menu_num+30,20,menu_name[menu_num]);
					menu_num = MENU_MAX;
				}
			}             
			break;  

		case PropertyNotify:
			XGetWindowProperty(disp,rootwin,atom,0,8192,False,XA_STRING,
			&ret_atom,&ret_format,&ret_len,&ret_after,&ret_prop);
			ret_num = str_to_command(ret_prop);
			XFree(ret_prop);
			if(ret_num != -2){
				if(ret_num == -1){
					sprintf(text,"NG");
				}
				else{
					sprintf(text,"OK %d",ret_num);
				}
				chg_prop = &text[0];
				XChangeProperty(disp,rootwin,atom,XA_STRING,16,PropModeReplace,chg_prop,
				strlen(chg_prop));
			}
			break;

		default:
			break;
		}
	}

	/* Free memory */

	for(i=0;i<8;i++){
		XFreeCursor(disp,cur[i]);
	}
        XUnloadFont(disp,font);
	XFreeGC(disp,dragc);
	XDestroySubwindows(disp,basewin); 
	XDestroyWindow(disp,basewin);
	XCloseDisplay(disp);
	exit(0);
}


