/*****************************************************************
 * fbsample.c: FBM Release 1.0 25-Feb-90 Michael Mauldin
 *
 * Copyright (C) 1989,1990 by Michael Mauldin.  Permission is granted
 * to use this file in whole or in part for any purpose, educational,
 * recreational or commercial, provided that this copyright notice
 * is retained unchanged.  This software is available to all free of
 * charge by anonymous FTP and in the UUNET archives.
 *
 * fbsample.c:  1 bit to 8 bit conversion by sampling
 *
 * USAGE
 *	% fbsample [ title ] < foo.pbm > foo.fbm
 *
 * EDITLOG
 *	LastEditDate = Mon Jun 25 00:04:36 1990 - Michael Mauldin
 *	LastFileName = /usr2/mlm/src/misc/fbm/fbsample.c
 *
 * HISTORY
 * 25-Jun-90  Michael Mauldin (mlm@cs.cmu.edu) Carnegie Mellon
 *	Package for Release 1.0
 *
 * 20-May-89  Michael Mauldin (mlm) at Carnegie Mellon University
 *	Bug fix from Dave Cohrs <dave@cs.wisc.edu>
 *
 * 07-Mar-89  Michael Mauldin (mlm) at Carnegie Mellon University
 *	Beta release (version 0.9) mlm@cs.cmu.edu
 *
 *  5-Sep-88  Michael Mauldin (mlm) at Carnegie-Mellon University
 *	Created.
 *****************************************************************/

#include <stdio.h>
#include <ctype.h>
#include "fbm.h"

int width, height;

# define USAGE \
  "fbsample [ -t'title' -c'credits' -g'grain' -n'nbr' ]\n\
	 [ -<type> ] < bitmap > image"

#ifndef lint
static char *fbmid =
"$FBM fbsample.c <1.0> 25-Jun-90  (C) 1989,1990 by Michael Mauldin, source \
code available free from MLM@CS.CMU.EDU and from UUNET archives$";
#endif

main(argc, argv)
  int             argc;
  char           *argv[];
{
  char           *title = NULL, *credits = NULL;
  register unsigned char *bmp;
  register int	  i, j, r, c, irow, orow, grain=5, nbr=5, sum;
  int		  outtype = DEF_1BIT;
  FBM		  input, output;

  /* Clear the memory pointers so alloc_fbm won't be confused */
  input.cm  = input.bm  = (unsigned char *) NULL;
  output.cm = output.bm = (unsigned char *) NULL;

  /* Get the options */
  while (--argc > 0 && (*++argv)[0] == '-')
  { while (*++(*argv))
    { switch (**argv)
      { case 'g':	grain = atoi (*argv+1); SKIPARG; break;
        case 'n':	nbr = atoi (*argv+1); SKIPARG; break;
	case 't':	title = *argv+1; SKIPARG; break;
	case 'c':	credits = *argv+1; SKIPARG; break;
	case 'A':	outtype = FMT_ATK; break;
	case 'B':	outtype = FMT_FACE; break;
	case 'F':	outtype = FMT_FBM; break;
	case 'G':	outtype = FMT_GIF; break;
	case 'I':	outtype = FMT_IFF; break;
	case 'L':	outtype = FMT_LEAF; break;
	case 'M':	outtype = FMT_MCP; break;
	case 'P':	outtype = FMT_PBM; break;
	case 'R':	outtype = FMT_RLE; break;
	case 'S':	outtype = FMT_SUN; break;
	case 'T':	outtype = FMT_TIFF; break;
	case 'X':	outtype = FMT_X11; break;
	case 'Z':	outtype = FMT_PCX; break;
	default:	fprintf (stderr, "Usage: %s\n", USAGE);
			exit (1);
      }
    }
  }

  if (grain < 1 || grain > 16)
  { fprintf (stderr,
	     "Usage: %s\n%s\n",
	     "       (grain must be between 1 and 16)\n");
    exit (0);
  }

  /* Read pbm bitmap */
  if (! read_bitmap (&input, (char *) NULL))
  { fprintf (stderr, "%s: input garbled or not in PBM format\n", argv[0]);
    exit(1);
  }

  if (title == NULL && input.hdr.title[0])
  { title = input.hdr.title; }

  if (grain > 1)
  { width = input.hdr.cols / grain;
    height = input.hdr.rows / grain;
  }
  else
  { width = input.hdr.cols - grain + 1;
    height = input.hdr.rows - grain + 1;
  }

  orow = 2 * ((width * 8 + 15) / 16);
  irow = input.hdr.rowlen;

  fprintf (stderr, "Sample (1bit to 8bit) \"%s\": [%dx%dx1] ==> [%dx%dx8]\n",
	  title ? title : "(untitled)",
	  input.hdr.cols, input.hdr.rows, width, height);

  /* Set up output header */
  output.hdr.cols = width;
  output.hdr.rows = height;
  output.hdr.planes = 1;
  output.hdr.bits = 8;
  output.hdr.physbits = 8;
  output.hdr.rowlen = orow;
  output.hdr.plnlen = orow * height;
  output.hdr.aspect = 1.0;
  output.hdr.clrlen = 0;

  if (title) strcpy (output.hdr.title, title);
  if (credits) strcpy (output.hdr.credits, credits);
  
  alloc_fbm (&output);

  fprintf (stderr, "width %d, height %d, grain %d, nbr %d, irow %d, orow %d\n",
	   width, height, grain, nbr, irow, orow);
  
  for (r=0; r<height; r++)
  { for (c=0; c<width; c++)
    { sum = 0;
      bmp = &(input.bm[(r*grain) * irow + (c*grain)]);

      for (j=0; j<nbr; j++, bmp += irow)
      { for (i=0; i<nbr; i++)
        { if (bmp[i]) sum++; }
      }

      if (sum > 255) sum = 255;
      
      output.bm[r * orow + c] = sum;
    }
  }

  write_bitmap (&output, stdout, outtype);

  exit (0);
}
