/*
# proc: new_pi_list - allocates and initializes a new list of phrase indices,
# proc:               storing the top-leftmost blob's index into it.
*/

#include <stdio.h>
#include <defs.h>
#include <maxlist.h>

/*************************************************************************/
new_pi_list(pi, px, py, prevdelta, prevflag,
            pi_lists, pi_lens, nphrases, pis, mxs, mys, end, abm, a1, b1,
            abegin, alimit, ylimit)
int *pi_lists[], *pi_lens;
int *nphrases;
float *prevdelta;
int *prevflag;
int *pi, *px, *py, *pis, *mxs, *mys, *end;
float abm, a1, b1, abegin, alimit, ylimit;
{
   int tl, left_i;
   float dist;
   int *pi_list;

   find_top_left(&tl, mxs, mys, (*end));
   look_left(&left_i, &dist, tl, mxs, mys, (*end),
             abm, a1, b1, abegin, alimit, ylimit);
   if(left_i == -1)
      left_i = tl;
   pi_list = (int *)calloc(MAX_INDEX, sizeof(int));
   if(pi_list == NULL)
      syserr("new_pi_list", "calloc", "pi_list");
   pi_list[0] = pis[left_i];

   (*px) = mxs[left_i];
   (*py) = mys[left_i];
   (*pi) = left_i;
   *(prevdelta) = 0.0;
   *(prevflag) = FALSE;
   remove_item(left_i, pis, mxs, mys, end);

   pi_lists[*nphrases] = pi_list;
   pi_lens[*nphrases] = 1;
   (*nphrases)++;
}
