/* 4dd_gt.h - IRIS version declarations (3xxx Series) */

/* @(#)4dd_gt.h	1.1 */

#define VTXNLT		256
#define VTXNLG		512
#define NVAR	6

/* subscripts for pnt[] below */
#define NX		0
#define NY		1
#define NZ		2
#define LX		3
#define LY		4
#define LZ		5

struct Vertex {
	int shmid;
	GSPEC *gs;
	int nlg;
	int nlt;
	int lgmin, lgmax;
	int ltmin, ltmax;
	Coord pnt[VTXNLG][VTXNLT][NVAR];
	unsigned int data[VTXNLG][VTXNLT];
};

/* special values for vertex 'data' above */
#define VTX_VOID	255

extern struct Vertex *makerect();
extern int edit_exit;

/* our own events (Device)'s */
#define CREATE		(MAXSGIDEVICE+1)
#define DESTROY		(MAXSGIDEVICE+2)
#define WRITECONFIG	(MAXSGIDEVICE+3)

struct wireinfo {
	long gid;
	char name[40];
	struct Vertex *vtx;
	int menu;
	int color_background;
	int color_lines;
	int color_meterlines;
	int color_eraselines;
	long position_x, position_y;
	long size_x, size_y;
	Coord clipx, clipy, clipz;
	Coord panx, pany, panz;
	Coord zoom;
	Coord dist;
	Angle azim, inc, twist;
	int ltflag;				/* latitudes on */
	int lgflag;				/* longitudes on */
	int ltpitch;			/* pitch of latitude lines, 1=max */
	int lgpitch;			/* pitch of longitude lines, 1=max */
	int ltresolution;		/* res along latitudes, 1=max */
	int lgresolution;		/* res along longitudes, 1=max */
	Boolean depthcue;		/* depth cue the lines */
	Boolean drawvoid;		/* draw voids ? */
	Boolean doublebuffer;	/* doublebuffer ? */
};

struct renderinfo {
	long gid;
	char name[127];
	struct Vertex *vtx;
	int menu;
	int color_background;
	int color_meterlines;
	int color_erase;
	long position_x, position_y;
	long size_x, size_y;
	Coord clipx, clipy, clipz;
	Coord panx, pany, panz;
	Coord zoom;
	Coord dist;
	Angle azim, inc, twist;
	int ltresolution;		/* res along latitudes, 1=max */
	int lgresolution;		/* res along longitudes, 1=max */
	int index_lt, index_lg;
	Boolean wire_transform;
	Boolean ortho_flag;
	int patch_mode;
	int render_mode;
	long material_index;
	long model_index;
	Boolean doublebuffer;
	Boolean render_firsttime;
};

struct wireinfo wire;
struct renderinfo render;
