/* module:	4dd_echo.h				echo image editor header file */

/* @(#)4dd_echo.h	1.1 */

/* globals */

extern short termflag;			/* terminate execution flag */
extern short interrupt;			/* interrupt flag, return to prompt */
extern struct CMDTAB cmdtab[];

extern int errno;

#define real			float	/* Iris prefers 4 byte real numbers */

#ifndef TRUE
#define TRUE	1
#define FALSE	0
#endif

/* declare some commonly used non-int functions */

extern char				*calloc();
extern char				*ctime();
extern long				lseek();
extern char				*malloc();
extern unsigned long	sleep();
extern char				*strcat();
extern char				*strncat();
extern char				*strtok();
extern char				*strchr();
extern long				time();
extern char				*errname();
extern char				*getenv();
extern struct passwd	*getpwnam();

#define METERCHAR	('.')

/* strtok() macro, return next command line token, see executecmd() */

#define nextword(str)	(strtok((char *)0, " \t\n"))

/* command dispatch and help table */

struct CMDTAB {
	char *keyword;				/* command keyword string */
	short unique;				/* number of unique characters in keyword */
	int (*function)();			/* function to execute command */
	char *helpstr;				/* help index string */
};
