/* module:	echo.h				echo image editor header file */

/* @(#)echo.h	1.41 */

/* globals */

extern short termflag;			/* terminate execution flag */
extern short interrupt;			/* interrupt flag, return to prompt */
extern short technical;			/* flag enable various technical features */
extern struct CMDTAB cmdtab[];

extern int errno;

#ifdef IRIS
#define real			float	/* Iris prefers 4 byte real numbers */
#endif

#ifdef HP_INTEGRAL
#define real			double	/* HP-IPC prefers 8 byte real numbers */
#endif

#ifdef SUN
/*#define real			float*/	/* Sun's favorite ??? */
#define fsin sin
#define fcos cos
#define fasin asin
#define facos acos
typedef float real;
#endif

#ifndef TRUE
#define TRUE	1
#define FALSE	0
#endif

/* declare some commonly used non-int functions */

extern short			*readrawfile();
extern short			*writerawfile();
extern short			*getpicture();
extern char				*memallo();
extern FILE				*fopenpath();
extern char				*expandhome();
extern char				**arrayalloc2();
extern char				*color_tmppath();
extern char				*nofill_tmppath();

extern char				*calloc();
extern char				*ctime();
extern long				lseek();
extern char				*malloc();
extern unsigned long	sleep();
extern char				*strcat();
extern char				*strncat();
extern char				*strtok();
extern char				*strchr();
extern long				time();
extern char				*errname();
extern char				*getenv();
extern struct passwd	*getpwnam();

/* misc characters */

#ifdef HP_INTEGRAL
#define METERCHAR	('\374')
#else
#define METERCHAR	('.')
#endif

/* strtok() macro, return next command line token, see executecmd() */

#define nextword(str)	(strtok((char *)0, " \t"))

/* command dispatch and help table */

struct CMDTAB {
	char *keyword;				/* command keyword string */
	short unique;				/* number of unique characters in keyword */
	int (*function)();			/* function to execute command */
	char *helpstr;				/* help index string */
};


#ifdef SUN
#define sighold(sig)		sigblock(sig)		/* roughly equivalent */
#endif
