/*ScianEvents.c
  Eric Pepke
  March 8, 1990
  Event stuff for scian
*/

#include "Scian.h"
#include "ScianTypes.h"
#include "ScianWindows.h"
#include "ScianEvents.h"
#include "ScianGarbageMan.h"
#include "ScianSockets.h"
#include "ScianScripts.h"
#include "ScianColors.h"
#include "ScianIDs.h"
#include "ScianTimers.h"
#include "ScianMainWindow.h"
#include "ScianObjWindows.h"
#include "ScianVisWindows.h"
#include "ScianPreferences.h"

ObjPtr dropObject = NULLOBJ;		/*Object to drop in window*/
int dropX, dropY;			/*Global coordinates of place to drop*/
#ifdef INTERACTIVE
long inputWindow = 0;			/*Current window for input or 0*/
int curMouse = LEFTMOUSE;		/*Current mouse button down*/
int globalEventFlags = 0;		/*Flags for this event*/
Bool interactiveMoving = false;		/*True iff moving interactively*/
Bool contextHelp = false;		/*Context sensitive help*/
#endif
#ifdef IRISNTSC
int NTSCOn = 0;				/*True iff NTSC is on*/
#endif

#define MAXNTASKS	20		/*Maximum # of tasks*/

TaskType doTasks[MAXNTASKS];		/*Tasks to do*/
int tasksLeft = 0;			/*Number of tasks left*/

#define MAXNDEFMES	100		/*Maximum # of deferred messages*/

struct
    {
	ObjPtr object;			/*The object to send the message*/
	int message;			/*The message to send*/
    } defMessages[MAXNDEFMES];
int defMesLeft = 0;

ObjPtr deferredMessageList;		/*List of deferred messages*/

#ifdef INTERACTIVE
long lastClickTime = 0;			/*The time the last click was done*/
long lastKeyTime = 0;			/*The last time of a keypress*/
int lastClickX, lastClickY;		/*The last click X and Y*/ 
Bool sentKey = false;			/*True iff a key has been sent*/
long keyWindow = 0;			/*Window the last key was sent to*/
#endif

FILE *curScript = 0;			/*Current script being read, if any*/
char scriptLine[256];			/*Current line of the script*/
Bool lineAccepted = true;		/*True iff last script line was accepted*/

int running = 1;			/*True iff running*/

#ifdef INTERACTIVE
/*Values for mouse switchboard*/
#define MOUSEPRESS	1		/*Select, drag, etc. with mouse*/
#define MOUSEMENU	2		/*Bring up mouse menu*/
#define MOUSEROTATE	3		/*Rotate with the mouse*/

/*Mouse switchboard*/
int mouseSwitchboard[3] =
    {
	MOUSEMENU,
	MOUSEROTATE,
	MOUSEPRESS
    };
#endif

void DoTask(task)
TaskType task;
/*Asks the system to do task at its earliest possible convenience*/
{
    doTasks[tasksLeft++] = task;
}

void DeferMessage(object, message)
ObjPtr object;
int message;
/*Asks the system to do task at its earliest possible convenience*/
{
    defMessages[defMesLeft] . object = object;
    defMessages[defMesLeft] . message = message;
    ++defMesLeft;
}

void DoUniqueTask(task)
TaskType task;
/*Asks the system to do task at its earliest possible convenience,
  but only if it hasn't already been requested*/
{
    int k;
    for (k = 0; k < tasksLeft; ++k)
    {
	if (doTasks[k] == task)
	{
	    return;
	}
    }
    doTasks[tasksLeft++] = task;
}

void DoQuit()
/*Asks to quit on the next loop*/
{
    running = 0;
}

#ifdef INTERACTIVE
void QueueDevices()
/*Queues up all the devices that will be used by Scian*/
{
    qdevice(KEYBD);
    qdevice(PADPF1);
    qdevice(F1KEY);
    qdevice(PADPF2);
    qdevice(F2KEY);
    qdevice(PADPF3);
    qdevice(F3KEY);
    qdevice(PADPF4);
    qdevice(F4KEY);
    qdevice(F5KEY);
    qdevice(F6KEY);
    qdevice(F7KEY);
    qdevice(F8KEY);
    qdevice(F9KEY);
    qdevice(F10KEY);
    qdevice(F11KEY);
    qdevice(F12KEY);
    qdevice(MOUSE1);
    qdevice(MOUSE2);
    qdevice(MOUSE3);
    qdevice(UPARROWKEY);
    qdevice(DOWNARROWKEY);
    qdevice(LEFTARROWKEY);
    qdevice(RIGHTARROWKEY);
    qdevice(WINFREEZE);
    qdevice(WINTHAW);
#ifdef IRIS
    qdevice(WINSHUT);
    qdevice(BUT157);
#endif
}

void UnqueueDevices()
/*Unqueues all the devices*/
{
    unqdevice(WINFREEZE);
    unqdevice(WINTHAW);
    unqdevice(KEYBD);
    unqdevice(PADPF1);
    unqdevice(F1KEY);
    unqdevice(PADPF2);
    unqdevice(F2KEY);
    unqdevice(PADPF3);
    unqdevice(F3KEY);
    unqdevice(PADPF4);
    unqdevice(F4KEY);
    unqdevice(F5KEY);
    unqdevice(F6KEY);
    unqdevice(F7KEY);
    unqdevice(F8KEY);
    unqdevice(F9KEY);
    unqdevice(F10KEY);
    unqdevice(F11KEY);
    unqdevice(F12KEY);
    unqdevice(MOUSE1);
    unqdevice(MOUSE2);
    unqdevice(MOUSE3);
    unqdevice(UPARROWKEY);
    unqdevice(DOWNARROWKEY);
    unqdevice(LEFTARROWKEY);
    unqdevice(RIGHTARROWKEY);
#ifdef IRIS
    unqdevice(WINSHUT);
    qdevice(BUT157);
#endif
}
#endif

void LongOperation()
/*Signals the user that a long operation is about to occur
  This version sets to the watchcursor*/
{
    MySetCursor(WATCHCURSOR);
}

void EndLongOperation()
/*Ends a long operation*/
{
    if (curCursor == WATCHCURSOR)
    {
	MySetCursor(0);
    }
}

void SetContextSensitiveHelp()
/*Sets up the system so that the next press click is a help*/
{
    MySetCursor(QUESTIONCURSOR);
    contextHelp = true;
}

#ifdef INTERACTIVE
void KeyDown(theKey)
short theKey;
/*Does a keyDown for theKey.  This should only be used for keyboard events that
  do not require a corresponding key up event.*/
{
    if (!inputWindow || !GetWinInfo(inputWindow))
    {
	/*No focus; return*/
	return;
    }
    SelectWindow(inputWindow);

    if (!selWinInfo)
    {
	/*Pathological case.  Return.*/
	return;
    }

    if (theKey)
    {
	interactiveMoving = true;		/*This is interactive*/
    }
    else
    {
	interactiveMoving = false;		/*Not any more*/
    }

    {
	FuncTyp actionMethod;		/*The method to call for the action*/
	long newTime;
	struct tms buffer;

	/*Determine if this is potentially a double keypress*/
	newTime = times(&buffer);
	if (newTime - lastKeyTime < CLICK2TIME)
	{
	    globalEventFlags |= F_DOUBLECLICK;
	}
	sentKey = theKey ? true : false;
	keyWindow = inputWindow;
	lastKeyTime = newTime; 

	actionMethod = GetMethod((ObjPtr) selWinInfo, KEYDOWN);
	if (actionMethod)
	{
	    /*There's a key down routine.  Call it.*/
	    curIntWindow = selWinInfo;
	    if (theKey == '\r')
	    {
		/*Kludge to get it to flush stuff before enter key*/
		FlushKeystrokes();
	    }
	    (*actionMethod)(selWinInfo, theKey, globalEventFlags);
	    curIntWindow = 0;
	}
    }
}
#endif

void FlushKeystrokes()
/*Flushes the keystrokes to an object that takes keystrokes*/
{
#ifdef INTERACTIVE
    if (sentKey)
    {
	long tempInput;
	tempInput = inputWindow;
	inputWindow = keyWindow;
	KeyDown(0);
	sentKey = false;
	inputWindow = tempInput;
    }
#endif
}

#ifdef INTERACTIVE
void MouseDown(whichButton)
long whichButton;
/*Does a mouseDown.  whichButton should be MOUSE1, MOUSE2, or MOUSE3.*/
{
    int action;				/*The action to do*/
    struct tms buffer;
    long newTime;			/*The time of this click*/
    int newX, newY;			/*The position of this click*/
    FuncTyp actionMethod;		/*The method to call for the action*/

    curMouse = whichButton;

    FlushKeystrokes();

    if (!inputWindow || !GetWinInfo(inputWindow))
    {
	/*No focus; return*/
	return;
    }
    SelectWindow(inputWindow);
   
    if (!selWinInfo)
    {
	/*Pathological case.  Return.*/
	return;
    }

    interactiveMoving = true;

    /*Determine the action based on the mouse switchboard*/
    switch(whichButton)
    {
	case MOUSE1:
	    action = mouseSwitchboard[0];
	    break;
	case MOUSE2:
	    action = mouseSwitchboard[1];
	    break;
	case MOUSE3:
	    action = mouseSwitchboard[2];
	    break;
    }

    /*Determine if this is potentially a double click*/
    newTime = times(&buffer);
    newX = getvaluator(MOUSEX);
    newY = getvaluator(MOUSEY);
    if (newTime - lastClickTime < CLICK2TIME &&
	ABS(newX - lastClickX) < CLICK2DIST &&
	ABS(newY - lastClickY) < CLICK2DIST)
    {
	globalEventFlags |= F_DOUBLECLICK;
    }

    lastClickX = newX;
    lastClickY = newY;
    lastClickTime = newTime; 

    /*Do the action*/
    switch(action)
    {
	case MOUSEROTATE:
	    actionMethod = GetMethod((ObjPtr) selWinInfo, PRESS);
	    if (actionMethod)
	    {
		/*There's a press routine.  Call it.*/
		curIntWindow = selWinInfo;
		if (contextHelp)
		{
		    (*actionMethod)(selWinInfo, T_HELP | globalEventFlags);
		    contextHelp = false;
		    MySetCursor(0);
		}	
		else
		{
		    (*actionMethod)(selWinInfo, T_ROTATE | globalEventFlags);
		}
		curIntWindow = 0;
	    }
	    break;
	case MOUSEPRESS:
	    if (dragBuffer)
	    {
		dropX = getvaluator(MOUSEX);
		dropY = getvaluator(MOUSEY);
		MySetCursor(0);
	    }
	    actionMethod = GetMethod((ObjPtr) selWinInfo, PRESS);
	    if (actionMethod)
	    {
		/*There's a press routine.  Call it.*/
		curIntWindow = selWinInfo;
		if (contextHelp)
		{
		    (*actionMethod)(selWinInfo, T_HELP | globalEventFlags);
		    contextHelp = false;
		    MySetCursor(0);
		}	
		else
		{
		    (*actionMethod)(selWinInfo, T_PRESS | globalEventFlags);
		}
		curIntWindow = 0;
	    }
	    if (dragBuffer)
	    {
		DeleteThing(dragBuffer);
		dragBuffer = 0;
	    }

	    break;
	case MOUSEMENU:
	    if (!selWinInfo -> mainMenu)
	    {
		/*There's no menu.  Try to build one.*/
		BuildMenu(selWinInfo);
	    }
	    if (selWinInfo -> mainMenu)
	    {
		/*There's a menu.  Do it.*/
		curIntWindow = selWinInfo;
		dopup(selWinInfo -> mainMenu);
	    }
	    break;
    }
    interactiveMoving = false;
}
#endif

#ifdef IRISNTSC
void SetNTSC()
/*Sets to NTSC mode*/
{
    NTSCOn = true;
#ifdef GRAPHICS
    setmonitor(NTSC);
#ifdef GL4D
    setvideo(CG_MODE, CG2_M_MODE2);
    setvideo(DE_R1, DER1_G_170);
#endif
#endif
}

void Set60()
/*Sets to 60 Hz mode*/
{
    NTSCOn = false;
#ifdef GRAPHICS
    setmonitor(HZ60);
#endif
}

void ToggleNTSC()
/*Toggles in and out of NTSC mode*/
{
    NTSCOn = NTSCOn ? false : true;
#ifdef GRAPHICS
    setmonitor(NTSCOn ? NTSC : HZ60);
#ifdef GL4D
    if (NTSCOn)
    {
	setvideo(CG_MODE, CG2_M_MODE2);
	setvideo(DE_R1, DER1_G_170);
    }
#endif
#endif
}
#endif

Bool AltDown()
/*Returns true iff the alt key is down*/
{
#ifdef INTERACTIVE
    return (getbutton(LEFTALTKEY) || getbutton(RIGHTALTKEY) ||
	    getbutton(LEFTCTRLKEY) || getbutton(RIGHTCTRLKEY)) ? true : false;
#else
    return false;
#endif
}

#ifdef INTERACTIVE
void SetFlags()
/*Sets the event flags*/
{
    globalEventFlags = 0;

    /*Determine if the modifier keys are held down*/
    if (getbutton(LEFTSHIFTKEY) || getbutton(RIGHTSHIFTKEY))
    {
	globalEventFlags |= F_SHIFTDOWN;
    }
    if (getbutton(LEFTCTRLKEY) || getbutton(RIGHTCTRLKEY) || getbutton(CAPSLOCKKEY))
    {
	globalEventFlags |= F_OPTIONDOWN;
    }
    if (AltDown())
    {
	globalEventFlags |= F_OPTIONDOWN;
    }
}
#endif


#ifdef PROTO
Bool OneEvent(Bool processInput)
#else
Bool OneEvent(processInput)
Bool processInput;
#endif
/*Gets and processes one event.  if processInput is true, process input*/
{
    Bool readFromScript = true;
    int k;

    InhibitLogging(true);
    /*Do the messages remaining*/
    if (defMesLeft)
    {
	for (k = 0; k < defMesLeft; ++k)
	{
	    FuncTyp method;
	    method = GetMethod(defMessages[k] . object, defMessages[k] . message);
	    if (method)
	    {
		(*method)(defMessages[k] . object);
	    }
	}
	defMesLeft = 0;
    }
    InhibitLogging(false);
    
    /*Do a task that's waiting*/
    if (tasksLeft)
    {
	for (k = 0; k < tasksLeft; ++k)
	{
	    (*(doTasks[k]))();
	}
	tasksLeft = 0;
    }

#ifdef INTERACTIVE
    /*Look for a user event*/
    if (qtest())
    {
        long whichDevice;
        short theData;

	readFromScript = false;
        whichDevice = qread(&theData);

        switch (whichDevice)
        {
	    case INPUTCHANGE:
		if (theData)
		{
		    /*Changed windows, reset the moving quality to highest*/
		    ResetMovingQuality();
		    inputWindow = theData;
		}
		break;
            case KEYBD:
		SetFlags();
		if (processInput)
		{
                    KeyDown(theData);
		}
		break;
	    case MOUSE1:
	    case MOUSE2:
	    case MOUSE3:
		SetFlags();
		if (theData && processInput)
		{
		    MouseDown(whichDevice);
		}
		break;
	    case REDRAW:
		{
		    Screencoord l1, r1, b1, t1, l2, r2, b2, t2;
		    long sx, sy, ox, oy;
		    SelectWindow(theData);
		    
		    if (!selWinInfo)
		    {
			SelectWindow(0);
			break;
		    }
		    getviewport(&l1, &r1, &b1, &t1);

		    reshapeviewport();
		    getviewport(&l2, &r2, &b2, &t2);

		    /*Stuff ol, or, ob, ot*/
		    getorigin(&ox, &oy);
		    getsize(&sx, &sy);
		    ((WinInfoPtr) selWinInfo) -> ol = ((WinInfoPtr) selWinInfo) -> nl;
		    ((WinInfoPtr) selWinInfo) -> or = ((WinInfoPtr) selWinInfo) -> nr;
		    ((WinInfoPtr) selWinInfo) -> ob = ((WinInfoPtr) selWinInfo) -> nb;
		    ((WinInfoPtr) selWinInfo) -> ot = ((WinInfoPtr) selWinInfo) -> nt;
		    ((WinInfoPtr) selWinInfo) -> nl = ox;
		    ((WinInfoPtr) selWinInfo) -> nr = ox + sx - 1;
		    ((WinInfoPtr) selWinInfo) -> nb = oy;
		    ((WinInfoPtr) selWinInfo) -> nt = oy + sy - 1;

		    if (l1 != l2 || r1 != r2 || b1 != b2 || t1 != t2)
		    {
			if (logging)
			{
			    long ox, oy, sx, sy;
			    char cmd[400];
			    getorigin(&ox, &oy);
			    getsize(&sx, &sy);
			    sprintf(cmd, "locate %d %d %d %d\n",
				ox, ox + sx, oy, oy + sy);
			    Log(cmd);
			}
			ReshapeWindow((ObjPtr) selWinInfo, l1, r1, b1, t1);
		    }

		    if (selWinInfo)
		    {
			/*The window has been moved.  Both buffers are bad*/
			SetVar((ObjPtr) selWinInfo, PICSTATE, NewInt(FBBB));
		    }
		}
		break;
	    case PIECECHANGE:
	    case WINTHAW:
		{
		    SelectWindow(theData);

		    reshapeviewport();
		    if (selWinInfo)
		    {
			/*Both buffers are bad*/
			SetVar((ObjPtr) selWinInfo, PICSTATE, NewInt(FBBB));
		    }
		}
		break;
	    case UPARROWKEY:
		SetFlags();
		if (processInput && theData)
		{
		    KeyDown(K_UPARROW);
		}
		break;
	    case DOWNARROWKEY:
		SetFlags();
		if (processInput && theData)
		{
		    KeyDown(K_DOWNARROW);
		}
		break;
	    case LEFTARROWKEY:
		SetFlags();
		if (processInput && theData)
		{
		    KeyDown(K_LEFTARROW);
		}
		break;
	    case RIGHTARROWKEY:
		SetFlags();
		if (processInput && theData)
		{
		    KeyDown(K_RIGHTARROW);
		}
		break;
	    case BUT157:
		SetFlags();
		if (processInput && theData && inputWindow && GetWinInfo(inputWindow))
		{
		    SelectWindow(inputWindow);
		    SaveScreen(GetWinInfo(inputWindow), globalEventFlags);
		}
		break;
	    case PADPF1:
	    case F1KEY:
		SetContextSensitiveHelp();
		break;
	    case PADPF2:
	    case F2KEY:
		SetFlags();
		if (theData && processInput)
		{
		    CutText();
		}
		break;
	    case PADPF3:
	    case F3KEY:
		SetFlags();
		if (theData && processInput)
		{
		    CopyText();
		}
		break;
	    case PADPF4:
	    case F4KEY:
		SetFlags();
		if (theData && processInput)
		{
		    PasteText();
		}
		break;
	    case F5KEY:
		SetFlags();
		if (theData && processInput)
		{
		    DoShowControls();
		}
		break;
	    case F6KEY:
		SetFlags();
		if (theData && processInput)
		{
		    VisObjects();
		}
		break;
	    case F7KEY:
		SetFlags();
		if (theData && processInput)
		{
		    VisObjectsAs();
		}
		break;
	    case F8KEY:
		SetFlags();
		if (theData && processInput)
		{
		    ModifyDatasets();
		}
		break;
	    case F9KEY:
		SetFlags();
		if (theData && processInput)
		{
		    DoPickUpObjects();
		}
		break;
	    case F10KEY:
		SetFlags();
		if (theData && processInput)
		{
		    DoSelectAllIcons();
		}
		break;
	    case F11KEY:
		SetFlags();
		if (theData && processInput)
		{
		    DoDeselectAllIcons();
		}
		break;
#ifdef IRISNTSC
	    case F12KEY:
		SetFlags();
		if (theData && processInput)
		{
		    ToggleNTSC();
		}
		globalEventFlags = 0;
		break;
#endif
#ifdef GL4D
	    case WINSHUT:
		if (processInput)
		{
		    SelectWindow(theData);
		    if (theData)
		    {
			DisposeWindow((long) theData);
		    }
		}
		break;
#endif
	}
    }
    else
#endif
    {
	/*If there's an object to drop, drop it.*/
	if (dropObject)
	{
	    if (inputWindow && GetWinInfo(inputWindow))
	    {
		int left, right, bottom, top;
		int ox, oy;

		SelectWindow(inputWindow);
		GetWindowBounds(&left, &right, &bottom, &top);
		GetWindowOrigin(&ox, &oy);
		dropX -= ox;
		dropY -= oy;

		if (dropX >= left && dropX <= right &&
		    dropY >= bottom && dropY <= top)
		{
		    FuncTyp method;
		    /*Drop*/
		    method = GetMethod((ObjPtr) selWinInfo, DROPOBJECTS);
		    if (method)
		    {
			if (logging)
			{
			    char cmd[256];
			    sprintf(cmd, "drop %d %d\n", dropX, dropY);
			    Log(cmd);
			    InhibitLogging(true);
			}
			
			(*method)(selWinInfo, dropObject, dropX, dropY);
			if (logging)
			{
			    InhibitLogging(false);
			}
		    }
		}
	    }
	    DeleteThing(dropObject);
	    dropObject = NULLOBJ;
	}
	
	/*Idle the windows*/
	readFromScript = IdleAllWindows() ? false : true;

        if (readFromScript)
	{
	    if (curScript)
	    {
		if ((!lineAccepted || fgets(scriptLine, 254, curScript)) &&
			!abortScript)
		{
		    lineAccepted = InterpretScriptLine(scriptLine);
		}
		else
		{
		    if (abortScript)
		    {
			fprintf(stderr, "Aborting script.\n");
		    }
		    fclose(curScript);
		    EndScript();
		    curScript = 0;
		}
	    }
	    else
	    {
		/*Idle sockets*/
		IdleSockets();
	    }
	}
	IdleTimers();

#ifdef INTERACTIVE
	/*See if we need to send a last keypress*/
	if (sentKey)
	{
	    long newTime;
	    struct tms buffer;
	    newTime = times(&buffer);
	    if (newTime - lastKeyTime > CLICK2TIME)
	    {
		long tempInput;
		tempInput = inputWindow;
		inputWindow = keyWindow;
		KeyDown(0);
		sentKey = false;
		inputWindow = tempInput;
	    }
	}
#endif
#if 0
	if (TrashDayFlag || false == GetPrefTruth(PREF_RECKLESSGC)))
	{
	    TrashDay();
	} 
#else
	TrashDay();
#endif
    }
}

void MainLoop()
/*Main loop for scian*/
{
    SetSystemClock(0.0);
    if (curScript)
    {
	BeginScript();
    }
    while (running)
    {
	EndLongOperation();
	OneEvent(true);
    }
}

void InitEvents()
{
}

void KillEvents()
{
}
