/*logoDisplay.c
  Eric Pepke
  Display portion of logo program
*/

#include "Scian.h"
#include "ScianSCRILogo.h"

#define PI	3.14159265


DrawQtLogo(sharpX, sharpY, roundX, roundY)
Coord sharpX, sharpY, roundX, roundY;
/*Draws a quarter logo from sharpX, sharpY to roundX, roundY*/
{
    Icoord isX, isY, irX, irY;
    Coord arcX, arcY;
    float width, height;	/*Width and height of the logo*/

    /*Truncate the corners*/
    isX = sharpX;
    isY = sharpY;
    irX = roundX;
    irY = roundY;
    sharpX = isX;
    sharpY = isY;
    roundX = irX;
    roundY = irY;

    /*Calculate width of the logo bit, absolute*/
    width = roundX - sharpX;
    if (width < 0.0) width = -width;

    /*Do sharp corner*/
    rectf(sharpX, sharpY, 
	  roundX, (Coord) (sharpY + (roundY - sharpY) * LOGOTHICK));
    rectf(sharpX, sharpY,
	  (Coord) (sharpX + (roundX - sharpX) * LOGOTHICK), roundY);

    /*Do arms up until round corner and an arc there*/
    arcX = sharpX + (roundX - sharpX) *
		(1.0 - (1.0 + SQ2) * LOGORADIUS - SQ22 * LOGOSLANT);
    arcY = roundY - (roundY - sharpY) * LOGORADIUS;

    rectf(sharpX, roundY, arcX, roundY - (roundY - sharpY) * LOGOTHICK);

    circf(arcX, arcY, (Coord) (LOGORADIUS * width));

    /*Draw the final arm*/
    pmv(arcX - (roundX - sharpX) * SQ22 * (LOGOTHICK - LOGORADIUS),
	arcY + (roundY - sharpY) * SQ22 * (LOGOTHICK - LOGORADIUS), 0.0);
    rpdr(LOGOARM * (sharpX - roundX), LOGOARM * (sharpY - roundY), 0.0);
    rpdr(SQ22 * LOGOTHICK * (roundX - sharpX), 
	 SQ22 * LOGOTHICK * (sharpY - roundY), 0.0);
    rpdr(LOGOARM * (roundX - sharpX), LOGOARM * (roundY - sharpY), 0.0);
    pdr(arcX - (roundX - sharpX) * SQ22 * (LOGOTHICK - LOGORADIUS),
	arcY + (roundY - sharpY) * SQ22 * (LOGOTHICK - LOGORADIUS), 0.0);
    pclos();

    arcY = sharpY + (roundY - sharpY) *
		(1.0 - (1.0 + SQ2) * LOGORADIUS - SQ22 * LOGOSLANT);
    arcX = roundX - (roundX - sharpX) * LOGORADIUS;

    rectf(roundX, sharpY, roundX - (roundX - sharpX) * LOGOTHICK, arcY);

    circf(arcX, arcY, (Coord) (LOGORADIUS * width));

    /*Draw the final arm*/
    pmv(arcX + (roundX - sharpX) * SQ22 * (LOGOTHICK - LOGORADIUS),
	arcY - (roundY - sharpY) * SQ22 * (LOGOTHICK - LOGORADIUS), 0.0);
    rpdr(LOGOARM * (sharpX - roundX), LOGOARM * (sharpY - roundY), 0.0);
    rpdr(SQ22 * LOGOTHICK * (sharpX - roundX), 
	 SQ22 * LOGOTHICK * (roundY - sharpY), 0.0);
    rpdr(LOGOARM * (roundX - sharpX), LOGOARM * (roundY - sharpY), 0.0);
    pdr(arcX + (roundX - sharpX) * SQ22 * (LOGOTHICK - LOGORADIUS),
	arcY - (roundY - sharpY) * SQ22 * (LOGOTHICK - LOGORADIUS), 0.0);
    pclos();
}


DrawLogo(left, right, bottom, top)
Coord left, right, bottom, top;
/* Draws the SCRI logo inside the given rectangle */
{
    DrawQtLogo(	(Coord) left,
	       	(Coord) bottom,
		(Coord) (left + (right - left) * 0.5 * (1.0 - LOGOGAP)),
		(Coord) (bottom + (top - bottom) * 0.5 * (1.0 - LOGOGAP)));
    DrawQtLogo( (Coord) right,
		(Coord) bottom,
		(Coord) (left + (right - left) * 0.5 * (1.0 + LOGOGAP)),
		(Coord) (bottom + (top - bottom) * 0.5 * (1.0 - LOGOGAP)));
    DrawQtLogo( (Coord) left,
		(Coord) top,
		(Coord) (left + (right - left) * 0.5 * (1.0 - LOGOGAP)),
		(Coord) (bottom + (top - bottom) * 0.5 * (1.0 + LOGOGAP)));
    DrawQtLogo( (Coord) right,
		(Coord) top,
		(Coord) (left + (right - left) * 0.5 * (1.0 + LOGOGAP)),
		(Coord) (bottom + (top - bottom) * 0.5 * (1.0 + LOGOGAP)));
}


