/*ScianThingLists.h
  External stuff for lists of things.
*/

typedef struct objlist			/*List of objects*/
    {
	struct objlist *next;		/*Next thing in list*/
	ThingPtr thing;		/*This thing*/
    } ThingListElement, *ThingListPtr;

typedef struct
    {
	Thing thing;			/*The thing part, containing flags*/
	ThingListPtr list;		/*The list, initially 0*/
    } List, *LPtr;

#define LISTOF(l) (((LPtr) l) -> list)

#ifdef PROTO
ObjPtr NewList(void);
Bool PrefixList(ObjPtr, ThingPtr);
Bool PostfixList(ObjPtr, ThingPtr);
int DeleteFromList(ObjPtr, ThingPtr);
void DisposeList(ObjPtr);
int ListCount(ObjPtr);
ObjPtr GetListElem(ObjPtr, int);
void DrawList(ObjPtr);
ObjPtr PressList(ObjPtr, int, int, long);
ObjPtr DropList(ObjPtr, ObjPtr, int, int);
ObjPtr KeyDownList(ObjPtr, short, int);
void InitLists(void);
void KillLists(void);
Bool AppendList(ObjPtr, ObjPtr);
Bool InsertList(ThingListPtr, ObjPtr);
#else
ObjPtr NewList();
Bool PrefixList();
Bool PostfixList();
int DeleteFromList();
void DisposeList();
int ListCount();
ObjPtr GetListElem();
void DrawList();
ObjPtr PressList();
ObjPtr DropList();
ObjPtr KeyDownList();
void InitLists();
void KillLists();
Bool AppendList(ObjPtr, ObjPtr);
Bool InsertList();
#endif

