/*ScianDatasets.h
  Eric Pepke
  August 17, 1990
  External stuff for Datasets window
*/

extern ObjPtr data3DScalar, data2DScalar, data1DVector, data3DUnstructSurface;
extern ObjPtr dataFormClass, datasetClass, filterClass;
extern ObjPtr geometryClass;			/*Class for geometry object*/


extern ObjPtr iconDataset;
extern ObjPtr icon1DVector, icon2DVector, icon3DVector, icon4DVector;
extern ObjPtr icon1DScalar, icon2DScalar, icon3DScalar, icon4DScalar;
extern ObjPtr iconColorPalette;

extern Bool onePalette;

/*Flags for dataset info*/
#define DS_HASFORM		1	/*Dataset has a dataform*/
#define DS_HASFIELD		2	/*Dataset has a field*/
#define DS_HASGEOMETRY		4	/*Dataset has geometry*/
#define DS_UNSTRUCTURED		8	/*The data form is unstructured*/
#define DS_TIMEDEPENDENT	16	/*Dataset is time-dependent*/
#define DS_VECTOR		32	/*Field is a vector field, not scalar*/

#define FORMFIELD		0	/*Default number for a data form dataset*/
#define FIELD1			1
#define FIELD2			2
#define FIELD3			3
#define FIELD4			4
#define MAXNCURFIELDS		8	/*Maximum number of current datasets*/

/*Component flags*/
#define CF_MONOTONIC		1	/*Component is monotonic*/
#define CF_NOTMONOTONIC		2	/*Component is not monotonic*/

typedef struct
    {
	real *data;		/*Pointer to the data*/
	int nIndices;		/*Number of topological indices*/
	int *indices;		/*Numbers of the indices required*/
	long *dimensions;	/*Dimensions of the component*/
	long *steps;		/*Steps into the indices*/
	int flags;		/*Flags for the component*/
    } Component;

typedef struct
    {
	int topDim;		/*Topological dimension of this field*/
	int nComponents;	/*Number of components of this field*/
	Component *components;	/*Components in the field*/
    } DatasetBuffer;

extern Bool timedDatasets;	/*Flag for timed datasets*/
extern DatasetBuffer curFields[MAXNCURFIELDS];
#define EqualForm(a, b) Equal(a, b)

#ifdef PROTO
WinInfoPtr NewDatasetsWindow(void);
ObjPtr GetMinMax(ObjPtr);
void InitDataSets(void);
void KillDataSets(void);
Bool SetRefField(ObjPtr);
Bool RegisterComponent(int, int, ObjPtr);
real GetClosest3Sample(real x, real y, real z);
Bool RegisterDataset(ObjPtr);
real *GetScalarDataPtr(ObjPtr);

int GetTopDim(ObjPtr);
long GetDatasetInfo(ObjPtr);
int GetSpatialDim(ObjPtr);
ObjPtr GetDatasetNodes(ObjPtr);
ObjPtr GetDatasetKEdges(ObjPtr, int);
ObjPtr GetDatasetFormBounds(ObjPtr);
ObjPtr GetDatasetFormDims(ObjPtr);

void ReportFileFormatError(void);
WinInfoPtr DatasetsWindow(void);
Bool SetCurField(int, ObjPtr);
Bool SetCurForm(int, ObjPtr);
real SelectFieldComponent(int, int, long *);
real InterpolateFieldComponent(int, int, real *);
long GetComponentOffset(int, int, long indices[]);
void PutFieldComponent(int, int, long *, real);
void StuffScalarIJSquare(real dest[2][2], int whichField, long indices[]);
void StuffIJSquare(real dest[2][2], int whichField, int whichComponent, long indices[]);
void DatasetChanged(ObjPtr);
int GetNComponents(int);
int CountComponentDims(int, int);
long *GetComponentDims(int, int);
ObjPtr VisualizeButton(ObjPtr);
ObjPtr VisualizeAsButton(ObjPtr);
ObjPtr ShowControlsButton(ObjPtr);
ObjPtr ChangeIconButtons(ObjPtr);
ObjPtr ModifyButton(ObjPtr);
Bool FindClosestSample(int, int, long indices[], int, real sample[]);
Bool SampleToTopIndex(int, int, real indices[], int, real sample[]);
Bool SampleSpatField(int, int, int, real resultComp[], int, real spatIndices[], Bool);
ObjPtr GetLongName(ObjPtr);
ObjPtr NewDataset(void);
ObjPtr NewDataForm(void);
#else
WinInfoPtr NewDatasetsWindow();
ObjPtr GetMinMax();
void InitDataSets();
void KillDataSets();
Bool SetRefField();
Bool RegisterComponent();
real GetClosest3Sample();
Bool RegisterDataset();
real *GetScalarDataPtr();
long GetDatasetInfo();
ObjPtr GetDatasetNodes();
ObjPtr GetDatasetKEdges();
ObjPtr GetDatasetFormBounds();
ObjPtr GetDatasetFormDims();
void ReportFileFormatError();
WinInfoPtr DatasetsWindow();
Bool SetCurField();
Bool SetCurForm();
real SelectFieldComponent();
real InterpolateFieldComponent();
long GetComponentOffset();
void StuffScalarIJSquare();
void StuffIJSquare();
void PutFieldComponent();
void DatasetChanged();
int GetNComponents();
int CountComponentDims();
long *GetComponentDims();
ObjPtr VisualizeButton();
ObjPtr VisualizeAsButton();
ObjPtr ShowControlsButton();
ObjPtr ChangeIconButtons();
ObjPtr ModifyButton();
int GetDatasetSpatialDim();
Bool FindClosestSample();
Bool SampleSpatField();
ObjPtr GetLongName();
ObjPtr NewDataset();
ObjPtr NewDataForm();
#endif
