/*ScianTemplates.h
  Template stuff for SciAn controls
  Eric Pepke
  August 10, 1992
*/

typedef struct
    {
	char *name;
	int l, r, b, t;
    } Template, *TemplatePtr;

#ifdef PROTO
Bool GetTemplateBounds(TemplatePtr, char *, int *l, int *r, int *b, int *t);
ObjPtr TemplateTitleBox(TemplatePtr, char *);
ObjPtr TemplateRadioButton(TemplatePtr, char *);
ObjPtr TemplateCheckBox(TemplatePtr, char *, Bool);
ObjPtr TemplateTextBox(TemplatePtr, char *, int, char *);
ObjPtr TemplatePanel(TemplatePtr, char *);
ObjPtr TemplateColorBar(TemplatePtr, char *);
ObjPtr TemplateSlider(TemplatePtr template, char *name, int style);
ObjPtr TemplateColorWheel(TemplatePtr, char *);
ObjPtr TemplateIconButton(TemplatePtr, char *, int, int, int);
ObjPtr TemplateButton(TemplatePtr template, char *name);
ObjPtr TemplatePerspecControl(TemplatePtr template, char *name);
#else
Bool GetTemplateBounds();
ObjPtr TemplateTitleBox();
ObjPtr TemplateRadioButton();
ObjPtr TemplateCheckBox();
ObjPtr TemplateTextBox();
ObjPtr TemplatePanel();
ObjPtr TemplateColorBar();
ObjPtr TemplateSlider();
ObjPtr TemplateColorWheel();
ObjPtr TemplateIconButton();
ObjPtr TemplateButton();
ObjPtr TemplatePerspecControl();
#endif

