#include <stdio.h>
#include <gl.h>
#include <device.h>
#include "knobs.h"

/*
 *   Knobs: This subroutine package provides the 
 *   access to a standardized package of knobs dials
 *   and other things.
 */

int mouse_x, mouse_y;         /* Location of the mouse */
int mouse_state;              /* Button up or down */
int mouse_transition;         /* Is this a change? */
int KnobDB, KnobLUT;          /* Display modes */
int KnobLUTBase;              /* Base of lookup table */
short KnobRed[5]   = {200,150,100,0,255},   /* The colors */
      KnobGreen[5] = {200,150,100,0,0},
      KnobBlue[5]  = {200,150,100,0,0};

unsigned short
   checked[16] = {0x5555, 0xaaaa, 0x5555, 0xaaaa, 0x5555, 0xaaaa,
                  0x5555, 0xaaaa, 0x5555, 0xaaaa, 0x5555, 0xaaaa,
                  0x5555, 0xaaaa, 0x5555, 0xaaaa};

/*
 *   KnobInit: Initializes the knobs package.
 *
 *   Inputs:  map_location - Where in the LUT do we place
 *                           the map.
 */

KnobInit (map_location)

int map_location;     
{
   int mode;

   mode = getdisplaymode();
   if (mode == 1 || mode == 2)    /* Lookup tabled */
      KnobLUT = 1;
   else
      KnobLUT = 0;
   if (mode == 2 || mode == 5)    /* Double buffered */
      KnobDB = 1;
   else
      KnobDB = 0;

/*
 *   Load the lookup table if necessary
 */

   if (KnobLUT)   /* If we are lookup table driven */
   {
      if (map_location < 0)
         KnobLUTBase = (1 << getplanes()) + map_location - 5;
      else
         KnobLUTBase = map_location;

      mapcolor ((Colorindex) KnobLUTBase, KnobRed[0], KnobGreen[0],
                                          KnobBlue[0]);
      mapcolor ((Colorindex) (KnobLUTBase+1), KnobRed[1], KnobGreen[1],
                                              KnobBlue[1]);
      mapcolor ((Colorindex) (KnobLUTBase+2), KnobRed[2], KnobGreen[2],
                                              KnobBlue[2]);
      mapcolor ((Colorindex) (KnobLUTBase+3), KnobRed[3], KnobGreen[3],
                                              KnobBlue[3]);
      mapcolor ((Colorindex) (KnobLUTBase+4), KnobRed[4], KnobGreen[4],
                                              KnobBlue[4]);
   }

/*
 *   Set up the drop shadow pattern.
 */
   defpattern ((short) 1, (short) 16, checked);
/*
 *   And some mouse stuff
 */
   mouse_state = getbutton (MOUSEBUTTON);
   mouse_transition = 0;
}

/*
 *   Set the current operating color to the appropriate one.
 */

KnobColor (c)

int c;

{
   if (KnobLUT)
      color ((Colorindex) KnobLUTBase+c);
   else
      RGBcolor (KnobRed[c], KnobGreen[c], KnobBlue[c]);
}

/*
 *   KnobPanel: Draw the standard mitred control panel.
 */

KnobPanel (x,y,x_size,y_size)

int x,y,x_size,y_size;

{
      KnobColor (0);   /* Brightest */
      rectf ((Coord) x, (Coord) y, (Coord) (x + x_size), (Coord) (y + y_size));
      KnobColor (1);   /* Brighter */
      pmv2 ((Coord) (x + x_size), (Coord) y);
      pdr2 ((Coord) (x + x_size - MITRE), (Coord) (y + MITRE));
      pdr2 ((Coord) (x + x_size - MITRE), (Coord) (y + y_size - MITRE));
      pdr2 ((Coord) (x + x_size), (Coord) (y + y_size));
      pclos ();
      KnobColor (2);   /* Bright */
      pmv2 ((Coord) x, (Coord) y);
      pdr2 ((Coord) (x + MITRE), (Coord) (y + MITRE));
      pdr2 ((Coord) (x + x_size - MITRE), (Coord) (y + MITRE));
      pdr2 ((Coord) (x + x_size), (Coord) y);
      pclos ();
      KnobColor (3);
      rect  ((Coord) x, (Coord) y, (Coord) (x + x_size), (Coord) (y + y_size));
      move2 ((Coord) x, (Coord) y);
      draw2 ((Coord) (x + MITRE), (Coord) (y + MITRE));
      move2 ((Coord) (x + x_size), (Coord) y);
      draw2 ((Coord) (x + x_size - MITRE), (Coord) (y + MITRE));
      move2 ((Coord) (x + x_size), (Coord) (y + y_size));
      draw2 ((Coord) (x + x_size - MITRE), (Coord) (y + y_size - MITRE));
      move2 ((Coord) x, (Coord) (y + y_size));
      draw2 ((Coord) (x + MITRE), (Coord) (y + y_size - MITRE));
      rect  ((Coord) (x + MITRE), (Coord) (y + MITRE),
             (Coord) (x + x_size - MITRE), (Coord) (y + y_size - MITRE));
}

/*
 *   KnobShadow: Draw the drop shadow for a panel.
 */

KnobShadow (x, y, x_size, y_size)

int x,y,x_size,y_size;

{
      setpattern (1);
      KnobColor (3);   /* Darkest */
      rectf ((Coord) (x + DROPOFF), (Coord) (y - DROPOFF),
             (Coord) (x + x_size + DROPOFF), (Coord) (y + y_size - DROPOFF));
      setpattern (0);
}
