/*
 * raytrace.h
 *
 * Copyright (C) 1989, Craig E. Kolb
 *
 * This software may be freely copied, modified, and redistributed,
 * provided that this copyright notice is preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely .  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 * $Id: raytrace.h,v 1.1 1991/01/04 18:35:31 welling Exp $
 *
 * $Log: raytrace.h,v $
 * Revision 1.1  1991/01/04  18:35:31  welling
 * Initial revision
 *
 * Revision 3.0  89/10/27  02:06:03  craig
 * Baseline for first official release.
 * 
 */
typedef struct {
	float x, y, size;	/* location and size */
	ray_Color ul, ur, ll, lr;	/* Color values of four corners */
} pixel_square;

pixel_square *SquareStack;
double Minsquare;

/*
 * "Dither matrices" used to encode the 'number' of a ray that samples a
 * particular portion of a pixel.  Hand-coding is ugly, but...
 */
int OneSample[1] = 	{0};
int TwoSamples[4] =	{0, 2,
			 3, 1};
int ThreeSamples[9]= 	{0, 2, 7,
			 6, 5, 1,
			 3, 8, 4};
int FourSamples[16] =	{ 0,  8,  2, 10,
			 12,  4, 14,  6,
			  3, 11,  1,  9,
			 15,  7, 13,  5};
int FiveSamples[25] =	{ 0,  8, 23, 17,  2,
			 19, 12,  4, 20, 15,
			  3, 21, 16,  9,  6,
			 14, 10, 24,  1, 13,
			 22,  7, 18, 11,  5};
