/*
 * primobj.h
 *
 * Copyright (C) 1989, Craig E. Kolb
 *
 * This software may be freely copied, modified, and redistributed,
 * provided that this copyright notice is preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely .  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 * $Id: primobj.h,v 1.2 1991/04/10 13:29:46 welling Exp $
 *
 * $Log: primobj.h,v $
 * Revision 1.2  1991/04/10  13:29:46  welling
 * Changed Cylinder object so that only one transformation is saved, saving
 * space.
 *
 * Revision 1.1  91/01/04  18:35:30  welling
 * Initial revision
 * 
 * Revision 3.0.1.1  90/04/09  13:39:59  craig
 * patch5: New Cylinder and Cone types.
 * 
 * Revision 3.0  89/10/27  02:06:00  craig
 * Baseline for first official release.
 * 
 */

/*
 * Cylinder
 */
typedef struct cylinder	{
        ray_TransInfo world2obj;
} Cylinder;

typedef struct cone {
	double start_dist;
	ray_Trans trans;
} Cone;

/*
 * Sphere
 */
typedef struct {
	double r;		/* radius   */
	double x, y, z;		/* position */
} Sphere;

/*
 * Box
 */
typedef struct {
	double bounds[2][3];	/* Box corners */
} Box;

/*
 * Triangle
 */
typedef struct {
	ray_Vector nrm;		/* triangle normal */
	ray_Vector p1, p2, p3;	/* vertices */
	double d;		/* plane constant  */
	char index;		/* Flag used for shading/intersection test. */
	ray_Vector *vnorm;		/* Array of vertex normals */
	double *b;		/* Array of barycentric coordinates */
	ray_Vector e1, e2, e3;	/* edge vectors */
} Triangle;

/*
 * Polygon
 */
typedef struct {
	ray_Vector norm;	/* Normal to polygon */
	double d;		/* Plane constant */
	char index;		/* Which normal coord is "dominant"? */
	ray_Vector *points;	/* Array of vertices */
	int npoints;		/* Number of vertices */
} Polygon;

/*
 * Superquadric
 */
typedef struct {
	double bounds[2][3];	/* bounding box */
	double x, y, z;		/* Center */
	double pow;		/* Superquadric power */
	double a, b, c, r;
	double err;		/* Error constant */
} Superq;

/*
 * Plane
 */
typedef struct {
	ray_Vector norm;	/* Plane normal. */
	double d;	        /* Plane constant. */
} Plane;

/*
 * Height field gunk.
 */
typedef struct hfTri {
	ray_Vector v1, v2, v3, norm;
	double d;
	char type;
	struct hfTri *next, *prev;
} hfTri;

typedef struct {
	int len;
	hfTri *head, *tail;
} TriQueue;

typedef struct {
	float **data;		/* Altitude points */
	float minz, maxz;
	int size, *lsize;	/* # of points/side */
	int BestSize; 		/* "best" division size */
	float iBestSize;	/* inverse of above (for faster computation) */
	int levels;		/* log base BestSize of size */
	float ***boundsmax;	/* high data values at various resolutions. */
	float ***boundsmin;
	float *spacing;
	hfTri hittri, **q;	/* hit triangle and triangle cache */
	int qtail, qsize;	/* end and length of cache */
	double boundbox[2][3];	/* bounding box of HF */
} Hf;

/*
 * Primitive object.
 */
typedef struct ray_Primitive {
	char type;			/* object type */
	struct ray_Surface *surf;		/* default surface */
	union {
		Sphere		*p_sphere;
		Box 		*p_box;
		Triangle	*p_triangle;
		Superq		*p_superq;
		Plane		*p_plane;
		Cylinder	*p_cylinder;
		Polygon		*p_poly;
		Cone		*p_cone;
		Hf		*p_hf;
	} objpnt;	/* Pointer to primitive */
} ray_Primitive;
