/*
 * datatypes.h
 *
 * Copyright (C) 1989, Craig E. Kolb
 *
 * This software may be freely copied, modified, and redistributed,
 * provided that this copyright notice is preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely .  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 * $Id: datatypes.h,v 1.1 1991/01/04 18:35:26 welling Exp $
 *
 * $Log: datatypes.h,v $
 * Revision 1.1  1991/01/04  18:35:26  welling
 * Initial revision
 *
 * Revision 3.0.1.1  89/11/16  20:41:39  craig
 * patch1: Moved atmospheric declarations to atmosphere.h.
 * 
 * Revision 3.0  89/10/27  02:05:49  craig
 * Baseline for first official release.
 * 
 */

#ifdef NOVOID
typedef int void;
#endif

typedef struct {
	double u, v;			/* 2D point */
} ray_Vec2d;

typedef struct ray_Vector {
	double x, y, z;			/* 3D point */
} ray_Vector;

typedef struct ray_Ray {
	ray_Vector pos;			/* Origin */
	ray_Vector 	dir;			/* Direction */
	char shadow;
	struct ray_SurfaceList *media;	/* Medium ray is passing through */
} ray_Ray;

typedef struct ray_Color {
	double r, g, b;			/* Red, green, blue. */
} ray_Color;

typedef struct {
	double matrix[3][3];		/* Rotation matrix */
	ray_Vector translate;		/* Translation */
} ray_TransInfo;

typedef struct ray_Trans {
	ray_TransInfo world2obj,	/* worldspace --> object space */
		  obj2world;	/* object space --> world space */
} ray_Trans;

typedef struct {
	struct ray_ObjList *list;	/* List of prims/objs. in object */
	struct ray_ObjList *unbounded;	/* List of unbounded prims. */
	double bounds[2][3];		/* Bounding box of object */
} ray_List;

typedef struct {
	short xsize, ysize, zsize;	/* # of voxels along each axis */
	double bounds[2][3];		/* bounding box */
	double voxsize[3];		/* size of a voxel */
	struct ray_ObjList ****cells;	/* Voxels */
	struct ray_ObjList *unbounded;	/* Unbounded objects */
} ray_Grid;

/*
 * Surface definition.
 */
typedef struct ray_Surface {
	char *name;			/* Name */
	struct ray_Color amb;		/* Ambient color */
	struct ray_Color diff;		/* Diffuse color */
	struct ray_Color spec;		/* Specular color */
	double coef;			/* Phong shading coef. */
	double refl;			/* Reflectivity (0-1) */
	double transp;			/* Transparency (0-1) */
	double kref;			/* Index of refraction */
	double translucency;		/* translucency (0-1) */
	double stcoef;			/* Phong coef. for transmitted light */
} ray_Surface;

typedef struct ray_SurfaceList {
	ray_Surface *surf;
	struct ray_SurfaceList *next;
} ray_SurfaceList;

typedef struct ray_ObjList {
	struct ray_Object *data;		/* Pointer to object data */
	struct ray_ObjList *next;		/* Next in list */
} ray_ObjList;

typedef struct ray_PointList {
	ray_Vector vec;			/* Vector data */
	struct ray_PointList *next;		/* Next in list */
} ray_PointList;

/*
 * Data about point of intersection.
 * (May be modified by texture mapping.)
 */
typedef struct ray_HitInfo {
	ray_Vector	pos,		/* Location of intersection */
	                norm;		/* Normal to surface at int. point */
	struct ray_Primitive *prim;     /* Pointer to primitive hit. */
	struct ray_Surface surf;	/* Surface to be used. */
	ray_TransInfo *totaltrans;
} ray_HitInfo;

/*
 * General-purpose texture structure.  The (bad) idea is to
 * have one structure which every texturing function will use.
 */
typedef struct ray_Texture {
	char type;		/* Texture type */
	ray_Surface *surf1;	/* Alternate surface */
	double size;		/* Scale/size factor */
	double *args;		/* Random arguments. */
	ray_Color *colormap;	/* Colormap */
	ray_Trans *trans;		/* Transformation matrices. */
	struct ray_Texture *next;	/* Pointer to next texture. */
} ray_Texture;
