/****************************************************************************
 * parse.h
 * Author Chris Nuuja
 * Copyright 1989, Pittsburgh Supercomputing Center, Carnegie Mellon University
 *
 * Permission use, copy, and modify this software and its documentation
 * without fee for personal use or use within your organization is hereby
 * granted, provided that the above copyright notice is preserved in all
 * copies and that that copyright and this permission notice appear in
 * supporting documentation.  Permission to redistribute this software to
 * other organizations or individuals is not granted;  that must be
 * negotiated with the PSC.  Neither the PSC nor Carnegie Mellon
 * University make any representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or
 * implied warranty.
 *****************************************************************************/
#define	AllocPtrArray(type, num)    (type **)malloc((num) * sizeof(type *))

#define key_index_of(a)	    ( (int) (((a)->val).symbol.typeof_symbol) )

/*indentity macros*/
#define	is_lparen(c)	((c==(int)LEFT_PAREN_TK)||(c==(int)'('))
#define	is_rparen(c)	((c==(int)RIGHT_PAREN_TK)||(c==(int)')'))
#define	is_delimit(c)	(is_lparen(c)||is_rparen(c))

extern char token[];
extern char	linebuf[];
extern char	*tokchar;
extern char	*toklim;
extern int LINE_NUMBER;
extern char *CURRENT_FILE;
extern int CHAR_NUM;
extern unsigned short curr_arg;

typedef enum tok_enum {
    INT_TK=0, FLOAT_TK, SYMBOL_TK, LEFT_PAREN_TK, RIGHT_PAREN_TK, EOF_TK,
    STRING_TK, QUOTEMACRO_TK} TYPES_OF_TOKEN; 

/*these are all the states possible in the finite state
 *machine used in the lexer*/
enum state_enum {
    st_begin=0, st_iorf, st_float, st_exponent, st_exp2, st_callout,
    st_string, st_literal, st_name, st_sign, st_keyname, st_done, st_system
};

extern TYPES_OF_TOKEN TOKEN_TYPE;
extern KEY_TYPE SYMBOL_TYPE;
extern enum state_enum state;

/*identity macros*/
#define	white_space(c)	\
	((c==' ') || (c=='\t') || (c== '\n') || (c== '\f') || (c== '\r'))
#define	newline(c)	\
	((c== '\n') || (c== '\f') || (c== '\r'))
#define	is_word(c)	((c==(int)SYMBOL_TK) || (c==(int)STRING_TK))
#define	is_float(c)	((c==(int)FLOAT_TK))
#define	is_int(c)	((c==(int)INT_TK))
#define	is_number(c)	((is_float(c)) || (is_int(c)))

typedef struct{
    char *key_word;
    KEY_TYPE key_type;
}KEY_DATA;

/*accessing macros*/
#define	key_word_of(a)	    ((a)->key_word)
#define	key_type_of(a)	    ((a)->key_type)

/*global*/

extern KEY_DATA key_table[];

#define getkeyword(a)	    (key_word_of(key_table+a))
#define getkeytype(a)	    (key_type_of(key_table+a))

/*defstruct parsing elements*/
extern char	*defstruct_name;    /*used to hold name in defstruct*/
extern char	**defstruct_field;  /*used to hold field in defstruct*/
extern char	**defstruct_list;   /*to hold result of parse_defstruct()*/
extern int	field_num;	    /*number of fields in defstruct*/
extern short	wipeout;	    /*set when end of defstruct_list reached*/

/*New stuffs added for "load" statement*/
typedef struct g_files{
    FILE		*infile;
    int			print_flag;
    int			linenum;
    char                *filename;
    struct g_files	*nxt;
}G_FILES;

extern G_FILES	*f_stack;

#define	    Infile(a)	    ((a)->infile)
#define	    FileName(a)	    ((a)->filename)
#define	    FileLine(a)	    ((a)->linenum)
#define	    Nxt(a)	    ((a) = (a)->nxt)

extern void get_token();
extern void push_filestack();
extern void pop_filestack();
