/****************************************************************************
 * painter.h
 * Copyright 1989, Pittsburgh Supercomputing Center, Carnegie Mellon University
 * Author Chris Nuuja
 *
 * Permission use, copy, and modify this software and its documentation
 * without fee for personal use or use within your organization is hereby
 * granted, provided that the above copyright notice is preserved in all
 * copies and that that copyright and this permission notice appear in
 * supporting documentation.  Permission to redistribute this software to
 * other organizations or individuals is not granted;  that must be
 * negotiated with the PSC.  Neither the PSC nor Carnegie Mellon
 * University make any representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or
 * implied warranty.
 *****************************************************************************/

#ifndef HUGE
#define HUGE 1.0e30
#endif

void init_renderer();	
void shutdown_renderer();
#define poly_Xindex(x)	(PolyBuffer[x].x_index)
#define poly_Yindex(y)	(PolyBuffer[y].y_index)
#define poly_Zindex(z)	(PolyBuffer[z].z_index)
#define poly_ColorIndex(c)	(PolyBuffer[c].color)

/*  structure creation */
#ifndef NOMALLOCDEF
extern char *malloc();
#endif
extern void free();
extern ren_polytype   *makepoly_rec();
extern void   	      fillpoly_rec();
extern void   	      fillDpoly_rec();
extern ren_vectortype *makevector_rec();
extern int  makecolor_rec();
extern int  makeDcolor_rec();
extern ren_pointtype  *makepoint_rec();
extern ren_vectortype *make_directionvector();
extern void extend_buffers();
extern void free_polyrec();
extern int new_ObjectIndex();
extern int add_primitive();

/*	vector operations 	*/
extern void  calc_normal();
extern ren_vectortype  *trans_norm();
extern float vector_length();
extern float dotproduct();


/*	Matrix operations	*/
extern float *make3dScale();
extern float *make3dRotate();
extern float *make3dTrans();
extern float *mult3dMatrices();
extern void  append3dMatrices();
extern ren_vectortype *vector_matrix_mult3d();

/*	Top level render command 	*/
extern void render_primitive();
extern void ren_mesh();
extern void render_polyrec();

/* commands */
extern void tiltEye();
extern void panEye();
extern void rollEye();
extern void moveEye_UorD();
extern void moveEye_LorR();
extern void moveEye_ForB();

extern void changeFocal();
extern void ChangeLight();
extern void setLineElem();
extern void setSurfelem();

extern void Translate();
extern void Rotate();
extern void Scale();



/*  Clipping commands */
extern void clip_Zpolygon();
extern void clip_Zline();

/* lower level transformation commands */
extern void moveIRight();
extern void moveIUp();
extern void moveIForward();
extern void tiltI();
extern void panI();
extern void rollI();

/* Hash Table functions */
extern void hash_free();
extern Hash_result hash_add();
extern Hash_result hash_lkup();
