/****************************************************************************
 * flyby.c
 * Author Joel Welling
 * Copyright 1992, Pittsburgh Supercomputing Center, Carnegie Mellon University
 *
 * Permission use, copy, and modify this software and its documentation
 * without fee for personal use or use within your organization is hereby
 * granted, provided that the above copyright notice is preserved in all
 * copies and that that copyright and this permission notice appear in
 * supporting documentation.  Permission to redistribute this software to
 * other organizations or individuals is not granted;  that must be
 * negotiated with the PSC.  Neither the PSC nor Carnegie Mellon
 * University make any representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or
 * implied warranty.
 *****************************************************************************/
/* preamble text for flyby animations */

static char preamble[]= "\
;P3D 2.1 flyby of %s\n\
(load \"p3d.lsp\") \n\
\n\
(if (fboundp 'realsnap)\n\
  (pprint \"Warning- flyby within a flyby\")\n\
  (progn\n\
    (defun realsnap (object lights acamera) \n\
        (setq p3d-framenumber (+ p3d-framenumber 1)) \n\
	(set-camera acamera) \n\
	(traverselights lights (make-identity) p3d-default-attributes) \n\
	(render object (make-identity) p3d-default-attributes)) \n\
\n\
    (defun flysnap \n\
      (object lights fmx fmy fmz atx aty atz upx upy upz fovea hither yon) \n\
      (realsnap object lights \n\
        (make-camera :lookfrom (make-point :x fmx :y fmy :z fmz) \n\
		     :lookat (make-point :x atx :y aty :z atz) \n\
		     :up (make-vector :x upx :y upy :z upz) \n\
		     :fovea fovea \n\
		     :hither hither \n\
		     :yon yon))) \n\
\n\
(defun snap (object lights acamera)\n\
"; /* end of preamble */

